/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.auth;

import com.ericsson.ssa.dd.ResourceCollection;
import com.ericsson.ssa.dd.SecurityConstraint;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.sun.enterprise.security.SecurityContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.jvnet.glassfish.comms.security.auth.impl.DigestAuthenticator;
import org.jvnet.glassfish.comms.security.auth.impl.PAssertedAuthenticator;
import org.jvnet.glassfish.comms.security.authorize.SipResourcePermission;
import org.jvnet.glassfish.comms.security.authorize.SipRoleRefPermission;
import org.jvnet.glassfish.comms.security.authorize.SipUserDataPermission;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;

public final class AuthModule {
    private SipApplication sipApplicationModel;
    private HashMap<Key, ServletConstraints> servletConstraints = null;
    private PolicyBuilder policyUtil = new PolicyBuilder();
    private String contextId = null;
    private CodeSource codeSource = null;
    private Policy policy = null;

    public AuthModule(SipApplication am) {
        this.sipApplicationModel = am;
        this.policy = Policy.getPolicy();
        this.contextId = this.sipApplicationModel.getAppName();
        this.contextId = this.contextId + "/" + this.contextId;
        String code = this.removeSpaces(this.contextId);
        this.servletConstraints = new HashMap();
        URI uri = null;
        try {
            uri = new URI("file:///" + code);
            if (uri != null) {
                this.codeSource = new CodeSource(new URL(uri.toString()), (Certificate[])null);
            }
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
        catch (MalformedURLException mue) {
            throw new RuntimeException(mue);
        }
        Collection<SecurityConstraint> scCollection = this.sipApplicationModel.getSecurityConstraints();
        for (SecurityConstraint constraint : scCollection) {
            Collection resourceCollection = constraint.getResourceCollections();
            for (ResourceCollection rc : resourceCollection) {
                Collection sn = rc.getServletNames();
                Collection sm = rc.getSipMethods();
                Collection<String> roles = constraint.getAuthorizationConstraintRoleNames();
                for (String servletName : sn) {
                    for (String sipMethod : sm) {
                        Key key = new Key(servletName, sipMethod);
                        Set<Object> roleSet = null;
                        if (this.servletConstraints.containsKey(key)) {
                            ServletConstraints sc = this.servletConstraints.get(key);
                            roleSet = sc.roles;
                        } else {
                            roleSet = new HashSet();
                            boolean proxy = constraint.isProxyAuthenticated();
                            ServletConstraints sc = new ServletConstraints(proxy, roleSet);
                            this.servletConstraints.put(key, sc);
                        }
                        roleSet.addAll(roles);
                    }
                }
            }
        }
    }

    public final void authenticate(SipServletRequest request, String servletName) throws Exception {
        String authMethod;
        if (this.sipApplicationModel != null && (authMethod = this.sipApplicationModel.getLoginConfigAuthMethod()) != null && authMethod.length() != 0) {
            Principal authPrincipal;
            DigestAuthenticator auth;
            int statusCode = 401;
            boolean proxyAuthenticate = false;
            Key key = new Key(servletName, request.getMethod());
            if (this.servletConstraints.containsKey(key)) {
                ServletConstraints sc = this.servletConstraints.get(key);
                proxyAuthenticate = sc.proxy;
            }
            if (proxyAuthenticate) {
                statusCode = 407;
            }
            if ("DIGEST".equals(authMethod)) {
                auth = new DigestAuthenticator(this.sipApplicationModel.getLoginConfigRealmName());
                if (!auth.hasAuthorizationHeader(request)) {
                    SipServletResponseImpl resp = ((SipServletRequestImpl)request).createTerminatingResponse(statusCode);
                    auth.setAuthenticateHeader((SipServletResponse)resp, request, proxyAuthenticate);
                    resp.popDispatcher().dispatch(resp);
                    return;
                }
                Principal authPrincipal2 = auth.authenticate(request);
                if (authPrincipal2 != null) {
                    ((SipServletRequestImpl)request).setUserPrincipal(authPrincipal2);
                    ((SipServletRequestImpl)request).setUser(authPrincipal2.getName());
                }
            } else if ("P-Asserted".equals(authMethod) && (authPrincipal = (auth = new PAssertedAuthenticator(this.sipApplicationModel.getLoginConfigRealmName())).authenticate(request)) == null) {
                SipServletResponseImpl resp = ((SipServletRequestImpl)request).createTerminatingResponse(statusCode);
                resp.popDispatcher().dispatch(resp);
                return;
            }
        }
    }

    public boolean hasResourcePermissions(SipServletRequest request, String servletName) throws Exception {
        return this.hasResourcePermissions(request.getMethod(), servletName);
    }

    public boolean hasResourcePermissions(String sipMethod, String servletName) {
        try {
            SecurityContext secCtx = SecurityContext.getCurrent();
            this.policyUtil.setPolicyContext(this.contextId);
            Subject subject = secCtx.getSubject();
            Set<Principal> principalSet = subject.getPrincipals();
            Principal[] principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
            ProtectionDomain pd = new ProtectionDomain(this.codeSource, null, null, principals);
            SipResourcePermission srp = new SipResourcePermission(servletName, sipMethod);
            return this.policy.implies(pd, (Permission)srp);
        }
        catch (Throwable ex) {
            Logger.getLogger(AuthModule.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    public boolean checkServletConstraints(SipServletRequest request, String servletName) throws Exception {
        if (this.hasRoleRefPermission(request, servletName) && this.hasResourcePermissions(request, servletName)) {
            return true;
        }
        SipServletResponseImpl resp = ((SipServletRequestImpl)request).createTerminatingResponse(403);
        resp.popDispatcher().dispatch(resp);
        return false;
    }

    public boolean hasRoleRefPermission(SipServletRequest request, String servletName) {
        return this.hasRoleRefPermission(request.getMethod(), servletName);
    }

    public boolean hasRoleRefPermission(String sipMethod, String servletName) {
        String role;
        SipRoleRefPermission srp;
        SecurityContext secCtx = SecurityContext.getCurrent();
        try {
            this.policyUtil.setPolicyContext(this.contextId);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        Subject subject = secCtx.getSubject();
        Set<Principal> principalSet = subject.getPrincipals();
        Key key = new Key(servletName, sipMethod);
        ServletConstraints sc = this.servletConstraints.get(key);
        if (sc == null) {
            return false;
        }
        Set<String> roles = sc.roles;
        Iterator<String> roleItr = roles.iterator();
        boolean isInRole = false;
        Principal[] principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
        principals = principals;
        ProtectionDomain pd = new ProtectionDomain(this.codeSource, null, null, principals);
        while (roleItr.hasNext() && (isInRole = this.policy.implies(pd, (Permission)(srp = new SipRoleRefPermission(servletName, role = roleItr.next()))))) {
        }
        return isInRole;
    }

    public boolean hasUserDataPermissions(String servletName, String sipMethod, boolean isSecured) {
        SecurityContext secCtx = SecurityContext.getCurrent();
        try {
            this.policyUtil.setPolicyContext(this.contextId);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
        Subject subject = secCtx.getSubject();
        Set<Principal> principalSet = subject.getPrincipals();
        boolean isInRole = false;
        Principal[] principals = principalSet == null ? null : principalSet.toArray(new Principal[0]);
        ProtectionDomain pd = new ProtectionDomain(this.codeSource, null, null, principals);
        String transport = "NONE";
        if (isSecured) {
            transport = "CONFIDENTIAL";
        }
        HashSet<String> sm = new HashSet<String>();
        sm.add(sipMethod);
        SipUserDataPermission wdp = new SipUserDataPermission(servletName, sm, transport);
        return this.policy.implies(pd, (Permission)wdp);
    }

    private String removeSpaces(String withSpaces) {
        return withSpaces.replace(' ', '_');
    }

    public boolean needsAuthentication(String servletName, String sipMethod) {
        Key key = new Key(servletName, sipMethod);
        return this.servletConstraints.containsKey(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServletConstraints {
        boolean proxy = false;
        Set<String> roles = null;

        public ServletConstraints(boolean proxy, Set<String> roles) {
            this.proxy = proxy;
            this.roles = roles;
        }
    }

    class Key {
        String servletName = null;
        String methodName = null;
        int hashCode = -1;

        public Key() {
        }

        public Key(String servletName, String methodName) {
            this.servletName = servletName;
            this.methodName = methodName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.servletName != null && this.servletName.equals(key.servletName) && this.methodName != null && this.methodName.equals(key.methodName);
        }

        public int hashCode() {
            if (this.hashCode == -1) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.servletName);
                builder.append(this.methodName);
                this.hashCode = builder.toString().hashCode();
            }
            return this.hashCode;
        }

        public void reset() {
            this.servletName = null;
            this.methodName = null;
        }
    }
}

