/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.auth;

import com.ericsson.ssa.dd.ResourceCollection;
import com.ericsson.ssa.dd.SecurityConstraint;
import com.ericsson.ssa.dd.SecurityRole;
import com.ericsson.ssa.dd.SecurityRoleReference;
import com.ericsson.ssa.dd.Servlet;
import com.ericsson.ssa.dd.SipApplication;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jvnet.glassfish.comms.security.authorize.SipResourcePermission;
import org.jvnet.glassfish.comms.security.authorize.SipRoleRefPermission;
import org.jvnet.glassfish.comms.security.authorize.SipUserDataPermission;
import org.jvnet.glassfish.comms.security.util.PolicyBuilder;

public class DescriptorProcessor {
    private static String[] sipMethods = new String[]{"INVITE", "CANCEL", "REGISTER", "ACK", "OPTIONS", "INFO"};

    public void process(SipApplication sipConfig) {
        Collection<SecurityConstraint> constraints = sipConfig.getSecurityConstraints();
        Iterator<SecurityConstraint> itr = constraints.iterator();
        HashMap<Key, ServletActions> reslist = new HashMap<Key, ServletActions>();
        HashMap roleList = new HashMap();
        String contextId = sipConfig.getAppName();
        contextId = contextId + "/" + contextId;
        Key key = new Key();
        Map<String, SecurityRole> roleMap = sipConfig.getSecurityRoles();
        HashMap<String, TransportConstraints> userDataConsTable = new HashMap<String, TransportConstraints>();
        HashMap restrictedActionList = new HashMap();
        while (itr.hasNext()) {
            SecurityConstraint sc = itr.next();
            Collection resources = sc.getResourceCollections();
            Collection<String> roles = sc.getAuthorizationConstraintRoleNames();
            String transportType = sc.getUserDataTransportGuarantee();
            for (ResourceCollection rc : resources) {
                Collection snColl = rc.getServletNames();
                Collection smColl = rc.getSipMethods();
                Iterator snItr = snColl.iterator();
                Iterator smItr = smColl.iterator();
                Iterator<String> roleItr = roles.iterator();
                Object servletRoles = null;
                while (roleItr.hasNext()) {
                    String roleName = roleItr.next();
                    if (!roleMap.containsKey(roleName)) continue;
                    key.roleName = roleName;
                    while (snItr.hasNext()) {
                        String servletName;
                        key.servletName = servletName = (String)snItr.next();
                        if (!restrictedActionList.containsKey(servletName)) {
                            restrictedActionList.put(servletName, new HashSet());
                        }
                        ServletActions servletActions = null;
                        TransportConstraints tc = null;
                        if (transportType != null) {
                            if (userDataConsTable.containsKey(servletName)) {
                                tc = (TransportConstraints)userDataConsTable.get(servletName);
                            } else {
                                tc = new TransportConstraints(servletName);
                                userDataConsTable.put(servletName, tc);
                            }
                            tc.setType(transportType);
                        }
                        if (reslist.containsKey(key)) {
                            servletActions = (ServletActions)reslist.get(key);
                        } else {
                            servletActions = new ServletActions(servletName);
                            reslist.put(new Key(key.servletName, key.roleName), servletActions);
                        }
                        while (smItr.hasNext()) {
                            String smName = (String)smItr.next();
                            servletActions.setAction(smName);
                            Set resActions = (Set)restrictedActionList.get(servletName);
                            resActions.add(smName);
                            if (tc == null) continue;
                            tc.setAction(smName);
                        }
                    }
                }
            }
        }
        Set resKeys = reslist.keySet();
        Iterator keyItr = resKeys.iterator();
        HashMap<String, Permissions> permCollection = new HashMap<String, Permissions>();
        PolicyBuilder util = new PolicyBuilder();
        try {
            PolicyConfiguration pc = util.getInstance(contextId);
            while (keyItr.hasNext()) {
                key = (Key)keyItr.next();
                ServletActions sa = (ServletActions)reslist.get(key);
                SipResourcePermission srp = new SipResourcePermission(key.servletName, sa.actions);
                Permissions p = null;
                if (permCollection.containsKey(key.roleName)) {
                    p = (Permissions)permCollection.get(key.roleName);
                } else {
                    p = new Permissions();
                    permCollection.put(key.roleName, p);
                }
                p.add((Permission)srp);
                pc.addToRole(key.roleName, (Permission)new SipRoleRefPermission(key.servletName, key.roleName));
            }
            for (String role : permCollection.keySet()) {
                Permissions perms = (Permissions)permCollection.get(role);
                pc.addToRole(role, (PermissionCollection)perms);
            }
            Map<String, Servlet> servlets = sipConfig.getServlets();
            for (Servlet servlet : servlets.values()) {
                String servletName = servlet.getServletName();
                Collection<SecurityRoleReference> srRef = servlet.getSecurityRoleReferences();
                if (srRef == null) continue;
                for (SecurityRoleReference srr : srRef) {
                    String roleLink = srr.getRoleLink();
                    String roleName = srr.getRoleName();
                    SipRoleRefPermission srp = new SipRoleRefPermission(servletName, roleName);
                    pc.addToRole(roleLink, (Permission)srp);
                }
            }
            Permissions udcPermList = new Permissions();
            for (TransportConstraints tcValue : userDataConsTable.values()) {
                SipUserDataPermission wdp = new SipUserDataPermission(tcValue.servletName, tcValue.actions, tcValue.getType());
                udcPermList.add((Permission)wdp);
            }
            Map<String, Servlet> servletList = sipConfig.getServlets();
            for (String sn : servletList.keySet()) {
                Set ral = (Set)restrictedActionList.get(sn);
                HashSet<String> allowedActions = new HashSet<String>();
                if (ral == null) {
                    for (int i = 0; i < sipMethods.length; ++i) {
                        allowedActions.add(sipMethods[i]);
                    }
                    continue;
                }
                for (int i = 0; i < sipMethods.length; ++i) {
                    if (ral.contains(sipMethods[i])) continue;
                    allowedActions.add(sipMethods[i]);
                }
                SipResourcePermission srp = new SipResourcePermission(sn, allowedActions);
                udcPermList.add((Permission)srp);
            }
            pc.addToUncheckedPolicy((PermissionCollection)udcPermList);
            pc.commit();
        }
        catch (PolicyContextException pce) {
            pce.printStackTrace();
        }
        sipConfig.getSecurityRoles();
    }

    class TransportConstraints
    extends ServletActions {
        String transportType;

        public TransportConstraints(String servletName) {
            super(servletName);
            this.transportType = null;
        }

        public void setType(String type) {
            this.transportType = type;
        }

        public String getType() {
            return this.transportType;
        }
    }

    class ServletActions {
        String servletName = "";
        Set<String> actions = new HashSet<String>();
        Set<String> roles = new HashSet<String>();

        public ServletActions(String servletName) {
            this.servletName = servletName;
        }

        public void setServletName(String sn) {
            this.servletName = sn;
        }

        public void setAction(String action) {
            this.actions.add(action);
        }

        public void setRole(String rn) {
            this.roles.add(rn);
        }
    }

    class Key {
        String servletName = null;
        String roleName = null;

        public Key() {
        }

        public Key(String servletName, String roleName) {
            this.servletName = servletName;
            this.roleName = roleName;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Key)) {
                return false;
            }
            Key key = (Key)obj;
            return this.servletName != null && this.servletName.equals(key.servletName) && this.roleName != null && this.roleName.equals(key.roleName);
        }

        public int hashCode() {
            if (this.servletName == null && this.roleName != null) {
                return this.roleName.hashCode();
            }
            if (this.roleName == null && this.servletName != null) {
                return this.servletName.hashCode();
            }
            if (this.servletName == null && this.roleName == null) {
                return 0;
            }
            return this.servletName.hashCode() + this.roleName.hashCode();
        }

        public void reset() {
            this.servletName = null;
            this.roleName = null;
        }
    }
}

