/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.deployer;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;

public class SIPDeployer
implements LifecycleListener {
    private StandardHost host = null;
    protected ArrayList<String> deployed = new ArrayList();

    public SIPDeployer(StandardHost host) {
        this.host = host;
    }

    protected void deployApps() {
        File appBase = null;
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            appBase = file;
        }
        if (!appBase.exists() || !appBase.isDirectory()) {
            return;
        }
        String[] files = appBase.list();
        for (int i = 0; i < files.length; ++i) {
            String deployArchive = files[i];
            if (!deployArchive.endsWith(".war") && !deployArchive.endsWith(".sar")) continue;
            String contextPath = "/" + deployArchive.substring(0, deployArchive.lastIndexOf(46));
            try {
                File archive = new File(appBase, deployArchive);
                URL url = new URL("file", null, archive.getCanonicalPath());
                url = new URL("jar:" + url.toString() + "!/");
                this.deployed.add(deployArchive);
                continue;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.deployDirectories(appBase, files);
    }

    protected void deployDirectories(File appBase, String[] files) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File dir;
            if (files[i].equalsIgnoreCase("META-INF") || files[i].equalsIgnoreCase("WEB-INF") || this.deployed.contains(files[i]) || !(dir = new File(appBase, files[i])).isDirectory()) continue;
            this.deployed.add(files[i]);
            File webInf = new File(dir, "/WEB-INF");
            if (!webInf.exists() || !webInf.isDirectory() || !webInf.canRead()) continue;
            String contextPath = "/" + files[i];
            if (files[i].equals("ROOT")) {
                contextPath = "";
            }
            if (this.host.findChild(contextPath) != null) continue;
            try {
                URL url = new URL("file", null, dir.getCanonicalPath());
                continue;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    public void deployApplication(String applicationName) {
        String strAppBase = System.getProperty("catalina.base") + "\\" + this.host.getAppBase();
        String contextPath = "/" + applicationName.substring(0, applicationName.lastIndexOf(46));
        File dir = null;
        try {
            File appBase = new File(strAppBase);
            dir = new File(appBase, applicationName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            URL url = new URL("file", null, dir.getCanonicalPath());
            url = new URL("jar:" + url.toString() + "!/");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        String eType;
        if (event.getSource() instanceof StandardServer && "before_start".equals(event.getType())) {
            StandardServer server = (StandardServer)event.getSource();
            Service[] service = server.findServices();
            StandardEngine engine = (StandardEngine)service[0].getContainer();
            Container[] container = engine.findChildren();
            this.host = (StandardHost)container[0];
            LifecycleListener[] listener = this.host.findLifecycleListeners();
            for (int i = 0; i < listener.length; ++i) {
                LifecycleListener ll = listener[i];
                if (!"org.apache.catalina.startup.HostConfig".equals(ll.getClass().getName())) continue;
                this.host.removeLifecycleListener(ll);
            }
            this.host.addLifecycleListener((LifecycleListener)this);
            ((StandardServer)event.getSource()).removeLifecycleListener((LifecycleListener)this);
            Container[] children = this.host.findChildren();
            String debug = "";
        } else if (event.getSource() instanceof StandardHost && "start".equals(eType = event.getType())) {
            this.deployApps();
        }
    }
}

