/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.mbeans;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.modelmbean.ModelMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MBeanCollectionProxy
implements InvocationHandler {
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private List<Object> m_MBeanCollection = null;
    private HashMap<String, Attribute> m_Attributes = new HashMap();

    public MBeanCollectionProxy(List<Object> mBeanCollection) {
        for (Object x : mBeanCollection) {
            if (!m_Log.isLoggable(Level.FINE)) continue;
            m_Log.log(Level.FINE, "MBean in collection: " + x.getClass().getName());
        }
        this.m_MBeanCollection = mBeanCollection;
    }

    public static Object createProxy(List<Object> mBeanCollection) {
        Class[] newInterfaces = new Class[]{ModelMBean.class};
        return Proxy.newProxyInstance(MBeanCollectionProxy.class.getClassLoader(), newInterfaces, (InvocationHandler)new MBeanCollectionProxy(mBeanCollection));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            String met = method.getName();
            if ("setAttribute".equals(method.getName())) {
                Attribute attribute = (Attribute)args[0];
                String paramName = attribute.getName();
                Object paramValue = attribute.getValue();
                Method mToCall = null;
                this.m_Attributes.put(paramName, new Attribute(paramName, paramValue));
                for (Object element : this.m_MBeanCollection) {
                    String className = element.getClass().getName();
                    try {
                        String setterName = "set" + paramName;
                        mToCall = element.getClass().getMethod(setterName, paramValue.getClass());
                        mToCall.invoke(element, paramValue);
                        if (!m_Log.isLoggable(Level.FINE)) continue;
                        m_Log.log(Level.FINE, paramName + " = '" + paramValue + "' was set in " + className + " instance");
                    }
                    catch (Exception ignore) {
                        try {
                            String setterName = "set" + paramName.substring(0, 1).toUpperCase() + paramName.substring(1);
                            mToCall = element.getClass().getMethod(setterName, paramValue.getClass());
                            mToCall.invoke(element, paramValue);
                            if (!m_Log.isLoggable(Level.FINE)) continue;
                            m_Log.log(Level.FINE, paramName + " = '" + paramValue + "' was set in " + className + " instance");
                        }
                        catch (Exception innerIgnore) {}
                    }
                }
                return new String("setAttribute Performed");
            }
            if ("getAttribute".equals(method.getName())) {
                String attribName = (String)args[0];
                Attribute attribValue = this.m_Attributes.get(attribName);
                return attribValue.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String("Test");
    }
}

