/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.processor;

import com.ericsson.ssa.container.SipContainerThreadPool;
import com.ericsson.ssa.container.processor.QueuedTask;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueuedProcessor
implements Runnable {
    public static final String SHUTDOWN_OF_PROCESSOR = "Shutdown of processor";
    public static final String QUEUE_LENGTH_EXCEEDED = "Queue length exceeded";
    private Logger log = Logger.getLogger("SipContainer");
    private Object mutex = new Object();
    private List<QueuedTask> inputQueue = new LinkedList<QueuedTask>();
    private int maxQueueLength;
    private long inactiveWorkerTimeout;
    private State state = State.IDLE;
    private boolean doStop;

    public QueuedProcessor(int maxQueueLength, long inactiveWorkerTimeout) {
        this.maxQueueLength = maxQueueLength;
        this.inactiveWorkerTimeout = inactiveWorkerTimeout;
    }

    public boolean isActive() {
        return this.state == State.ACTIVE;
    }

    public boolean hasShutdown() {
        return this.state == State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(QueuedTask task) throws ProcessorException {
        Object object = this.mutex;
        synchronized (object) {
            if (this.hasShutdown() || this.inputQueue.size() >= this.maxQueueLength) {
                throw new ProcessorException(this.doStop ? SHUTDOWN_OF_PROCESSOR : QUEUE_LENGTH_EXCEEDED, null);
            }
            this.inputQueue.add(task);
            this.activateProcessor();
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mutex;
        synchronized (object) {
            this.doStop = true;
            this.state = State.TERMINATED;
            Iterator<QueuedTask> iter = this.inputQueue.iterator();
            while (iter.hasNext()) {
                QueuedTask task = iter.next();
                iter.remove();
                task.doErrorAction(SHUTDOWN_OF_PROCESSOR);
            }
            this.mutex.notifyAll();
        }
    }

    private void activateProcessor() {
        if (this.state == State.IDLE) {
            this.state = State.ACTIVE;
            SipContainerThreadPool.getInstance().execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.mutex;
        synchronized (object) {
            return "[current queue length = " + this.inputQueue.size() + "; max queue length = " + this.maxQueueLength + "; active = " + this.isActive() + "; hasShutdown = " + this.hasShutdown() + "]";
        }
    }

    private void removeOldestErrorTasks() {
        int i = 0;
        Iterator<QueuedTask> iter = this.inputQueue.iterator();
        while (iter.hasNext()) {
            QueuedTask task = iter.next();
            String errorDescription = task.getError();
            if (errorDescription != null) {
                iter.remove();
                task.doErrorAction(errorDescription);
            }
            if (++i <= 10) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            QueuedTask task = null;
            Object object = this.mutex;
            synchronized (object) {
                if (this.doStop) {
                    this.doStop = false;
                    if (this.state == State.ACTIVE) {
                        this.state = State.IDLE;
                    }
                    return;
                }
                if ((task = this.getTaskFromQueue(task)) == null) {
                    if (this.inactiveWorkerTimeout > 0L) {
                        try {
                            this.mutex.wait(this.inactiveWorkerTimeout);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.inputQueue.size() == 0) {
                            this.doStop = true;
                        }
                    } else {
                        this.doStop = true;
                    }
                }
            }
            if (task == null) continue;
            this.process(task);
        }
    }

    private QueuedTask getTaskFromQueue(QueuedTask task) {
        this.removeOldestErrorTasks();
        if (this.inputQueue.size() > 0) {
            return this.inputQueue.remove(0);
        }
        return null;
    }

    protected void process(QueuedTask task) {
        try {
            task.run();
        }
        catch (Throwable e) {
            this.log.log(Level.WARNING, "Unexpected exception when executing task", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        IDLE,
        ACTIVE,
        TERMINATED;

    }

    public class ProcessorException
    extends Exception {
        public ProcessorException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

