/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.startup;

import com.ericsson.ssa.container.NetworkManager;
import com.ericsson.ssa.container.OverloadManager;
import com.ericsson.ssa.container.mbeans.MBeanUtil;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.transaction.TransactionManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardService;

public class PerformanceMBeanListener
implements LifecycleListener {
    private static boolean _isEnabled = false;
    Logger logger = Logger.getLogger("SipContainer");
    String sessionMBean = "EAS:type=PerformanceManagement,name=SessionManager";
    String transactionMBean = "EAS:type=PerformanceManagement,name=TransactionManager";
    String networkMBean = "EAS:type=PerformanceManagement,name=NetworkManager";
    String overloadMBean = "EAS:type=PerformanceManagement,name=OverloadManager";

    public static boolean isEnabled() {
        return _isEnabled;
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Got event: " + event.getType());
        }
        if (event.getSource() instanceof StandardService && "start".equals(event.getType())) {
            MBeanUtil mbeanUtil = MBeanUtil.getInstance();
            String JmxDescriptorFile = "/com/ericsson/ssa/container/mbeans/descriptors/performance-mbeans-descriptors.xml";
            try {
                String a = "";
                mbeanUtil.loadDescriptors(this.getClass(), JmxDescriptorFile);
                mbeanUtil.registerMBean(SessionManager.getInstance(), this.sessionMBean);
                mbeanUtil.registerMBean(TransactionManager.getInstance(), this.transactionMBean);
                mbeanUtil.registerMBean(NetworkManager.getInstance(), this.networkMBean);
                mbeanUtil.registerMBean(OverloadManager.getInstance(), this.overloadMBean);
                _isEnabled = true;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.log(Level.FINE, "PerformanceMBean registered succesfully");
                }
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Cannot load MBean Descriptor File", e);
            }
        }
    }

    public static void setEnabled(boolean u) {
        _isEnabled = u;
    }
}

