/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.container.startup;

import com.ericsson.ssa.container.startup.TmSpaConfig;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;
import javax.management.openmbean.OpenMBeanInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.SimpleType;

public class TmSpaMBean
implements DynamicMBean {
    private Logger logger = Logger.getLogger("SipContainer");
    private String className = this.getClass().getName();
    private String description = "Traffic Management";
    private OpenMBeanInfoSupport mbeanInfo;
    private Preferences tmPrefNode = null;
    private Preferences dnsPrefNode = null;
    private Preferences tmTimerPrefNode = null;

    public TmSpaMBean() {
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Creation of the " + this.description + " has started");
        }
        try {
            this.setMBeanInfo(this.className, this.description);
            this.tmPrefNode = Preferences.userRoot().node("/com/ericsson/eas/tm");
            this.dnsPrefNode = Preferences.userRoot().node("/com/ericsson/eas/oam/dnsmanagement");
            this.tmTimerPrefNode = Preferences.userRoot().node("/com/ericsson/eas/tm/timer");
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Failed to create the " + this.description + " due to: " + e.getCause() + ".");
            }
            throw new RuntimeMBeanException(new RuntimeException(e), "Failed to create the " + this.getClass().getName() + " MBean");
        }
    }

    private void setMBeanInfo(String className, String description) throws OpenDataException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method setMBeanInfo has been called");
        }
        ArrayList<OpenMBeanAttributeInfoSupport> arrayList = new ArrayList<OpenMBeanAttributeInfoSupport>();
        arrayList.add(new OpenMBeanAttributeInfoSupport("defaultTCPTransport", "Determines whether or not the transport parameter will be inserted into the Uniform Resource Identifiers (URIs) of Contact and Record-Route headers, that EAS inserts into messages.", SimpleType.BOOLEAN, true, false, false, TmSpaConfig.DEFAULT_TCP_TRANSPORT_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("JmxDefaultPort", "Defines the port on which the RMI registry will run.", SimpleType.INTEGER, true, false, false, TmSpaConfig.JMX_DEFAULT_PORT_DEF, TmSpaConfig.JMX_DEFAULT_PORT_MIN, TmSpaConfig.JMX_DEFAULT_PORT_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ThreadPoolSize", "Defines the initial number of worker threads.", SimpleType.INTEGER, true, false, false, TmSpaConfig.THREAD_POOL_SIZE_DEF, TmSpaConfig.THREAD_POOL_SIZE_MIN, TmSpaConfig.THREAD_POOL_SIZE_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ErrorResponseEnabled", "Determines whether or not a bad request should result in error response 400 Bad Request. If not, the SIP stack just drops the request, that is, the client does not get a SIP response.", SimpleType.BOOLEAN, true, false, false, TmSpaConfig.ERROR_RESPONSE_ENABLED_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ApplicationDispatcherLoopInternal", "Determines if the request will be handled internally by the container or sent out to the network.", SimpleType.BOOLEAN, true, false, false, TmSpaConfig.APPLICATION_DISPATCHER_LOOP_INTERNAL_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("EnumTopDomain", "Defines the topdomain to be used when translating a global telephone number to a ENUM domain name.", SimpleType.STRING, true, false, false, "e164.arpa"));
        arrayList.add(new OpenMBeanAttributeInfoSupport("DnsCacheSize", "Defines the dns cache size.", SimpleType.INTEGER, true, false, false, TmSpaConfig.DNS_CACHE_SIZE_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("DnsServerList", "Defines a comma separated list of DNS servers that is used when querying external domains.", SimpleType.STRING, true, false, false, ""));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ProxyPoolSize", "Defines the HTTP proxy connection pool size.", SimpleType.INTEGER, true, false, false, TmSpaConfig.PROXY_POOL_SIZE_DEF, TmSpaConfig.PROXY_POOL_SIZE_MIN, null));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ProxyRetries", "Defines the number of retries the HTTP proxy performs before considering the proxy attempt to have failed.", SimpleType.INTEGER, true, false, false, TmSpaConfig.PROXY_RETRIES_DEF, TmSpaConfig.PROXY_RETRIES_MIN, null));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ProxySocketTimeout", "Defines the maximum time, in milliseconds, the HTTP proxy waits for a response before considering the proxy attempt to have failed.", SimpleType.INTEGER, true, false, false, TmSpaConfig.PROXY_SOCKET_TIMEOUT_DEF, TmSpaConfig.PROXY_SOCKET_TIMEOUT_MIN, null));
        arrayList.add(new OpenMBeanAttributeInfoSupport("ProxyConnectionTimeout", "Defines the maximum time, in milliseconds, the HTTP proxy tries to obtain a connection from a connection pool.", SimpleType.INTEGER, true, false, false, TmSpaConfig.PROXY_CONNECTION_TIMEOUT_DEF, TmSpaConfig.PROXY_CONNECTION_TIMEOUT_MIN, null));
        arrayList.add(new OpenMBeanAttributeInfoSupport("OverloadRegulation", "Determines whether or not overload regulation is enabled.", SimpleType.BOOLEAN, true, true, true, TmSpaConfig.OVERLOAD_REGULATION_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("SampleRate", "Defines the sample rate of updating the threshold levels.", SimpleType.INTEGER, true, true, false, TmSpaConfig.SAMPLE_RATE_DEF, TmSpaConfig.SAMPLE_RATE_MIN, TmSpaConfig.SAMPLE_RATE_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("NumberOfSamples", "Defines the number of consequence samples that is needed before threshold is raised.", SimpleType.INTEGER, true, true, false, TmSpaConfig.NUMBER_OF_SAMPLES_DEF, TmSpaConfig.NUMBER_OF_SAMPLES_MIN, TmSpaConfig.NUMBER_OF_SAMPLES_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("HttpThreshold", "Defines the threshold level of the CPU for HTTP requests.", SimpleType.INTEGER, true, true, false, TmSpaConfig.HTTP_THRESHOLD_DEF, TmSpaConfig.HTTP_THRESHOLD_MIN, TmSpaConfig.HTTP_THRESHOLD_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("IrThreshold", "Defines the threshold level of the CPU for SIP initial requests.", SimpleType.INTEGER, true, true, false, TmSpaConfig.IR_THRESHOLD_DEF, TmSpaConfig.IR_THRESHOLD_MIN, TmSpaConfig.IR_THRESHOLD_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("SrThreshold", "Defines the threshold level of the CPU for SIP subsequent requests.", SimpleType.INTEGER, true, true, false, TmSpaConfig.SR_THRESHOLD_DEF, TmSpaConfig.SR_THRESHOLD_MIN, TmSpaConfig.SR_THRESHOLD_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("MmThreshold", "Defines the threshold level of the CPU when all messages are dropped.", SimpleType.INTEGER, true, true, false, TmSpaConfig.MM_THRESHOLD_DEF, TmSpaConfig.MM_THRESHOLD_MIN, TmSpaConfig.MM_THRESHOLD_MAX));
        arrayList.add(new OpenMBeanAttributeInfoSupport("timerT1", "Defines the SIP Timer T1 in milliseconds.", SimpleType.INTEGER, true, false, false, TmSpaConfig.TIMER_T1_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("timerT2", "Defines the SIP Timer T2 in milliseconds.", SimpleType.INTEGER, true, false, false, TmSpaConfig.TIMER_T2_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("timerT4", "Defines the SIP Timer T4 in milliseconds.", SimpleType.INTEGER, true, false, false, TmSpaConfig.TIMER_T4_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("SipLinkTimeout", "Defines timeout value in milliseconds for a single write operation of a sip link.", SimpleType.INTEGER, true, false, false, TmSpaConfig.SIP_LINK_TIMEOUT_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("SipLinkTimeoutRetries", "Defines the number of retries to perform of a single write operation of a sip link.", SimpleType.INTEGER, true, false, false, TmSpaConfig.SIP_LINK_TIMEOUT_RETRIES_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("SipLinkMaxThreadQueueLength", "Defines the maximum number simultaneous write/connect requests that can be waiting to write on a link.", SimpleType.INTEGER, true, false, false, TmSpaConfig.SIP_LINK_MAX_QUEUE_LENGTH_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("SipLinkAliveTimeout", "Defines the duration (in seconds) an inactive SIP link is kept alive before the connection is torn down.", SimpleType.INTEGER, true, false, false, TmSpaConfig.SIP_LINK_ALIVE_TIMEOUT_DEF));
        arrayList.add(new OpenMBeanAttributeInfoSupport("Eas503Disabled", "Determines if the functionality described in RFC3263 4.3 Details of RFC 2782 Process is disabled.", SimpleType.BOOLEAN, true, false, true, TmSpaConfig.EAS_503_DISABLED_DEF));
        OpenMBeanAttributeInfo[] attributes = new OpenMBeanAttributeInfoSupport[arrayList.size()];
        arrayList.toArray(attributes);
        this.mbeanInfo = new OpenMBeanInfoSupport(className, description, attributes, new OpenMBeanConstructorInfoSupport[0], new OpenMBeanOperationInfoSupport[0], new MBeanNotificationInfo[0]);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "MBeanInfo constructed for the " + this.mbeanInfo.getDescription() + " MBean");
        }
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Reading started for attribute " + attributeName);
        }
        if (attributeName.equals("ApplicationDispatcherLoopInternal")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getApplicationDispatcherLoopInternal();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("DnsCacheSize")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getDnsCacheSize();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("DnsServerList")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getDnsServerList();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("Eas503Disabled")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getEas503Disabled();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("EnumTopDomain")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getEnumTopDomain();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("HttpThreshold")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getHttpThreshold();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("IrThreshold")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getIrThreshold();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("JmxDefaultPort")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getJmxDefaultPort();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("MmThreshold")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getMmThreshold();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("NumberOfSamples")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getNumberOfSamples();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("OverloadRegulation")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getOverloadRegulation();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("ProxyConnectionTimeout")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getProxyConnectionTimeout();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("ProxyPoolSize")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getProxyPoolSize();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("ProxyRetries")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getProxyRetries();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("ProxySocketTimeout")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getProxySocketTimeout();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("SampleRate")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getSampleRate();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("SipLinkMaxThreadQueueLength")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getSipLinkMaxQueueLenght();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("SipLinkTimeout")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getSipLinkTimeout();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("SipLinkAliveTimeout")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getSipLinkAliveTimeout();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("SipLinkTimeoutRetries")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getSipLinkTimeoutRetries();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("SrThreshold")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getSrThreshold();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("defaultTCPTransport")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getDefaultTCPTransport();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("ThreadPoolSize")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getThreadPoolSize();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("ErrorResponseEnabled")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getErrorResponseEnabled();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("timerT1")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getTimerT1();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("timerT2")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getTimerT2();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (attributeName.equals("timerT4")) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Calling the getter for attribute " + attributeName);
            }
            try {
                return this.getTimerT4();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to read the value of the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        this.logger.log(Level.SEVERE, "Cannot find the " + attributeName + " attribute in the " + this.description + " MBean");
        throw new AttributeNotFoundException("Cannot find the " + attributeName + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
    }

    public AttributeList getAttributes(String[] attributeNames) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Reading started for this of attribute list");
        }
        AttributeList attributeList = new AttributeList();
        if (attributeNames == null) {
            this.logger.log(Level.SEVERE, "Cannot read an attribute list set to null");
            return attributeList;
        }
        if (attributeNames.length == 0) {
            this.logger.log(Level.SEVERE, "Cannot read an empty attribute list");
            return attributeList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                attributeList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Reading ended for this of attribute list");
        }
        return attributeList;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "MBeanInfo read for the " + this.mbeanInfo.getDescription() + " MBean");
        }
        return this.mbeanInfo;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method invoke has been called.");
        }
        this.logger.log(Level.SEVERE, "Unknown operation for this MBean");
        throw new MBeanException(new NoSuchMethodException(actionName), "Unknown operation for this MBean");
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block11: {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "Writing started for attribute " + attribute.getName());
            }
            try {
                if (attribute.getName().equals("HttpThreshold")) {
                    this.setHttpThreshold(attribute.getValue());
                    break block11;
                }
                if (attribute.getName().equals("IrThreshold")) {
                    this.setIrThreshold(attribute.getValue());
                    break block11;
                }
                if (attribute.getName().equals("MmThreshold")) {
                    this.setMmThreshold(attribute.getValue());
                    break block11;
                }
                if (attribute.getName().equals("NumberOfSamples")) {
                    this.setNumberOfSamples(attribute.getValue());
                    break block11;
                }
                if (attribute.getName().equals("SampleRate")) {
                    this.setSampleRate(attribute.getValue());
                    break block11;
                }
                if (attribute.getName().equals("SrThreshold")) {
                    this.setSrThreshold(attribute.getValue());
                    break block11;
                }
                if (attribute.getName().equals("OverloadRegulation")) {
                    this.setOverloadRegulation(attribute.getValue());
                    break block11;
                }
                this.logger.log(Level.SEVERE, "Cannot find the " + attribute + " attribute in the " + this.mbeanInfo.getDescription() + " Mbean");
                throw new AttributeNotFoundException("Cannot find the " + attribute + " attribute in the " + this.mbeanInfo.getDescription() + " Mbean");
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to write the value of the " + attribute.getName() + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new MBeanException(e, "Failed to write the value of the " + attribute.getName() + " attribute in the " + this.mbeanInfo.getDescription() + " MBean");
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Writing ended for the " + attribute.getName() + " attribute. Value set to: " + (String)attribute.getValue());
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Writing started for the attribute list");
        }
        AttributeList resultList = new AttributeList();
        if (attributeList == null) {
            this.logger.log(Level.SEVERE, "Cannot write an attribute list set to null");
            throw new RuntimeException("Cannot write an attribute list set to null");
        }
        if (attributeList.isEmpty()) {
            this.logger.log(Level.SEVERE, "Cannot write an empty attribute list");
            return resultList;
        }
        for (Attribute attribute : attributeList) {
            try {
                this.setAttribute(attribute);
                String name = attribute.getName();
                Object value = attribute.getValue();
                resultList.add(new Attribute(name, value));
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Failed to write attribute list in the " + this.mbeanInfo.getDescription() + " MBean");
                throw new RuntimeException(e.getCause().getMessage());
            }
        }
        return resultList;
    }

    private Boolean getApplicationDispatcherLoopInternal() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getApplicationDispatcherLoopInternal called");
        }
        if ((value = this.tmPrefNode.get("ApplicationDispatcherLoopInternal", null)) == null) {
            return null;
        }
        return new Boolean(value);
    }

    private Integer getDnsCacheSize() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getDnsCacheSize() called");
        }
        if ((value = this.dnsPrefNode.get("DnsCacheSize", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private String getDnsServerList() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getDnsServerList() called");
        }
        if ((value = this.dnsPrefNode.get("DnsServerList", null)) == null) {
            return null;
        }
        return value;
    }

    private Boolean getEas503Disabled() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getEas503Disabled called");
        }
        if ((value = this.tmPrefNode.get("Eas503Disabled", null)) == null) {
            return null;
        }
        return new Boolean(value);
    }

    private String getEnumTopDomain() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getEnumTopDomain() called");
        }
        if ((value = this.tmPrefNode.get("EnumTopDomain", null)) == null) {
            return null;
        }
        return value;
    }

    private Integer getHttpThreshold() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getHttpThreshold() called");
        }
        if ((value = this.tmPrefNode.get("HttpThreshold", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getIrThreshold() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getIrThreshold() called");
        }
        if ((value = this.tmPrefNode.get("IrThreshold", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getJmxDefaultPort() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getJmxDefaultPort() called");
        }
        if ((value = this.tmPrefNode.get("JmxDefaultPort", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getMmThreshold() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getMmThreshold() called");
        }
        if ((value = this.tmPrefNode.get("MmThreshold", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getNumberOfSamples() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getNumberOfSamples() called");
        }
        if ((value = this.tmPrefNode.get("NumberOfSamples", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Boolean getOverloadRegulation() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getOverloadRegulation called");
        }
        if ((value = this.tmPrefNode.get("OverloadRegulation", null)) == null) {
            return null;
        }
        return new Boolean(value);
    }

    private Integer getProxyConnectionTimeout() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getProxyConnectionTimeout() called");
        }
        if ((value = this.tmPrefNode.get("ProxyConnectionTimeout", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getProxyPoolSize() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getProxyPoolSize() called");
        }
        if ((value = this.tmPrefNode.get("ProxyPoolSize", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getProxyRetries() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getProxyRetries() called");
        }
        if ((value = this.tmPrefNode.get("ProxyRetries", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getProxySocketTimeout() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getProxySocketTimeout() called");
        }
        if ((value = this.tmPrefNode.get("ProxySocketTimeout", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getSampleRate() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getSampleRate() called");
        }
        if ((value = this.tmPrefNode.get("SampleRate", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getSipLinkMaxQueueLenght() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getSipLinkMaxQueueLenght() called");
        }
        if ((value = this.tmPrefNode.get("SipLinkMaxThreadQueueLength", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getSipLinkTimeout() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getSipLinkTimeout() called");
        }
        if ((value = this.tmPrefNode.get("SipLinkTimeout", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getSipLinkTimeoutRetries() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getSipLinkTimeoutRetries() called");
        }
        if ((value = this.tmPrefNode.get("SipLinkTimeoutRetries", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getSipLinkAliveTimeout() throws IllegalStateException, NullPointerException {
        String value = this.tmPrefNode.get("SipLinkAliveTimeout", null);
        if (value == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getSrThreshold() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getSrThreshold() called");
        }
        if ((value = this.tmPrefNode.get("SrThreshold", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Object getDefaultTCPTransport() {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getDefaultTCPTransport called");
        }
        if ((value = this.tmPrefNode.get("defaultTCPTransport", null)) == null) {
            return null;
        }
        return new Boolean(value);
    }

    private Integer getThreadPoolSize() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getThreadPoolSize() called");
        }
        if ((value = this.tmPrefNode.get("ThreadPoolSize", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Boolean getErrorResponseEnabled() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getErrorResponseEnabled() called");
        }
        if ((value = this.tmPrefNode.get("ErrorResponseEnabled", null)) == null) {
            return null;
        }
        return new Boolean(value);
    }

    private Integer getTimerT1() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getTimerT1() called");
        }
        if ((value = this.tmTimerPrefNode.get("timerT1", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getTimerT2() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getTimerT2() called");
        }
        if ((value = this.tmTimerPrefNode.get("timerT2", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private Integer getTimerT4() throws IllegalStateException, NullPointerException {
        String value;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method getTimerT4() called");
        }
        if ((value = this.tmTimerPrefNode.get("timerT4", null)) == null) {
            return null;
        }
        return new Integer(value);
    }

    private void setHttpThreshold(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.tmPrefNode.put("HttpThreshold", (String)attributeValue);
    }

    private void setIrThreshold(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.tmPrefNode.put("IrThreshold", (String)attributeValue);
    }

    private void setMmThreshold(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.tmPrefNode.put("MmThreshold", (String)attributeValue);
    }

    private void setNumberOfSamples(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "Method setNumberOfSamples() called");
            this.logger.log(Level.FINE, "attributeValue=" + attributeValue);
        }
        this.tmPrefNode.put("NumberOfSamples", (String)attributeValue);
    }

    private void setOverloadRegulation(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.tmPrefNode.put("OverloadRegulation", (String)attributeValue);
    }

    private void setSampleRate(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.tmPrefNode.put("SampleRate", (String)attributeValue);
    }

    private void setSrThreshold(Object attributeValue) throws IllegalArgumentException, IllegalStateException, NullPointerException {
        this.tmPrefNode.put("SrThreshold", (String)attributeValue);
    }
}

