/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import java.util.Collection;
import java.util.HashMap;

public abstract class Enum {
    private static HashMap enumClasses = new HashMap(10);
    private String name;

    protected Enum(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid enum name: " + name);
        }
        Entry entry = Enum.getEntry(this.getClass());
        if (entry == null) {
            entry = new Entry();
            enumClasses.put(this.getClass(), entry);
        }
        if (entry.enumValues.containsKey(name)) {
            throw new IllegalArgumentException("Enum already exists for " + this.getClass().getName() + " and name " + name);
        }
        this.name = name;
        entry.enumValues.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    protected static String[] getNames(Class class_) {
        Entry entry = (Entry)enumClasses.get(class_);
        Enum.assertEntryNotNull(entry, class_);
        return entry.enumValues.keySet().toArray(new String[entry.enumValues.size()]);
    }

    protected static boolean contains(Class class_, String name) {
        Entry entry = Enum.getEntry(class_);
        Enum.assertEntryNotNull(entry, class_);
        return entry.enumValues.containsKey(name);
    }

    protected static Entry getEntry(Class class_) {
        return (Entry)enumClasses.get(class_);
    }

    protected static String toString(Class class_) {
        String[] names = Enum.getNames(class_);
        StringBuffer buffer = new StringBuffer("[");
        for (int i = 0; i != names.length; ++i) {
            buffer.append(names[i]);
            if (i == names.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    protected static Collection getEnumList(Class class_) {
        Entry entry = Enum.getEntry(class_);
        Enum.assertEntryNotNull(entry, class_);
        return entry.enumValues.values();
    }

    protected static Collection getEnumNameList(Class class_) {
        Entry entry = Enum.getEntry(class_);
        Enum.assertEntryNotNull(entry, class_);
        return entry.enumValues.keySet();
    }

    private static void assertEntryNotNull(Entry entry, Class class_) {
        if (entry == null) {
            throw new IllegalArgumentException("No Enum exists for type " + class_.getName());
        }
    }

    private static class Entry {
        HashMap enumValues = new HashMap(10);

        private Entry() {
        }
    }
}

