/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.Condition;
import com.ericsson.ssa.dd.SessionCase;
import com.ericsson.ssa.dd.SupportedMethod;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.UriWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.TelURL;

public abstract class Operand
implements Condition {
    private Collection methodValuesList = SupportedMethod.getEnumNameList();
    private Collection<SessionCase> sessionCaseValueList = new ArrayList<SessionCase>();

    public Operand() {
        this.sessionCaseValueList.add(SessionCase.ORIGINATING);
        this.sessionCaseValueList.add(SessionCase.TERMINATING);
        this.sessionCaseValueList.add(SessionCase.TERMINATING_UNREGISTERED);
    }

    protected String getAttributeValue(String name, SipServletRequest req) {
        block27: {
            String descriptorRole;
            if (name.equals("request.session-case")) {
                try {
                    SessionCase sessionCase = ((SipServletRequestImpl)req).getSessionCase();
                    return sessionCase.toString();
                }
                catch (Exception ex) {
                    return SessionCase.EXTERNAL.toString();
                }
            }
            if (name.equals("request.user.role") && req.isUserInRole(descriptorRole = this.getValue())) {
                return descriptorRole;
            }
            if (name.equals("request.method")) {
                return req.getMethod();
            }
            if (name.equals("request.uri")) {
                return req.getRequestURI().toString();
            }
            if (name.equals("request.uri.scheme")) {
                return req.getRequestURI().getScheme();
            }
            if (req.getRequestURI().isSipURI()) {
                SipURI uri = (SipURI)req.getRequestURI();
                if (name.equals("request.uri.user")) {
                    return uri.getUser();
                }
                if (name.equals("request.uri.host")) {
                    return uri.getHost();
                }
                if (name.equals("request.uri.port")) {
                    return this.getUriPort(uri);
                }
                if (name.equals("request.uri.tel") && "phone".equals(uri.getParameter("user"))) {
                    return this.getPhoneNumber(uri.getUser());
                }
            } else if (req.getRequestURI().getScheme().equalsIgnoreCase("tel") && name.equals("request.uri.tel")) {
                return this.getPhoneNumber(((TelURL)req.getRequestURI()).getPhoneNumber());
            }
            StringTokenizer token = new StringTokenizer(name, ".");
            int ntok = token.countTokens();
            String[] elements = new String[ntok];
            for (int i = 0; i < ntok; ++i) {
                elements[i] = token.nextToken();
            }
            if (name.startsWith("request.uri.param") && elements.length > 3) {
                return new UriWrapper(req).getParameter(elements[3]);
            }
            if (name.startsWith("request.")) {
                if (elements.length > 2 && "uri".equals(elements[2])) {
                    try {
                        if (elements.length < 4) {
                            return req.getHeader(elements[1]);
                        }
                        if ("scheme".equals(elements[3])) {
                            return req.getAddressHeader(elements[1]).getURI().getScheme();
                        }
                        if ("display-name".equals(elements[3])) {
                            return req.getAddressHeader(elements[1]).getDisplayName();
                        }
                        if (!req.getAddressHeader(elements[1]).getURI().isSipURI()) break block27;
                        SipURI headerURI = (SipURI)req.getAddressHeader(elements[1]).getURI();
                        if ("user".equals(elements[3])) {
                            return headerURI.getUser();
                        }
                        if ("host".equals(elements[3])) {
                            return headerURI.getHost();
                        }
                        if ("port".equals(elements[3])) {
                            return this.getUriPort(headerURI);
                        }
                    }
                    catch (ServletParseException e) {}
                } else {
                    return req.getHeader(elements[1]);
                }
            }
        }
        return "";
    }

    private String getPhoneNumber(String user) {
        StringBuffer sb = new StringBuffer();
        if (user != null) {
            char[] chars = user.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (!Character.isDigit(chars[i])) continue;
                sb.append(chars[i]);
            }
            return sb.toString();
        }
        return null;
    }

    private String getUriPort(SipURI uri) {
        if (uri.getPort() > 0) {
            return Integer.toString(uri.getPort());
        }
        String scheme = uri.getScheme();
        if (scheme.equals("sip")) {
            return Integer.toString(5060);
        }
        if (scheme.equals("sips")) {
            return Integer.toString(5061);
        }
        return null;
    }

    private boolean isMethod(String var) {
        return var.equals("request.method");
    }

    private boolean isSessionCase(String var) {
        return var.equals("request.session-case");
    }

    protected boolean isMethodOrSessionCase(String var) {
        return this.isMethod(var) || this.isSessionCase(var);
    }

    protected boolean isVarValueSupported(String var, String value) {
        if (this.isMethod(var)) {
            return this.methodValuesList.contains(value);
        }
        if (this.isSessionCase(var)) {
            return this.sessionCaseValueList.contains(value);
        }
        return true;
    }

    public abstract String getValue();

    public abstract String getVariable();
}

