/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.Condition;
import com.ericsson.ssa.dd.Operator;
import com.ericsson.ssa.dd.SessionCase;
import com.ericsson.ssa.dd.SipParserException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrOperator
extends Operator {
    private static final long serialVersionUID = 3690196533861497137L;

    @Override
    public boolean evaluate(Object object) {
        for (int i = 0; i < this.subConditions.size(); ++i) {
            if (!((Condition)this.subConditions.get(i)).evaluate(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Hashtable<String, ArrayList<String>> getMethodSessionCaseList() throws SipParserException {
        Hashtable<String, ArrayList<String>> methodSessioncaseTableResult = new Hashtable<String, ArrayList<String>>();
        for (int i = 0; i < this.subConditions.size(); ++i) {
            Hashtable<String, ArrayList<String>> curMethSessionTable = ((Condition)this.subConditions.get(i)).getMethodSessionCaseList();
            Enumeration<String> keysList = curMethSessionTable.keys();
            while (keysList.hasMoreElements()) {
                String curKey = keysList.nextElement();
                if (curKey.equals("request.method")) {
                    ArrayList<String> methodNameList = curMethSessionTable.get(curKey);
                    for (String curMethodName : methodNameList) {
                        if (methodSessioncaseTableResult.contains(curMethodName)) {
                            ArrayList<String> curSessionCaseList = methodSessioncaseTableResult.get(curMethodName);
                            curSessionCaseList.clear();
                            curSessionCaseList.add(SessionCase.EXTERNAL.toString());
                            continue;
                        }
                        ArrayList<String> newNotSpecifySessionCaseList = new ArrayList<String>();
                        newNotSpecifySessionCaseList.add(SessionCase.EXTERNAL.toString());
                        methodSessioncaseTableResult.put(curMethodName, newNotSpecifySessionCaseList);
                    }
                    continue;
                }
                if (curKey.equals("request.session-case")) {
                    throw new SipParserException("OR: Wrong Condition: one session-case must be under a AND condition and associated to a method");
                }
                if (methodSessioncaseTableResult.containsKey(curKey)) {
                    this.addOnlyNewElementToTheList(curMethSessionTable.get(curKey), methodSessioncaseTableResult.get(curKey));
                    continue;
                }
                methodSessioncaseTableResult.put(curKey, curMethSessionTable.get(curKey));
            }
        }
        return methodSessioncaseTableResult;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.subConditions.size(); ++i) {
            if (i > 0) {
                sb.append(" || ");
            }
            sb.append("(" + this.subConditions.get(i) + ")");
        }
        return sb.toString();
    }
}

