/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.ResourceCollection;
import com.ericsson.ssa.dd.TransportGuarantee;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityConstraint
implements Serializable {
    private static final long serialVersionUID = 3689355416056115506L;
    private String displayName;
    private Collection<ResourceCollection> resourceCollections = new ArrayList<ResourceCollection>();
    private boolean proxyAuthenticated;
    private String authorizationConstraintDescription;
    private Collection<String> authorizationConstraintRoleNames;
    private String userDataConstraintDescription;
    private String userDataTransportGuarantee;

    public void addResourceCollection(ResourceCollection resourceCollection) {
        this.resourceCollections.add(resourceCollection);
    }

    public void addAuthorizationConstraintRoleNames(String roleName) {
        if (this.authorizationConstraintRoleNames == null) {
            this.authorizationConstraintRoleNames = new ArrayList<String>();
        }
        this.authorizationConstraintRoleNames.add(roleName);
    }

    public Collection getResourceCollections() {
        return this.resourceCollections;
    }

    public Collection<String> getAuthorizationConstraintRoleNames() {
        return this.authorizationConstraintRoleNames;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean isProxyAuthenticated() {
        return this.proxyAuthenticated;
    }

    public void setProxyAuthenticated(String ignore) {
        this.proxyAuthenticated = true;
    }

    public String getUserDataConstraintDescription() {
        return this.userDataConstraintDescription;
    }

    public void setUserDataConstraintDescription(String userDataConstraintDescription) {
        this.userDataConstraintDescription = userDataConstraintDescription;
    }

    public String getUserDataTransportGuarantee() {
        return this.userDataTransportGuarantee;
    }

    public void setUserDataTransportGuarantee(String userDataTransportGuarantee) {
        if (!TransportGuarantee.contains(userDataTransportGuarantee)) {
            throw new RuntimeException("Values for transport guarantee must be of " + TransportGuarantee.printNames());
        }
        this.userDataTransportGuarantee = userDataTransportGuarantee;
    }

    public String getAuthorizationConstraintDescription() {
        return this.authorizationConstraintDescription;
    }

    public void setAuthorizationConstraintDescription(String authorizationConstraintDescription) {
        this.authorizationConstraintDescription = authorizationConstraintDescription;
    }
}

