/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContextListener;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipSessionAttributeListener;
import javax.servlet.sip.SipSessionListener;
import javax.servlet.sip.TimerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipApplicationListeners {
    private static final Logger logger = Logger.getLogger("SipContainer");
    private ArrayList<SipApplicationSessionListener> sipApplicationSessionListeners = new ArrayList();
    private ArrayList<SipSessionListener> sipSessionListeners = new ArrayList();
    private ArrayList<SipSessionAttributeListener> sipSessionAttributeListeners = new ArrayList();
    private ArrayList<SipErrorListener> sipErrorListeners = new ArrayList();
    private TimerListener timerListener = null;
    private ArrayList<ServletContextListener> servletContextListener = new ArrayList();
    private ArrayList<String> sipServletsWithListeners = new ArrayList();

    public SipApplicationListeners(Collection<String> listenerList, ClassLoader classLoader) {
        for (String className : listenerList) {
            try {
                EventListener listener = (EventListener)classLoader.loadClass(className).newInstance();
                if (listener instanceof SipServlet) {
                    this.sipServletsWithListeners.add(className);
                    continue;
                }
                if (listener instanceof SipApplicationSessionListener) {
                    this.addSipApplicationSessionListener((SipApplicationSessionListener)listener);
                }
                if (listener instanceof SipSessionListener) {
                    this.addSipSessionListener((SipSessionListener)listener);
                }
                if (listener instanceof SipSessionAttributeListener) {
                    this.addSipSessionAttributeListener((SipSessionAttributeListener)listener);
                }
                if (listener instanceof TimerListener) {
                    this.setTimerListener((TimerListener)listener);
                }
                if (listener instanceof SipErrorListener) {
                    this.addSipErrorListener((SipErrorListener)listener);
                }
                if (!(listener instanceof ServletContextListener)) continue;
                this.addServletContextListener((ServletContextListener)listener);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Cannot instantiate listener class " + className, e);
            }
        }
    }

    public ArrayList<String> getSipServletsWithListeners() {
        return this.sipServletsWithListeners;
    }

    public ArrayList<SipApplicationSessionListener> getSipApplicationSessionListeners() {
        return this.sipApplicationSessionListeners;
    }

    public void addSipApplicationSessionListener(SipApplicationSessionListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registering SipApplicationSessionListener: " + listener.getClass().getName());
        }
        this.sipApplicationSessionListeners.add(listener);
    }

    public ArrayList<SipSessionAttributeListener> getSipSessionAttributeListeners() {
        return this.sipSessionAttributeListeners;
    }

    public void addSipSessionAttributeListener(SipSessionAttributeListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registering SipSessionAttributeListener: " + listener.getClass().getName());
        }
        this.sipSessionAttributeListeners.add(listener);
    }

    public ArrayList<SipSessionListener> getSipSessionListeners() {
        return this.sipSessionListeners;
    }

    public void addSipSessionListener(SipSessionListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registering SipSessionListener: " + listener.getClass().getName());
        }
        this.sipSessionListeners.add(listener);
    }

    public TimerListener getTimerListener() {
        return this.timerListener;
    }

    public void setTimerListener(TimerListener listener) {
        if (this.timerListener != null) {
            logger.log(Level.WARNING, "ignoring TimerListener: " + listener.getClass().getName());
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registering TimerListener: " + listener.getClass().getName());
        }
        this.timerListener = listener;
    }

    public ArrayList<SipErrorListener> getSipErrorListeners() {
        return this.sipErrorListeners;
    }

    public void addSipErrorListener(SipErrorListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registering SipErrorListener: " + listener.getClass().getName());
        }
        this.sipErrorListeners.add(listener);
    }

    public void addServletContextListener(ServletContextListener listener) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "registering ServletContextListener: " + listener.getClass().getName());
        }
        this.servletContextListener.add(listener);
    }

    public ArrayList<ServletContextListener> getServletContextListener() {
        return this.servletContextListener;
    }

    public void clean() {
        this.sipApplicationSessionListeners.clear();
        this.sipSessionListeners.clear();
        this.sipSessionAttributeListeners.clear();
        this.sipErrorListeners.clear();
        this.servletContextListener.clear();
        this.timerListener = null;
    }
}

