/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.dd;

import com.ericsson.ssa.dd.ModuleDeployException;
import com.ericsson.ssa.dd.SipApplication;
import com.ericsson.ssa.dd.SipDeploymentDescriptorRuleSet;
import com.ericsson.ssa.dd.SipEntityResolver;
import com.sun.org.apache.commons.digester.Digester;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class SipParser {
    private static final String SIP_XML_RULES_FILE = "com/ericsson/ssa/dd/sip-digester-rules.xml";
    private static final String SIP_EAS_XML_RULES_FILE = "com/ericsson/ssa/dd/sip-eas-digester-rules.xml";

    private SipParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SipApplication parse(JarFile archive) throws IOException, ModuleDeployException, SAXException {
        InputStream sipXml = null;
        try {
            JarEntry sipXmlJarEntry = archive.getJarEntry("WEB-INF/sip.xml");
            sipXml = archive.getInputStream(sipXmlJarEntry);
            SipApplication sipApplication = SipParser.parse(sipXml);
            return sipApplication;
        }
        finally {
            if (sipXml != null) {
                sipXml.close();
            }
        }
    }

    public static SipApplication parse(InputStream sipXml) throws IOException, ModuleDeployException, SAXException {
        URL sipXmlRules = SipParser.class.getClassLoader().getResource(SIP_XML_RULES_FILE);
        Digester digester = new Digester();
        SipEntityResolver entityResolver = new SipEntityResolver();
        digester.setValidating(false);
        digester.setClassLoader(SipParser.class.getClassLoader());
        digester.setEntityResolver((EntityResolver)entityResolver);
        digester.resolveEntity(null, null);
        digester.setValidating(false);
        SipDeploymentDescriptorRuleSet ruleSet = new SipDeploymentDescriptorRuleSet();
        ruleSet.addRuleInstances(digester);
        SipApplication sipApplication = (SipApplication)digester.parse(sipXml);
        return sipApplication;
    }
}

