/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.router;

import com.ericsson.ssa.router.RouterConfigException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationRouter;
import javax.servlet.sip.SipApplicationRouterInfo;
import javax.servlet.sip.SipApplicationRoutingDirective;
import javax.servlet.sip.SipServletReadOnlyRequest;
import javax.servlet.sip.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultApplicationRouter
implements SipApplicationRouter {
    private static final String CONFIGFILE_PROPERTY = "javax.servlet.sip.dar.configuration";
    private Logger _log = Logger.getLogger("SipContainer");
    private HashMap<String, HashMap<Integer, RouterInfoBean>> itsRouterInfoMap = new HashMap();

    public void deployedApplications(List<String> applications) {
        if (this._log.isLoggable(Level.INFO)) {
            for (String app : applications) {
                this._log.info("Application deployed " + app);
            }
        }
        this.readConfiguration();
    }

    public void destroy() {
        if (this._log.isLoggable(Level.INFO)) {
            this._log.info("destroy()");
        }
        this.itsRouterInfoMap.clear();
    }

    public SipApplicationRouterInfo getNextApplication(SipServletReadOnlyRequest initialRequest, boolean lastError, SipApplicationRoutingDirective directive, Object stateInfo) {
        if (this._log.isLoggable(Level.FINEST)) {
            this._log.finest("----- getNextApplication() ----->");
        }
        Integer order = new Integer(0);
        if (stateInfo != null) {
            try {
                order = new Integer(stateInfo.toString());
            }
            catch (NumberFormatException e) {
                this._log.severe("Unknown type of stateInfo received from container: " + stateInfo);
                return null;
            }
        }
        String method = initialRequest.getMethod();
        this._log.info("Looking up application router info for request with method: " + method + " (order = " + order + ", will increase by one)");
        RouterInfoBean infoBean = null;
        HashMap<Integer, RouterInfoBean> infoMap = this.itsRouterInfoMap.get(method);
        if (infoMap == null) {
            this._log.info("No routing info found for request method " + method + "returning null");
            return null;
        }
        Integer n = order;
        Integer n2 = order = Integer.valueOf(order + 1);
        infoBean = infoMap.get(order);
        if (infoBean == null) {
            this._log.info("No routing info found for request method " + method + " and order " + order + " (returning null)");
            return null;
        }
        this._log.info("Found info in DAR cache: " + infoBean);
        String subId = infoBean.getSubscriberId();
        URI subUri = null;
        if (subId.startsWith("DAR:")) {
            String header = subId.substring(4).trim();
            try {
                subUri = initialRequest.getAddressHeader(header).getURI();
            }
            catch (ServletParseException e) {
                this._log.severe("Header " + header + " does not resolve to a valid Subscriber URI " + "(will use null instead)... " + e.getMessage());
            }
        }
        SipApplicationRouterInfo info = new SipApplicationRouterInfo(infoBean.getApplicationName(), subUri, "" + infoBean.getStateInfo(), infoBean.getRegion());
        if (this._log.isLoggable(Level.FINEST)) {
            this._log.finest("<----- getNextApplication() -----");
        }
        return info;
    }

    public void init(List<String> applications) {
        this._log.info("INIT_IN");
        for (String app : applications) {
            this._log.info("INIT_APPLICATION" + app);
        }
        this.readConfiguration();
    }

    public void undeployedApplications(List<String> applications) {
        if (this._log.isLoggable(Level.INFO)) {
            for (String app : applications) {
                this._log.info("Application undeployed " + app);
            }
        }
        this.readConfiguration();
    }

    private void readConfiguration() {
        this.itsRouterInfoMap.clear();
        String filename = System.getProperty(CONFIGFILE_PROPERTY);
        if (filename == null || "".equals(filename)) {
            this._log.warning("System property javax.servlet.sip.dar.configuration not set. DAR will not route to any applications!");
            return;
        }
        this._log.info("Reading DAR routing info from " + filename);
        try {
            FileReader input = new FileReader(filename);
            BufferedReader bufRead = new BufferedReader(input);
            String line = bufRead.readLine().trim();
            int linenr = 1;
            while (line != null) {
                this._log.info("read: " + line);
                try {
                    String trimmedLine = line.trim();
                    if (!"".equals(trimmedLine)) {
                        this.parseLine(trimmedLine);
                    }
                    line = bufRead.readLine();
                }
                catch (Exception e) {
                    this._log.severe("Failed to parse line " + linenr + " in DAR configuration file (skipped rest). " + e);
                    break;
                }
                ++linenr;
            }
            bufRead.close();
        }
        catch (IOException e) {
            this._log.severe("Failed opening DAR config file! " + e);
        }
    }

    private void parseLine(String aLine) throws RouterConfigException {
        int colonindex = aLine.indexOf(58);
        String method = aLine.substring(0, colonindex);
        this._log.info("Parsing routing info for method " + method);
        HashMap<Integer, RouterInfoBean> infoMap = new HashMap<Integer, RouterInfoBean>();
        StringTokenizer st = new StringTokenizer(aLine.substring(colonindex + 1).trim(), "(");
        while (st.hasMoreElements()) {
            String s_tmp = st.nextToken();
            String s = s_tmp.substring(0, s_tmp.indexOf(41));
            StringTokenizer st2 = new StringTokenizer(s, ",");
            Vector<String> tokens = new Vector<String>();
            while (st2.hasMoreElements()) {
                String quotedToken = st2.nextToken().trim();
                String token = quotedToken.substring(1, quotedToken.lastIndexOf(34));
                tokens.add(token);
            }
            RouterInfoBean infoBean = new RouterInfoBean();
            infoBean.setApplicationName((String)tokens.get(0));
            infoBean.setSubscriberId((String)tokens.get(1));
            infoBean.setRegion((String)tokens.get(2));
            infoBean.setRouteUri((String)tokens.get(3));
            infoBean.setRouteModifier((String)tokens.get(4));
            String stateInfo = (String)tokens.get(5);
            infoBean.setStateInfo(stateInfo);
            infoMap.put(infoBean.getStateInfo(), infoBean);
        }
        this.itsRouterInfoMap.put(method, infoMap);
    }

    private class RouterInfoBean {
        private String applicationName;
        private String subscriberId;
        private String region;
        private String routeUri;
        private String routeModifier;
        private Integer stateInfo;

        private RouterInfoBean() {
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getRouteModifier() {
            return this.routeModifier;
        }

        public void setRouteModifier(String routeModifier) {
            this.routeModifier = routeModifier;
        }

        public String getRouteUri() {
            return this.routeUri;
        }

        public void setRouteUri(String routeUri) {
            this.routeUri = routeUri;
        }

        public Integer getStateInfo() {
            return this.stateInfo;
        }

        public void setStateInfo(String stateInfo) throws RouterConfigException {
            try {
                this.stateInfo = new Integer(stateInfo);
            }
            catch (NumberFormatException e) {
                throw new RouterConfigException("Malformed stateInfo in DAR configuration: " + stateInfo, e);
            }
        }

        public String getSubscriberId() {
            return this.subscriberId;
        }

        public void setSubscriberId(String subscriberId) throws RouterConfigException {
            if (subscriberId.startsWith("DAR:")) {
                try {
                    subscriberId.substring(4);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new RouterConfigException("Malformed subscriberId in DAR configuration: " + subscriberId, e);
                }
            }
            this.subscriberId = subscriberId;
        }

        public String toString() {
            return "appName=" + this.applicationName + ", subId=" + this.subscriberId + ", region=" + this.region + ", routeUri=" + this.routeUri + ", routeModifier=" + this.routeModifier + ", stateInfo=" + this.stateInfo;
        }
    }
}

