/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.ParameterableImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.URI;

public class AddressImpl
extends ParameterableImpl
implements Address,
Serializable {
    private static final long serialVersionUID = 3761123855715873593L;
    static String DUPLICATE_PARAM = "The parsed Name Address has two parameter with the same name : ";
    public static final String Q_PARAM = "q";
    public static final String EXPIRES_PARAM = "expires";
    public static final String TAG_PARAM = "tag";
    private static transient SipFactory sf = SipFactoryImpl.getInstance();
    private String _displayName;
    private URI _uri;
    private boolean _readOnly = false;
    private boolean _wildcard = false;

    private AddressImpl() {
    }

    public AddressImpl(String na) throws ServletParseException {
        if (na.trim().equals("*")) {
            this._wildcard = true;
        } else {
            byte[] bytes = null;
            try {
                bytes = na.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            this.parse(bytes, 0, bytes.length);
        }
    }

    public AddressImpl(URI uri) {
        this._uri = uri;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            stream.defaultWriteObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            stream.defaultReadObject();
            sf = SipFactoryImpl.getInstance();
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    private void parse(byte[] bytes, int offset, int length) throws ServletParseException {
        int leftDquoteIndex = -1;
        int rightDquoteIndex = -1;
        int laquotIndex = -1;
        int raquotIndex = -1;
        int semiIndex = -1;
        int quoteCnt = 0;
        int endParamIndex = length;
        for (int i = offset; i < length; ++i) {
            if (bytes[i] == 34) {
                ++quoteCnt;
                if (laquotIndex != -1) continue;
                if (leftDquoteIndex == -1) {
                    leftDquoteIndex = i;
                    continue;
                }
                if (rightDquoteIndex >= 0) continue;
                rightDquoteIndex = i;
                continue;
            }
            if (laquotIndex == -1 && bytes[i] == 60 && quoteCnt % 2 == 0) {
                laquotIndex = i;
                continue;
            }
            if (raquotIndex == -1 && bytes[i] == 62 && quoteCnt % 2 == 0) {
                raquotIndex = i;
                continue;
            }
            if (bytes[i] != 59 || semiIndex >= 0 || quoteCnt % 2 != 0) continue;
            if (laquotIndex >= 0) {
                if (raquotIndex <= 0 || i <= raquotIndex) continue;
                semiIndex = i;
                continue;
            }
            semiIndex = i;
        }
        if (laquotIndex == -1 && raquotIndex > 0 || laquotIndex > 0 && raquotIndex == -1) {
            throw new ServletParseException("invalid nr of > or <");
        }
        try {
            if (rightDquoteIndex > -1) {
                this._displayName = new String(bytes, leftDquoteIndex + 1, rightDquoteIndex - (leftDquoteIndex + 1), "UTF-8");
                offset = rightDquoteIndex + 1;
            } else if (laquotIndex > -1) {
                this._displayName = new String(bytes, offset, laquotIndex - offset, "UTF-8").trim();
                offset = laquotIndex;
            }
            if (laquotIndex > -1) {
                String uri = new String(bytes, laquotIndex + 1, raquotIndex - (laquotIndex + 1), "UTF-8");
                this._uri = sf.createURI(uri);
            } else {
                int endIndex = semiIndex;
                if (endIndex < 0) {
                    endIndex = length;
                }
                String uri = new String(bytes, offset, endIndex - offset, "UTF-8").trim();
                this._uri = sf.createURI(uri);
            }
            offset = semiIndex + 1;
            if (semiIndex > 0) {
                int numBytes = endParamIndex - semiIndex;
                this.setParameterByteMap(bytes, semiIndex, numBytes, ';');
            }
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public void setDisplayName(String dn) {
        if (this._wildcard) {
            throw new IllegalStateException("Cannot set display name on wildcard address");
        }
        if (this._readOnly) {
            throw new IllegalStateException("You cannot modify a system header.");
        }
        this._displayName = dn;
    }

    public URI getURI() {
        if (this._wildcard) {
            new Throwable().printStackTrace();
            return null;
        }
        return this._uri;
    }

    public void setURI(URI uri) {
        if (this._wildcard) {
            throw new IllegalStateException("Cannot set URI on wildcard address");
        }
        if (this._readOnly) {
            throw new IllegalStateException("You cannot modify a system header.");
        }
        this._uri = uri;
    }

    public void setParameter(String param, String value) {
        if (this._wildcard) {
            throw new IllegalStateException("Cannot set parameter on wildcard address");
        }
        if (this._readOnly) {
            throw new IllegalStateException("You cannot modify a system header.");
        }
        super.setParameter(param, value);
    }

    public void removeParameter(String param) {
        if (this._wildcard) {
            throw new IllegalStateException("Cannot set parameter on wildcard address");
        }
        if (this._readOnly) {
            throw new IllegalStateException("You cannot modify a system header.");
        }
        super.removeParameter(param);
    }

    public boolean isWildcard() {
        return this._wildcard;
    }

    public float getQ() {
        float q = -1.0f;
        String value = this.getParameter(Q_PARAM);
        if (value != null) {
            try {
                q = Float.parseFloat(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return q;
    }

    public void setQ(float value) {
        if (value < 0.0f) {
            super.removeParameter(Q_PARAM);
        } else {
            this.setParameter(Q_PARAM, String.valueOf(value));
        }
    }

    public int getExpires() {
        int expires = -1;
        String value = this.getParameter(EXPIRES_PARAM);
        if (value != null) {
            try {
                expires = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return expires;
    }

    public void setExpires(int value) {
        if (value < 0) {
            super.removeParameter(EXPIRES_PARAM);
        } else {
            this.setParameter(EXPIRES_PARAM, String.valueOf(value));
        }
    }

    public Object clone() {
        return this.clone(false, false);
    }

    public Object clone(boolean copyTag, boolean copyReadOnly) {
        AddressImpl newAddress = (AddressImpl)super.clone();
        newAddress._displayName = this._displayName;
        newAddress._uri = this._uri;
        newAddress._wildcard = this._wildcard;
        if (copyReadOnly) {
            newAddress._readOnly = this._readOnly;
        }
        return newAddress;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof AddressImpl)) {
            return false;
        }
        AddressImpl a = (AddressImpl)o;
        if (!this._displayName.equals(a.getDisplayName())) {
            return false;
        }
        if (!this._uri.equals(a.getURI())) {
            return false;
        }
        return this._wildcard == a.isWildcard();
    }

    public void setReadOnly(boolean writeable) {
        this._readOnly = writeable;
    }

    public String toString() {
        if (this._wildcard) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        if (this._displayName != null && this._displayName.length() > 0) {
            sb.append('\"');
            sb.append(this._displayName);
            sb.append('\"');
        }
        sb.append('<');
        sb.append(this._uri);
        sb.append('>');
        sb.append(super.toString());
        return sb.toString();
    }
}

