/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.BasicMandatoryHeaderValidator;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SipServletMessageImpl;

public class CSeqHeaderValidator
extends BasicMandatoryHeaderValidator {
    public static final long LIMIT_32BIT_UNSIGNED = 0x100000000L;

    public CSeqHeaderValidator() {
        super("Cseq");
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader("Cseq");
        if (header == null || header.getValue() == null || header.getValue().length() == 0) {
            return false;
        }
        String value = header.getValue();
        String[] parts = this.splitLWS(value);
        if (parts.length != 2) {
            return false;
        }
        return this.isNumber(parts[0]) && this.isMethod(parts[1]);
    }

    private boolean isMethod(String method) {
        return this.isToken(method);
    }

    private boolean isNumber(String numberPart) {
        try {
            long cseqNumber = Long.parseLong(numberPart);
            return cseqNumber >= 0L && cseqNumber < 0x100000000L;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

