/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.BasicMandatoryHeaderValidator;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import java.util.regex.Pattern;

public class CallIDValidator
extends BasicMandatoryHeaderValidator {
    private static final String REGEXP_WORD = "[a-zA-Z1234567890\\-.!%*_+`\u00ef\u00bf\u00bd~()<>:\\\\\\\"/\\[\\]?{}']+";
    private static final String REGEXP_CALLID = "([a-zA-Z1234567890\\-.!%*_+`\u00ef\u00bf\u00bd~()<>:\\\\\\\"/\\[\\]?{}']+)(@[a-zA-Z1234567890\\-.!%*_+`\u00ef\u00bf\u00bd~()<>:\\\\\\\"/\\[\\]?{}']+){0,1}";
    private Pattern callIDPattern = Pattern.compile("([a-zA-Z1234567890\\-.!%*_+`\u00ef\u00bf\u00bd~()<>:\\\\\\\"/\\[\\]?{}']+)(@[a-zA-Z1234567890\\-.!%*_+`\u00ef\u00bf\u00bd~()<>:\\\\\\\"/\\[\\]?{}']+){0,1}");

    public CallIDValidator() {
        super("Call-Id");
    }

    public boolean validate(SipServletMessageImpl message) {
        Header header = message.getRawHeader("Call-Id");
        if (header == null || header.getValue() == null || header.getValue().length() == 0) {
            return false;
        }
        String value = header.getValue();
        return this.callIDPattern.matcher(value).matches();
    }
}

