/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ConvergedHttpSession;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.session.StandardSessionFacade;

public class ConvergedHttpSessionFacade
extends StandardSessionFacade
implements ConvergedHttpSession {
    private static final String SIP_APP_SESSION_ID_PARAM = ";sipappsessionid=";
    private static final String HTTP_PROTOCOL = "http";
    private static final String HTTPS_PROTOCOL = "https";
    private SipApplicationSession sipAppSession;
    private StandardSession httpSession;
    private ServletContext servletCtxt;
    private SipSessionManager sipSessionManager;

    public ConvergedHttpSessionFacade(StandardSession httpSession, SipSessionManager sipSessionManager) {
        super(httpSession);
        this.httpSession = httpSession;
        this.sipSessionManager = sipSessionManager;
        StandardContext ctxt = (StandardContext)httpSession.getManager().getContainer();
        this.servletCtxt = ctxt.getServletContext();
    }

    public SipApplicationSession getApplicationSession() {
        String requestURL;
        int index;
        StringBuffer sb;
        if (this.sipAppSession != null) {
            return this.sipAppSession;
        }
        String sipAppSessionId = this.httpSession.getSipApplicationSessionId();
        if (sipAppSessionId == null && (sb = this.httpSession.getRequestURL()) != null && (index = (requestURL = sb.toString()).indexOf(SIP_APP_SESSION_ID_PARAM)) != -1) {
            int beginId = index + SIP_APP_SESSION_ID_PARAM.length();
            int semicolon = requestURL.indexOf(59, beginId);
            sipAppSessionId = semicolon != -1 ? requestURL.substring(beginId, semicolon) : requestURL.substring(beginId);
        }
        if (sipAppSessionId != null) {
            this.sipAppSession = this.sipSessionManager.findApplicationSession(sipAppSessionId);
        } else {
            SipFactory sipFactory = (SipFactory)this.servletCtxt.getAttribute("javax.servlet.sip.SipFactory");
            if (sipFactory == null) {
                throw new IllegalStateException("No SipFactory");
            }
            this.sipAppSession = sipFactory.createApplicationSession();
        }
        if (this.sipAppSession != null && this.httpSession.getSipApplicationSessionId() == null) {
            this.httpSession.setSipApplicationSessionId(this.sipAppSession.getId());
            ((SipApplicationSessionImpl)this.sipAppSession).addSession((HttpSession)this);
        }
        return this.sipAppSession;
    }

    public String encodeURL(String url) {
        if (this.sipAppSession == null) {
            return url;
        }
        String sasId = this.sipAppSession.getId();
        if (!this.isEncodeable(url, sasId)) {
            return url;
        }
        return this.toEncoded(url, sasId);
    }

    public String encodeURL(String relativePath, String scheme) {
        if (relativePath == null || !relativePath.startsWith("/")) {
            throw new IllegalArgumentException("Illegal relative path: " + relativePath);
        }
        if (scheme == null || !scheme.equals(HTTP_PROTOCOL) && !scheme.equals(HTTPS_PROTOCOL)) {
            throw new IllegalArgumentException("Invalid protocol: " + scheme);
        }
        StringBuffer reqUrlStr = this.httpSession.getRequestURL();
        if (reqUrlStr == null) {
            throw new IllegalStateException("No request URL");
        }
        URL requestUrl = null;
        try {
            requestUrl = new URL(reqUrlStr.toString());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        StringBuilder sb = new StringBuilder(scheme);
        sb.append("://");
        sb.append(requestUrl.getHost());
        sb.append(':');
        sb.append(requestUrl.getPort());
        sb.append(this.servletCtxt.getContextPath());
        sb.append(relativePath);
        return this.encodeURL(sb.toString());
    }

    private boolean isEncodeable(String urlString, String sasId) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            return false;
        }
        String myContextPath = this.servletCtxt.getContextPath();
        if (myContextPath != null) {
            String file = url.getFile();
            if (file == null || !file.startsWith(myContextPath)) {
                return false;
            }
            if (file.indexOf(SIP_APP_SESSION_ID_PARAM + sasId) >= 0) {
                return false;
            }
        }
        return true;
    }

    private String toEncoded(String url, String sasId) {
        StringBuilder encoded;
        int pound;
        if (url == null || sasId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((encoded = new StringBuilder(path)).length() > 0) {
            encoded.append(SIP_APP_SESSION_ID_PARAM);
            encoded.append(sasId);
        }
        encoded.append(anchor);
        encoded.append(query);
        return encoded.toString();
    }
}

