/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.DialogFragment;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DialogFragmentManager {
    private static final Logger logger = Logger.getLogger("SipContainer");
    private static final DialogFragmentManager fragmentManager = new DialogFragmentManager();
    private AtomicLong concurrentSipDialogs;
    private AtomicLong totalSipDialogCount;
    private AtomicLong totalSipDialogLifeTime;
    private AtomicLong expiredSipDialogs;
    protected ConcurrentHashMap<String, DialogFragment> dialogFragments = new ConcurrentHashMap();

    private DialogFragmentManager() {
        this.concurrentSipDialogs = new AtomicLong();
        this.totalSipDialogCount = new AtomicLong();
        this.totalSipDialogLifeTime = new AtomicLong();
        this.expiredSipDialogs = new AtomicLong();
    }

    public static DialogFragmentManager getInstance() {
        return fragmentManager;
    }

    public void registerDialogFragment(DialogFragment d) {
        if (PerformanceMBeanListener.isEnabled() && d.getFragmentId() == 1) {
            this.concurrentSipDialogs.incrementAndGet();
        }
        this.dialogFragments.put(d.getDialogId(), d);
    }

    public DialogFragment findDialogFragment(String id) {
        return this.dialogFragments.get(id);
    }

    public void removeDialogFragment(DialogFragment d, boolean hasTimedOut) {
        DialogFragment storedDlg = this.dialogFragments.remove(d.getDialogId());
        if (storedDlg != null && PerformanceMBeanListener.isEnabled() && d.getFragmentId() == 1) {
            this.concurrentSipDialogs.decrementAndGet();
            this.totalSipDialogCount.incrementAndGet();
            this.totalSipDialogLifeTime.addAndGet(d.getDialogLifetime());
            if (logger.isLoggable(Level.FINE)) {
                long nDialogs = this.totalSipDialogCount.get();
                double cumulativeLifetime = this.totalSipDialogLifeTime.doubleValue();
                double average = cumulativeLifetime / (double)nDialogs;
                logger.log(Level.FINE, "DialogLifetime=" + d.getDialogLifetime() + "; nDialogs=" + nDialogs + "; cumulativeLifetime=" + cumulativeLifetime + ";averageLifetime=" + average);
            }
            if (hasTimedOut) {
                this.expiredSipDialogs.incrementAndGet();
            }
        }
    }

    public long getEasTotalSipDialogCount() {
        return this.totalSipDialogCount.longValue();
    }

    public long getEasConcurrentSipDialogs() {
        return this.concurrentSipDialogs.longValue();
    }

    public long getEasTotalSipDialogLifeTime() {
        return this.totalSipDialogLifeTime.longValue();
    }

    public long getEasExpiredSipDialogs() {
        return this.expiredSipDialogs.longValue();
    }
}

