/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.Ascii7String;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.DialogFragmentManager;
import com.ericsson.ssa.sip.SessionManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.sip.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogSet
implements Externalizable {
    private static final long serialVersionUID = -6352106202257349396L;
    private Ascii7String m_CallId;
    private Address m_From;
    private Queue<DialogFragment> m_Dialogs = new ConcurrentLinkedQueue<DialogFragment>();
    private AtomicInteger m_DialogSetFragmentId = new AtomicInteger(1);
    private boolean m_IsEarlyDialogValid = true;

    public DialogSet(String callId, Address from) {
        this.m_CallId = new Ascii7String(callId);
        this.m_From = from;
    }

    public DialogSet() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.m_CallId.toString());
        out.writeObject(this.m_From);
        out.writeInt(this.m_Dialogs.size());
        Iterator i = this.m_Dialogs.iterator();
        while (i.hasNext()) {
            out.writeObject(i.next());
        }
        out.writeInt(this.m_DialogSetFragmentId.get());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.m_CallId = new Ascii7String(in.readUTF());
        this.m_From = (Address)in.readObject();
        this.m_Dialogs.clear();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            this.m_Dialogs.add((DialogFragment)in.readObject());
        }
        this.m_DialogSetFragmentId = new AtomicInteger(in.readInt());
    }

    public String getCallId() {
        return this.m_CallId.toString();
    }

    public Address getFrom() {
        return this.m_From;
    }

    public String getFromTag() {
        return this.getFrom().getParameter("tag");
    }

    public void addDialog(DialogFragment d) {
        this.m_Dialogs.add(d);
    }

    public void removeDialog(DialogFragment d) {
        this.m_Dialogs.remove(d);
        this.removeEarlyDialog();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEarlyDialog() {
        if (this.m_IsEarlyDialogValid) {
            DialogSet dialogSet = this;
            synchronized (dialogSet) {
                if (this.m_IsEarlyDialogValid) {
                    SessionManager.getInstance().removeEarlyDialog(this);
                    this.m_IsEarlyDialogValid = false;
                }
            }
        }
    }

    public DialogFragment getDialog(int fragmentId) {
        for (DialogFragment d : this.m_Dialogs) {
            if (fragmentId != d.getFragmentId()) continue;
            return d;
        }
        return null;
    }

    public Iterator<DialogFragment> getDialogs() {
        return this.m_Dialogs.iterator();
    }

    public DialogFragment searchForDialog(String toTag, int fragmentId) {
        String key = DialogFragment.createKey(this.m_CallId.toString(), this.getFromTag(), toTag, fragmentId);
        return DialogFragmentManager.getInstance().findDialogFragment(key);
    }

    public DialogFragment cloneDialog(int fragmentId) {
        for (DialogFragment d : this.m_Dialogs) {
            if (fragmentId != d.getFragmentId()) continue;
            return (DialogFragment)d.clone();
        }
        return null;
    }

    public int nextFragmentId() {
        return this.m_DialogSetFragmentId.incrementAndGet();
    }
}

