/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.FSM;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.UA;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.SipServletMessage;

public class GeneralSession
extends FSM {
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private static GeneralSession m_Instance = new GeneralSession();

    private GeneralSession() {
    }

    public static FSM createFSM(SipServletMessage m) {
        if (GeneralSession.isStaticResponsible(m)) {
            return m_Instance;
        }
        return null;
    }

    public Object clone() {
        return m_Instance;
    }

    private static boolean isStaticResponsible(SipServletMessage m) {
        String method = m.getMethod();
        return !(method.equals("ACK") || method.equals("BYE") || method.equals("CANCEL") || method.equals("INVITE") || method.equals("PRACK") || method.equals("UPDATE") || method.equals("SUBSCRIBE") || method.equals("REFER") || method.equals("NOTIFY"));
    }

    public boolean isResponsible(SipServletMessage m) {
        return GeneralSession.isStaticResponsible(m);
    }

    public boolean isDeletable() {
        return false;
    }

    public void send(SipServletRequestImpl req, UA ua) throws IllegalStateException {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, req.toDebugString());
        }
        SipServletRequestImpl clone = (SipServletRequestImpl)req.clone();
        clone.setTransactionRequest(req);
        super.send(clone, ua);
    }

    public void send(SipServletResponseImpl resp, UA ua) throws IllegalStateException {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, resp.toDebugString());
        }
        if (!resp.hasToTag()) {
            resp.createTag("To");
        }
        SipServletResponseImpl clone = (SipServletResponseImpl)resp.clone();
        SipServletRequestImpl req = resp.getRequestImpl().getTransactionRequest();
        if (req != null) {
            clone.setRequest(req);
            clone.setSession(req.getSessionImpl());
        }
        super.send(clone, ua);
    }

    public void dispatch(SipServletRequestImpl req, UA ua) {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, req.toDebugString());
        }
        try {
            Servlet s = ua.getServlet(req.getSessionImpl().getHandler());
            if (s != null) {
                s.service((ServletRequest)req, null);
            } else if (m_Log.isLoggable(Level.INFO)) {
                m_Log.log(Level.INFO, "Could not find servlet name: " + req.getSessionImpl().getHandler() + " in application: " + req.getSessionImpl().getApplicationSessionImpl().getName());
            }
        }
        catch (Exception e) {
            SipServletResponseImpl resp;
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, "Problem in servlet ", e);
            }
            if ((resp = req.createTerminatingResponse(500)) == null) {
                return;
            }
            resp.popDispatcher().dispatch(resp);
        }
    }

    public void dispatch(SipServletResponseImpl resp, UA ua) {
        block6: {
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, resp.toDebugString());
            }
            try {
                Servlet s = ua.getServlet(resp.getSessionImpl().getHandler());
                if (s != null) {
                    s.service(null, (ServletResponse)resp);
                } else if (m_Log.isLoggable(Level.INFO)) {
                    m_Log.log(Level.INFO, "Could not find servlet name: " + resp.getSessionImpl().getHandler() + " in application: " + resp.getSessionImpl().getApplicationSessionImpl().getName());
                }
            }
            catch (Exception e) {
                if (!m_Log.isLoggable(Level.INFO)) break block6;
                m_Log.log(Level.INFO, "Problem in servlet.", e);
            }
        }
    }
}

