/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.FSM;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.SingleLineHeader;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.UA;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipErrorEvent;
import javax.servlet.sip.SipErrorListener;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.TimerListener;

public class INVITESession
extends FSM
implements TimerListener {
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private static List<String> m_StateStrings = new ArrayList<String>(16);
    private static final int RUNNING = 0;
    private static final int INITIAL_UAC = 1;
    private static final int ONLY_CANCEL_ALLOWED_UAC = 2;
    private static final int EARLY_UAC = 3;
    private static final int CONFIRMED_UAC = 4;
    private static final int CLOSING_UAC = 5;
    private static final int TERMINATED_UAC = 6;
    private static final int INITIAL_UAS = 7;
    private static final int ONLY_CANCEL_ALLOWED_UAS = 8;
    private static final int EARLY_UAS = 9;
    private static final int CONFIRMED_UAS = 10;
    private static final int TIMEOUT_UAS = 11;
    private static final int CLOSING_UAS = 12;
    private static final int TERMINATED_UAS = 13;
    private static final int RE_INVITE_UAC = 14;
    private static final int RE_INVITE_UAS = 15;
    private static final int PRACKED_UAS = 16;
    private static long T1;
    private static long T2;
    private int m_State = 7;
    private SipServletRequestImpl m_OriginalINVITE = null;
    private SipServletRequestImpl m_PendingCANCEL = null;
    private ServletTimerImpl m_TimerShort;
    private ServletTimerImpl m_TimerShortProvRsp;
    private ServletTimerImpl m_TimerLong;
    private ServletTimerImpl m_TimerLongProvRsp;
    private String m_Rack = null;
    private boolean m_PrackReceived = false;
    private SipServletResponseImpl m_RetransmitResponse = null;
    private SipServletResponseImpl m_RetransmitReliableResponse = null;
    private SipServletRequestImpl m_RetransmitACK = null;
    private Header m_CancelVia = null;

    private INVITESession() {
    }

    private INVITESession(int state, SipServletRequestImpl originalINVITE, SipServletRequestImpl pendingCANCEL) {
        this.m_State = state;
        this.m_OriginalINVITE = originalINVITE;
        this.m_PendingCANCEL = pendingCANCEL;
    }

    public static FSM createFSM(SipServletMessage m) {
        if (m.getMethod().equals("INVITE")) {
            return new INVITESession();
        }
        return null;
    }

    public Object clone() {
        return new INVITESession(3, this.m_OriginalINVITE, this.m_PendingCANCEL);
    }

    private static boolean isStaticResponsible(SipServletMessage m) {
        String method = m.getMethod();
        return method.equals("ACK") || method.equals("BYE") || method.equals("CANCEL") || method.equals("INVITE") || method.equals("PRACK") || method.equals("UPDATE");
    }

    public boolean isResponsible(SipServletMessage m) {
        return INVITESession.isStaticResponsible(m);
    }

    private void storeRAck(SipServletResponseImpl resp, UA uac) throws IllegalStateException {
        String rseq = resp.getHeader("Rseq");
        if (rseq != null) {
            String CSeq = resp.getHeader("Cseq");
            if (CSeq != null) {
                this.m_Rack = rseq + " " + CSeq;
            } else {
                throw new IllegalStateException("CSeq header is missing.");
            }
        }
    }

    private void retreiveRAck(SipServletRequestImpl req, UA uac) throws IllegalStateException {
        if (this.m_Rack == null) {
            throw new IllegalStateException("RAck is undefined.");
        }
        SingleLineHeader rack = new SingleLineHeader("Rack", true);
        ((Header)rack).setValue(this.m_Rack, true);
        req.setHeader(rack);
    }

    private synchronized boolean doRequestUAC(SipServletRequestImpl req, UA uac) throws IllegalStateException {
        boolean isDispatchEnabled = true;
        String method = req.getMethod();
        if (req.isInitial() && method.equals("INVITE")) {
            if (!uac.addDialogSession(method, null)) {
                throw new IllegalStateException("Not allowed with two INVITE at one time.");
            }
            this.m_State = 1;
            this.m_OriginalINVITE = req;
        } else {
            switch (this.m_State) {
                case 1: {
                    if (this.m_PendingCANCEL == null && method.equals("CANCEL")) {
                        this.m_PendingCANCEL = req;
                        isDispatchEnabled = false;
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 2: {
                    if (this.m_PendingCANCEL == null && method.equals("CANCEL")) {
                        req.setHeader(this.m_CancelVia);
                        this.m_OriginalINVITE = null;
                        break;
                    }
                    throw new IllegalStateException();
                }
                case 3: {
                    if (this.m_PendingCANCEL == null && method.equals("CANCEL")) {
                        req.setHeader(this.m_CancelVia);
                        this.m_OriginalINVITE = null;
                        break;
                    }
                    if (method.equals("BYE")) {
                        this.m_State = 5;
                        break;
                    }
                    if (method.equals("PRACK")) {
                        this.retreiveRAck(req, uac);
                        break;
                    }
                    if (method.equals("UPDATE")) break;
                    throw new IllegalStateException();
                }
                case 4: {
                    if (method.equals("ACK")) {
                        this.m_RetransmitACK = req;
                        this.m_State = 0;
                        break;
                    }
                    if (method.equals("BYE")) {
                        this.m_State = 5;
                        break;
                    }
                    if (method.equals("PRACK")) {
                        this.retreiveRAck(req, uac);
                        break;
                    }
                    if (method.equals("UPDATE")) break;
                    throw new IllegalStateException();
                }
                case 6: {
                    if (!method.equals("CANCEL")) break;
                    throw new IllegalStateException();
                }
                case 0: {
                    if (method.equals("BYE")) {
                        this.m_State = 5;
                        break;
                    }
                    if (method.equals("INVITE")) {
                        this.m_State = 14;
                        break;
                    }
                    if (method.equals("PRACK")) {
                        this.retreiveRAck(req, uac);
                        break;
                    }
                    if (method.equals("UPDATE")) break;
                    throw new IllegalStateException();
                }
                case 11: 
                case 14: {
                    if (method.equals("BYE")) {
                        this.m_State = 5;
                        break;
                    }
                    if (method.equals("UPDATE")) break;
                    throw new IllegalStateException();
                }
                case 8: 
                case 9: 
                case 10: 
                case 15: {
                    if (method.equals("UPDATE")) break;
                }
                case 5: 
                case 7: 
                case 12: 
                case 13: {
                    throw new IllegalStateException();
                }
            }
        }
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, req.toDebugString() + ", state = " + this.stateToString() + ", reference = " + this);
        }
        return isDispatchEnabled;
    }

    public void send(SipServletRequestImpl req, UA uac) throws IllegalStateException {
        if (this.doRequestUAC(req, uac)) {
            SipServletRequestImpl clone = (SipServletRequestImpl)req.clone();
            clone.setTransactionRequest(req);
            super.send(clone, uac);
        }
    }

    private void setDerivedOrOriginalSession(SipServletResponseImpl resp, UA ua) {
        if (ua.getSipSession() != null && !ua.getSipSession().hasNoToTag() && resp.getDialog().getToTag() != null && resp.getDialog().getToTag().equals(ua.getSipSession().getToTag())) {
            resp.setSession(ua.getSipSession());
        } else {
            DialogFragment df = resp.getDialog();
            SipSessionBase s = resp.getSessionImpl().getOriginalOrDerivedSessionAndRegisterDialog(resp, df);
            if (s.isDerived()) {
                resp.setSession(s);
            }
            ua.setSipSession(s);
        }
    }

    private synchronized boolean doResponseUAC(SipServletResponseImpl resp, UA uac) {
        boolean isInvokeServlet = true;
        int status = resp.getStatus();
        String method = resp.getMethod();
        switch (this.m_State) {
            case 1: {
                if (!method.equals("INVITE")) break;
                if (status == 100) {
                    this.m_State = 2;
                    resp.setSession(uac.getSipSession());
                    isInvokeServlet = false;
                    if (this.m_OriginalINVITE != null && this.m_PendingCANCEL != null) {
                        this.m_PendingCANCEL.setHeader(resp.getCancelVia());
                        this.m_PendingCANCEL.popDispatcher().dispatch(this.m_PendingCANCEL);
                        this.m_OriginalINVITE = null;
                        break;
                    }
                    this.m_CancelVia = resp.getCancelVia();
                    break;
                }
                if (status >= 101 && status < 200 && resp.hasToTag()) {
                    this.setDerivedOrOriginalSession(resp, uac);
                    if (resp.getRequest().isInitial()) {
                        try {
                            uac.saveRouteSetRemoteTarget(resp);
                        }
                        catch (ServletParseException e) {
                            if (m_Log.isLoggable(Level.FINE)) {
                                m_Log.log(Level.FINE, "Parse problem of Contact or Record-Route for response: " + resp);
                            }
                            isInvokeServlet = false;
                        }
                    }
                    this.storeRAck(resp, uac);
                    this.m_State = 3;
                    if (this.m_OriginalINVITE != null && this.m_PendingCANCEL != null) {
                        this.m_PendingCANCEL.setHeader(resp.getCancelVia());
                        this.m_PendingCANCEL.popDispatcher().dispatch(this.m_PendingCANCEL);
                        this.m_OriginalINVITE = null;
                        break;
                    }
                    this.m_CancelVia = resp.getCancelVia();
                    break;
                }
                if (status >= 200 && status < 300 && resp.hasToTag()) {
                    this.setDerivedOrOriginalSession(resp, uac);
                    if (resp.getRequest().isInitial()) {
                        try {
                            uac.saveRouteSetRemoteTarget(resp);
                        }
                        catch (ServletParseException e) {
                            if (m_Log.isLoggable(Level.FINE)) {
                                m_Log.log(Level.FINE, "Parse problem of Contact or Record-Route for response: " + resp);
                            }
                            isInvokeServlet = false;
                        }
                    }
                    this.m_State = 4;
                    this.m_PendingCANCEL = null;
                    this.m_CancelVia = null;
                    break;
                }
                if (status < 300 || status >= 700) break;
                uac.removeDialogSession(method, null);
                this.m_PendingCANCEL = null;
                this.m_CancelVia = null;
                this.m_OriginalINVITE = null;
                this.m_State = 1;
                break;
            }
            case 2: 
            case 3: {
                if (method.equals("INVITE")) {
                    if (status >= 101 && status < 200 && resp.hasToTag()) {
                        this.setDerivedOrOriginalSession(resp, uac);
                        if (resp.getRequest().isInitial()) {
                            try {
                                uac.saveRouteSetRemoteTarget(resp);
                            }
                            catch (ServletParseException e) {
                                if (m_Log.isLoggable(Level.FINE)) {
                                    m_Log.log(Level.FINE, "Parse problem of Contact or Record-Route for response: " + resp);
                                }
                                isInvokeServlet = false;
                            }
                        }
                        this.storeRAck(resp, uac);
                        this.m_State = 3;
                        if (this.m_OriginalINVITE != null && this.m_PendingCANCEL != null) {
                            this.m_PendingCANCEL.setHeader(resp.getCancelVia());
                            this.m_PendingCANCEL.popDispatcher().dispatch(this.m_PendingCANCEL);
                            this.m_OriginalINVITE = null;
                            break;
                        }
                        if (this.m_CancelVia == null) break;
                        this.m_CancelVia = resp.getCancelVia();
                        break;
                    }
                    if (status >= 200 && status < 300 && resp.hasToTag()) {
                        this.setDerivedOrOriginalSession(resp, uac);
                        if (resp.getRequest().isInitial()) {
                            try {
                                uac.saveRouteSetRemoteTarget(resp);
                            }
                            catch (ServletParseException e) {
                                if (m_Log.isLoggable(Level.FINE)) {
                                    m_Log.log(Level.FINE, "Parse problem of Contact or Record-Route for response: " + resp);
                                }
                                isInvokeServlet = false;
                            }
                        }
                        this.m_PendingCANCEL = null;
                        this.m_CancelVia = null;
                        this.m_OriginalINVITE = null;
                        this.m_State = 4;
                        break;
                    }
                    if (status < 300 || status >= 700 || !resp.hasToTag()) break;
                    uac.removeDialogSession(method, null);
                    this.m_PendingCANCEL = null;
                    this.m_CancelVia = null;
                    this.m_OriginalINVITE = null;
                    this.m_State = 1;
                    break;
                }
                if (!method.equals("CANCEL") || status < 200 || status >= 300) break;
                isInvokeServlet = false;
                break;
            }
            case 5: {
                if (!method.equals("BYE") || status < 200 || status >= 300) break;
                uac.removeDialogSession(method, null);
                this.m_State = 6;
                break;
            }
            case 0: 
            case 4: {
                if (!method.equals("INVITE")) break;
                if (status >= 200 && status < 300) {
                    if (this.m_RetransmitACK != null) {
                        SipServletRequestImpl ack = (SipServletRequestImpl)this.m_RetransmitACK.clone();
                        ack.popDispatcher().dispatch(ack);
                    }
                    isInvokeServlet = false;
                    break;
                }
                if (status != 491) break;
                break;
            }
            case 14: {
                if (!method.equals("INVITE")) break;
                if (status == 100) {
                    isInvokeServlet = false;
                }
                if (status >= 101 && status < 200 && resp.hasToTag()) {
                    this.storeRAck(resp, uac);
                    break;
                }
                if (status >= 200 && status < 300) {
                    this.m_State = 4;
                    break;
                }
                if (status < 300 || status >= 700) break;
                this.m_State = 0;
                break;
            }
            case 6: {
                if (method.equals("BYE")) break;
                isInvokeServlet = false;
            }
        }
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, resp.toDebugString() + ", state = " + this.stateToString() + ", reference = " + this);
        }
        return isInvokeServlet;
    }

    public void dispatch(SipServletResponseImpl resp, UA uac) {
        block8: {
            int status = resp.getStatus();
            if (status > 100 && status < 200 && resp.getMethod().equals("INVITE") && this.isResentProvisionalResp(resp)) {
                if (m_Log.isLoggable(Level.INFO)) {
                    m_Log.log(Level.INFO, "Response dropped. Same RSeq/CSeq as handled before ");
                }
                return;
            }
            if (this.doResponseUAC(resp, uac)) {
                try {
                    Servlet s = uac.getServlet(resp.getSessionImpl().getHandler());
                    if (s != null) {
                        s.service(null, (ServletResponse)resp);
                    } else if (m_Log.isLoggable(Level.INFO)) {
                        m_Log.log(Level.INFO, "Could not find servlet name: " + resp.getSessionImpl().getHandler() + " in application: " + resp.getSessionImpl().getApplicationSessionImpl().getName());
                    }
                }
                catch (Exception e) {
                    if (!m_Log.isLoggable(Level.INFO)) break block8;
                    m_Log.log(Level.INFO, "Problem in servlet.", e);
                }
            }
        }
    }

    private boolean isResentProvisionalResp(SipServletResponseImpl resp) {
        String CSeq;
        boolean result = false;
        String newRack = "";
        String rseq = resp.getHeader("Rseq");
        if (rseq != null && (CSeq = resp.getHeader("Cseq")) != null && (newRack = rseq + " " + CSeq).equals(this.m_Rack)) {
            result = true;
        }
        return result;
    }

    private synchronized boolean doRequestUAS(SipServletRequestImpl req, UA uas) {
        SipServletResponseImpl resp = null;
        String method = req.getMethod();
        if (req.isInitial() && method.equals("INVITE")) {
            if (!uas.addDialogSession(method, null)) {
                resp = req.createTerminatingResponse(500);
            } else {
                this.m_State = 7;
                this.m_OriginalINVITE = req;
            }
        } else if (method.equals("PRACK") && this.m_PrackReceived) {
            resp = req.createTerminatingResponse(481);
        } else {
            switch (this.m_State) {
                case 9: {
                    SipServletResponseImpl resp200;
                    if (method.equals("BYE")) {
                        this.m_State = 12;
                    }
                    if (method.equals("CANCEL")) {
                        this.m_State = 13;
                        uas.removeDialogSession(method, null);
                        resp200 = req.createTerminatingResponse(200);
                        resp200.setRemote(req.getRemote());
                        SipServletResponseImpl resp487 = this.m_OriginalINVITE.createTerminatingResponse(487);
                        if (!resp487.getSessionImpl().hasNoToTag()) {
                            Header to = resp487.getRawHeader("To");
                            Header toC = resp200.getRawHeader("To");
                            try {
                                Address adr = to.getAddressValue();
                                ((AddressImpl)adr).setReadOnly(false);
                                adr.setParameter("tag", resp487.getSessionImpl().getToTag());
                                ((AddressImpl)adr).setReadOnly(true);
                                Address adrC = toC.getAddressValue();
                                ((AddressImpl)adrC).setReadOnly(false);
                                adrC.setParameter("tag", resp487.getSessionImpl().getToTag());
                                ((AddressImpl)adrC).setReadOnly(true);
                            }
                            catch (ServletParseException e) {
                                throw new IllegalStateException("Parse problem of To Header");
                            }
                        }
                        resp487.popDispatcher().dispatch(resp487);
                        this.m_OriginalINVITE.setSentFinalResponse(resp487.getStatus());
                        resp200.popDispatcher().dispatch(resp200);
                        break;
                    }
                    if (method.equals("UPDATE")) {
                        if (req.getSessionImpl().setUpdateOngoing()) break;
                        resp = req.createTerminatingResponse(500);
                        resp.setHeader("Retry-After", "5");
                        break;
                    }
                    if (method.equals("PRACK") || method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(403);
                    break;
                }
                case 8: {
                    SipServletResponseImpl resp200;
                    if (method.equals("CANCEL")) {
                        this.m_State = 13;
                        uas.removeDialogSession(method, null);
                        resp200 = req.createTerminatingResponse(200);
                        SipServletResponseImpl resp487 = this.m_OriginalINVITE.createTerminatingResponse(487);
                        if (!resp487.getSessionImpl().hasNoToTag()) {
                            Header to = resp487.getRawHeader("To");
                            Header toC = resp200.getRawHeader("To");
                            try {
                                Address adr = to.getAddressValue();
                                ((AddressImpl)adr).setReadOnly(false);
                                adr.setParameter("tag", resp487.getSessionImpl().getToTag());
                                ((AddressImpl)adr).setReadOnly(true);
                                Address adrC = toC.getAddressValue();
                                ((AddressImpl)adrC).setReadOnly(false);
                                adrC.setParameter("tag", resp487.getSessionImpl().getToTag());
                                ((AddressImpl)adrC).setReadOnly(true);
                            }
                            catch (ServletParseException e) {
                                throw new IllegalStateException("Parse problem of To Header");
                            }
                        }
                        resp487.popDispatcher().dispatch(resp487);
                        this.m_OriginalINVITE.setSentFinalResponse(resp487.getStatus());
                        resp200.popDispatcher().dispatch(resp200);
                        break;
                    }
                    if (method.equals("UPDATE")) {
                        if (req.getSessionImpl().setUpdateOngoing()) break;
                        resp = req.createTerminatingResponse(500);
                        resp.setHeader("Retry-After", "5");
                        break;
                    }
                    if (method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(403);
                    break;
                }
                case 10: {
                    if (method.equals("ACK")) {
                        if (this.m_TimerShort != null) {
                            this.m_TimerShort.cancel();
                            this.m_TimerShort = null;
                        }
                        if (this.m_TimerLong != null) {
                            this.m_TimerLong.cancel();
                            this.m_TimerLong = null;
                        }
                        this.m_State = 0;
                        break;
                    }
                    if (method.equals("UPDATE")) {
                        if (req.getSessionImpl().setUpdateOngoing()) break;
                        resp = req.createTerminatingResponse(500);
                        resp.setHeader("Retry-After", "5");
                        break;
                    }
                    if (method.equals("PRACK")) break;
                    resp = req.createTerminatingResponse(403);
                    break;
                }
                case 13: {
                    if (method.equals("CANCEL")) {
                        resp = req.createTerminatingResponse(403);
                        break;
                    }
                    if (method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(487);
                    break;
                }
                case 0: {
                    String rackPrack;
                    if (method.equals("BYE")) {
                        this.m_State = 12;
                        break;
                    }
                    if (method.equals("INVITE")) {
                        this.m_State = 15;
                        break;
                    }
                    if (method.equals("PRACK")) {
                        rackPrack = req.getHeader("Rack");
                        if (rackPrack != null && this.m_Rack != null && this.m_Rack.equalsIgnoreCase(rackPrack)) break;
                        resp = req.createTerminatingResponse(481);
                        break;
                    }
                    if (method.equals("UPDATE")) {
                        if (req.getSessionImpl().setUpdateOngoing()) break;
                        resp = req.createTerminatingResponse(500);
                        resp.setHeader("Retry-After", "5");
                        break;
                    }
                    if (method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(403);
                    break;
                }
                case 14: {
                    if (method.equals("BYE")) {
                        this.m_State = 12;
                        break;
                    }
                    if (method.equals("INVITE")) {
                        this.m_State = 0;
                        resp = req.createTerminatingResponse(491);
                        break;
                    }
                    if (method.equals("PRACK") || method.equals("UPDATE") || method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(403);
                    break;
                }
                case 15: {
                    if (method.equals("BYE")) {
                        this.m_State = 12;
                        break;
                    }
                    if (method.equals("INVITE")) {
                        resp = req.createTerminatingResponse(500);
                        break;
                    }
                    if (method.equals("UPDATE")) {
                        if (req.getSessionImpl().setUpdateOngoing()) break;
                        resp = req.createTerminatingResponse(500);
                        resp.setHeader("Retry-After", "5");
                        break;
                    }
                    if (method.equals("PRACK") || method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(403);
                    break;
                }
                case 16: {
                    String rackPrack;
                    if (method.equals("PRACK")) {
                        rackPrack = req.getHeader("Rack");
                        if (rackPrack != null && this.m_Rack != null && this.m_Rack.equalsIgnoreCase(rackPrack)) {
                            if (this.m_TimerShortProvRsp != null) {
                                this.m_TimerShortProvRsp.cancel();
                                this.m_TimerShortProvRsp = null;
                            }
                            if (this.m_TimerLongProvRsp != null) {
                                this.m_TimerLongProvRsp.cancel();
                                this.m_TimerLongProvRsp = null;
                            }
                            this.m_PrackReceived = true;
                            break;
                        }
                        resp = req.createTerminatingResponse(481);
                        break;
                    }
                    if (!method.equals("UPDATE") || req.getSessionImpl().setUpdateOngoing()) break;
                    resp = req.createTerminatingResponse(500);
                    resp.setHeader("Retry-After", "5");
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: {
                    if (method.equals("UPDATE")) {
                        if (req.getSessionImpl().setUpdateOngoing()) break;
                        resp = req.createTerminatingResponse(500);
                        resp.setHeader("Retry-After", "5");
                        break;
                    }
                    if (method.equals("CANCEL")) {
                        resp = req.createTerminatingResponse(200);
                        break;
                    }
                    if (method.equals("ACK")) break;
                    resp = req.createTerminatingResponse(403);
                }
            }
        }
        boolean isInvokeServlet = true;
        if (resp != null) {
            resp.popDispatcher().dispatch(resp);
            isInvokeServlet = false;
        }
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, req.toDebugString() + ", state = " + this.stateToString() + ", reference = " + this);
        }
        return isInvokeServlet;
    }

    public void dispatch(SipServletRequestImpl req, UA uas) {
        if (this.doRequestUAS(req, uas)) {
            if (uas.getSipSession() != null) {
                req.setSession(uas.getSipSession());
            }
            try {
                Servlet s = uas.getServlet(req.getSessionImpl().getHandler());
                if (s != null) {
                    s.service((ServletRequest)req, null);
                } else if (m_Log.isLoggable(Level.INFO)) {
                    m_Log.log(Level.INFO, "Could not find servlet name: " + req.getSessionImpl().getHandler() + " in application: " + req.getSessionImpl().getApplicationSessionImpl().getName());
                }
            }
            catch (Exception e) {
                SipServletResponseImpl resp;
                if (m_Log.isLoggable(Level.FINE)) {
                    m_Log.log(Level.FINE, "Problem in servlet ", e);
                }
                if ((resp = req.createTerminatingResponse(500)) == null) {
                    return;
                }
                resp.popDispatcher().dispatch(resp);
            }
        }
    }

    private void updateToTag(SipServletResponseImpl resp, UA uas) {
        if (!resp.hasToTag()) {
            String toTag;
            SipSessionDialogImpl sipSessionDialogImpl = (SipSessionDialogImpl)uas.getSipSession();
            String string = toTag = sipSessionDialogImpl != null ? sipSessionDialogImpl.getToTag() : null;
            if (toTag == null) {
                resp.createTag("To");
                this.setDerivedOrOriginalSession(resp, uas);
            } else {
                Header to = resp.getRawHeader("To");
                try {
                    Address adr = to.getAddressValue();
                    ((AddressImpl)adr).setReadOnly(false);
                    adr.setParameter("tag", toTag);
                    ((AddressImpl)adr).setReadOnly(true);
                }
                catch (ServletParseException e) {
                    throw new IllegalStateException("Parse problem of To Header");
                }
            }
        }
    }

    private synchronized void doResponseUAS(SipServletResponseImpl resp, UA uas) {
        int status = resp.getStatus();
        String method = resp.getMethod();
        if (status != 100) {
            this.updateToTag(resp, uas);
        }
        switch (this.m_State) {
            case 7: 
            case 8: {
                if (method.equals("INVITE")) {
                    if (status == 100) {
                        this.m_OriginalINVITE = resp.getRequestImpl();
                        this.m_State = 8;
                        break;
                    }
                    if (status >= 200 && status < 300) {
                        SipSessionDialogImpl s = (SipSessionDialogImpl)resp.getSessionImpl();
                        s.swapLocalRemote();
                        this.saveContactRouteSetRemoteTarget(resp, uas);
                        this.startTimers(resp);
                        this.m_State = 10;
                        this.m_OriginalINVITE = null;
                        break;
                    }
                    if (status <= 100 || status >= 200) break;
                    this.saveContactRouteSetRemoteTarget(resp, uas);
                    if (this.m_OriginalINVITE == null) {
                        this.m_OriginalINVITE = resp.getRequestImpl();
                    }
                    if (resp.isReliableProvisionalResponse()) {
                        this.startTimers(resp);
                        this.storeRAck(resp, uas);
                        this.m_State = 16;
                        this.m_PrackReceived = false;
                        break;
                    }
                    this.m_State = 9;
                    break;
                }
                if (!method.equals("UPDATE")) break;
                resp.getSessionImpl().resetUpdateOngoing();
                break;
            }
            case 9: {
                if (method.equals("INVITE")) {
                    if (status > 100 && status < 200 && resp.isReliableProvisionalResponse()) {
                        this.startTimers(resp);
                        this.storeRAck(resp, uas);
                        this.m_State = 16;
                        this.m_PrackReceived = false;
                        break;
                    }
                    if (status >= 200 && status < 300) {
                        this.saveContactRouteSetRemoteTarget(resp, uas);
                        this.startTimers(resp);
                        this.m_State = 10;
                        this.m_OriginalINVITE = null;
                        break;
                    }
                    if (status < 300 || status >= 700) break;
                    uas.removeDialogSession(method, null);
                    this.m_State = 13;
                    this.m_OriginalINVITE = null;
                    break;
                }
                if (!method.equals("UPDATE")) break;
                resp.getSessionImpl().resetUpdateOngoing();
                break;
            }
            case 12: {
                if (!method.equals("BYE") || status < 200 || status >= 300) break;
                uas.removeDialogSession(method, null);
                this.m_State = 13;
                break;
            }
            case 10: {
                if (!method.equals("UPDATE")) break;
                resp.getSessionImpl().resetUpdateOngoing();
                break;
            }
            case 0: {
                if (!method.equals("UPDATE")) break;
                resp.getSessionImpl().resetUpdateOngoing();
                break;
            }
            case 15: {
                if (method.equals("INVITE")) {
                    if (status > 100 && status < 200 && resp.isReliableProvisionalResponse()) {
                        this.startTimers(resp);
                        this.storeRAck(resp, uas);
                        this.m_State = 16;
                        this.m_PrackReceived = false;
                    }
                    if (status >= 200 && status < 300) {
                        this.m_State = 10;
                        break;
                    }
                    if (status < 300 || status >= 700) break;
                    this.m_State = 0;
                    break;
                }
                if (!method.equals("UPDATE")) break;
                resp.getSessionImpl().resetUpdateOngoing();
                break;
            }
            case 16: {
                if (method.equals("PRACK") && this.m_PrackReceived) {
                    if (status != 200) break;
                    resp.getSessionImpl().reset1xxReliable();
                    if (this.m_OriginalINVITE != null && this.m_OriginalINVITE.isInitial()) {
                        this.m_State = 9;
                        break;
                    }
                    this.m_State = 15;
                    break;
                }
                if (method.equals("INVITE")) {
                    if (status > 100 && status < 200 && resp.isReliableProvisionalResponse()) {
                        m_Log.log(Level.WARNING, resp.toDebugString() + ", state = " + this.stateToString() + ", only one 1XX reliable at a time is permit");
                        break;
                    }
                    if (status >= 200 && status < 300) {
                        if (this.m_OriginalINVITE != null && this.m_OriginalINVITE.isInitial()) {
                            this.saveContactRouteSetRemoteTarget(resp, uas);
                            this.m_OriginalINVITE = null;
                        }
                        resp.getSessionImpl().reset1xxReliable();
                        this.m_State = 10;
                        break;
                    }
                    if (status < 300 || status >= 700) break;
                    uas.removeDialogSession(method, null);
                    this.m_State = 13;
                    this.m_OriginalINVITE = null;
                    break;
                }
                if (!method.equals("UPDATE")) break;
                resp.getSessionImpl().resetUpdateOngoing();
            }
        }
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, resp.toDebugString() + ", state = " + this.stateToString() + ", reference = " + this);
        }
    }

    private void saveContactRouteSetRemoteTarget(SipServletResponseImpl resp, UA uas) {
        try {
            uas.saveContactRouteSetRemoteTarget(resp);
        }
        catch (ServletParseException e) {
            throw new IllegalStateException("Parse problem of Contact or Record-Route");
        }
    }

    public void send(SipServletResponseImpl resp, UA uas) throws IllegalStateException {
        this.doResponseUAS(resp, uas);
        SipServletResponseImpl clone = (SipServletResponseImpl)resp.clone();
        SipServletRequestImpl req = resp.getRequestImpl().getTransactionRequest();
        if (req != null) {
            clone.setRequest(req);
            clone.setSession(req.getSessionImpl());
        }
        super.send(clone, uas);
    }

    private void sendRetransmission(SipServletResponseImpl r) {
        SipServletResponseImpl resp = (SipServletResponseImpl)r.clone();
        Dispatcher d = resp.popDispatcher();
        if (d != null) {
            d.dispatch(resp);
        }
    }

    private void startTimers(SipServletResponseImpl resp) {
        if (resp.isReliableProvisionalResponse()) {
            if (this.m_RetransmitReliableResponse == null) {
                this.m_RetransmitReliableResponse = resp;
                this.m_TimerLongProvRsp = TimerServiceImpl.getInstance().createTimer(this, 64L * T1, false, (Serializable)((Object)DialogTimer.TimerLongProvResp));
                this.m_TimerShortProvRsp = TimerServiceImpl.getInstance().createTimer(this, T1, false, (Serializable)((Object)DialogTimer.TimerShortProvRsp));
            }
        } else if (this.m_RetransmitResponse == null) {
            this.m_RetransmitResponse = resp;
            this.m_TimerLong = TimerServiceImpl.getInstance().createTimer(this, 64L * T1, false, (Serializable)((Object)DialogTimer.TimerLong));
            this.m_TimerShort = TimerServiceImpl.getInstance().createTimer(this, T1, false, (Serializable)((Object)DialogTimer.TimerShort));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(ServletTimer timer) {
        DialogTimer dt = (DialogTimer)((Object)timer.getInfo());
        switch (dt) {
            case TimerShort: {
                if (this.m_State != 10) break;
                long delay = ((ServletTimerImpl)timer).getDelay();
                delay = delay * 2L <= T2 ? delay * 2L : T2;
                this.m_TimerShort = TimerServiceImpl.getInstance().createTimer(this, delay, false, (Serializable)((Object)DialogTimer.TimerShort));
                this.sendRetransmission(this.m_RetransmitResponse);
                break;
            }
            case TimerLong: {
                SipServletRequest bye = null;
                INVITESession iNVITESession = this;
                synchronized (iNVITESession) {
                    if (this.m_State == 10) {
                        if (this.m_TimerShort != null) {
                            this.m_TimerShort.cancel();
                            this.m_TimerShort = null;
                        }
                        if (m_Log.isLoggable(Level.FINE)) {
                            m_Log.log(Level.FINE, "Timer fired after 64*T1s - end dialog");
                        }
                        bye = this.m_RetransmitResponse.getSession().createRequest("BYE");
                        this.m_State = 11;
                    }
                }
                try {
                    if (bye == null) break;
                    bye.send();
                }
                catch (IOException e) {
                    m_Log.log(Level.WARNING, "Problem sending BYE", e);
                }
                break;
            }
            case TimerShortProvRsp: {
                if (this.m_State != 16) break;
                long delay = ((ServletTimerImpl)timer).getDelay();
                this.m_TimerShortProvRsp = TimerServiceImpl.getInstance().createTimer(this, delay *= 2L, false, (Serializable)((Object)DialogTimer.TimerShortProvRsp));
                this.sendRetransmission(this.m_RetransmitReliableResponse);
                break;
            }
            case TimerLongProvResp: {
                INVITESession iNVITESession = this;
                synchronized (iNVITESession) {
                    if (this.m_State == 16) {
                        if (this.m_TimerShortProvRsp != null) {
                            this.m_TimerShortProvRsp.cancel();
                            this.m_TimerShortProvRsp = null;
                        }
                        if (m_Log.isLoggable(Level.FINE)) {
                            m_Log.log(Level.FINE, "Timer fired after 64*T1s - end dialog");
                        }
                        this.m_State = this.m_OriginalINVITE != null && this.m_OriginalINVITE.isInitial() ? 9 : 15;
                        this.m_RetransmitReliableResponse.getSessionImpl().reset1xxReliable();
                        ArrayList<SipErrorListener> sipErrorList = this.m_RetransmitReliableResponse.getSessionImpl().getApplicationSessionImpl().getSipApplicationListeners().getSipErrorListeners();
                        for (SipErrorListener listener : sipErrorList) {
                            listener.noPrackReceived(new SipErrorEvent((SipServletRequest)this.m_OriginalINVITE, (SipServletResponse)this.m_RetransmitReliableResponse));
                        }
                    }
                    break;
                }
            }
            default: {
                m_Log.log(Level.FINE, "IllegalTimer in dialog = " + (Object)((Object)dt));
            }
        }
    }

    public synchronized boolean isDeletable() {
        return this.m_State == 6 || this.m_State == 13;
    }

    private String stateToString() {
        if (this.m_State >= 0 && this.m_State < m_StateStrings.size()) {
            return m_StateStrings.get(this.m_State);
        }
        return "OUT_OF_RANGE_STATE";
    }

    static {
        m_StateStrings.add(0, "RUNNING");
        m_StateStrings.add(1, "INITIAL_UAC");
        m_StateStrings.add(2, "ONLY_CANCEL_ALLOWED_UAC");
        m_StateStrings.add(3, "EARLY_UAC");
        m_StateStrings.add(4, "CONFIRMED_UAC");
        m_StateStrings.add(5, "CLOSING_UAC");
        m_StateStrings.add(6, "TERMINATED_UAC");
        m_StateStrings.add(7, "INITIAL_UAS");
        m_StateStrings.add(8, "ONLY_CANCEL_ALLOWED_UAS");
        m_StateStrings.add(9, "EARLY_UAS");
        m_StateStrings.add(10, "CONFIRMED_UAS");
        m_StateStrings.add(11, "TIMEOUT_UAS");
        m_StateStrings.add(12, "CLOSING_UAS");
        m_StateStrings.add(13, "TERMINATED_UAS");
        m_StateStrings.add(14, "RE_INVITE_UAC");
        m_StateStrings.add(15, "RE_INVITE_UAS");
        m_StateStrings.add(16, "PRACKED_UAS");
        T1 = 500L;
        T2 = 4000L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DialogTimer {
        TimerShort,
        TimerLong,
        TimerShortProvRsp,
        TimerLongProvResp;

    }
}

