/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipURIImpl;
import com.ericsson.ssa.sip.URIImpl;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.URI;

public class LocalRouteManager
implements Layer {
    private static final String LOCALHOST = "localhost";
    private static final String LOCALIP = "127.0.0.1";
    private static final LocalRouteManager singletonInstance = new LocalRouteManager();
    private Logger m_logger = Logger.getLogger("SipContainer");
    private Layer _nextLayer = null;

    private LocalRouteManager() {
    }

    public static LocalRouteManager getInstance() {
        return singletonInstance;
    }

    public void next(SipServletRequestImpl req) {
        if (req.isInitial()) {
            req.pushApplicationDispatcher(this);
        }
        LayerHelper.next(req, (Layer)this, this._nextLayer);
    }

    public void next(SipServletResponseImpl resp) {
        LayerHelper.next(resp, (Layer)this, this._nextLayer);
    }

    public void registerNext(Layer layer) {
        this._nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        if (req.isInitial() && this.isLocalRoute(req)) {
            if (this.m_logger.isLoggable(Level.FINE)) {
                this.m_logger.log(Level.FINE, "Request should stay in container.");
            }
            if (this.popRouteHeader(req)) {
                req.pushApplicationDispatcher(this);
                LayerHelper.next(req, (Layer)this, this._nextLayer);
                return;
            }
        }
        req.popDispatcher().dispatch(req);
    }

    public void dispatch(SipServletResponseImpl resp) {
        resp.popDispatcher().dispatch(resp);
    }

    private boolean isLocalRoute(SipServletRequestImpl req) {
        boolean local = false;
        try {
            SipURIImpl sipUri;
            String host;
            URI uri;
            Address route = req.getAddressHeader("Route");
            if (route != null && !route.isWildcard() && (uri = route.getURI()).isSipURI() && ((host = (sipUri = (SipURIImpl)uri).getHost()).equalsIgnoreCase(LOCALHOST) || host.equals(LOCALIP))) {
                local = true;
            }
        }
        catch (ServletParseException servletParseException) {
            // empty catch block
        }
        return local;
    }

    private boolean popRouteHeader(SipServletRequestImpl req) {
        boolean status = false;
        Header r = req.getRawHeader("Route");
        if (r != null) {
            r.setReadOnly(false);
            ListIterator<Address> it_a = null;
            try {
                it_a = r.getAddressValues();
                Address a = it_a.next();
                URIImpl uri = (URIImpl)a.getURI();
                if (uri.getLrParam()) {
                    if (this.m_logger.isLoggable(Level.FINE)) {
                        this.m_logger.log(Level.FINE, "Removing route = " + a);
                    }
                    it_a.remove();
                    req.setPoppedRoute(a);
                    req.setRecordRouteURI(uri);
                    status = true;
                }
            }
            catch (ServletParseException e) {
                // empty catch block
            }
            r.setReadOnly(true);
        }
        return status;
    }
}

