/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.Ascii7String;
import com.ericsson.ssa.sip.SipURIDecoder;
import com.ericsson.ssa.sip.SipURIEncoder;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.sip.ServletParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterByteMap {
    private static SipURIDecoder decoder = new SipURIDecoder();
    private static SipURIEncoder encoder = new SipURIEncoder();
    public static int BUFFER_ALIGNMENT_SIZE = 8;
    public static int BUFFER_EXTEND_SIZE = 2 * BUFFER_ALIGNMENT_SIZE;
    private byte[] buffer = null;
    private int size = 0;
    private byte separator = (byte)59;

    private ParameterByteMap() {
    }

    public ParameterByteMap(char separator) {
        this.separator = (byte)separator;
    }

    public ParameterByteMap(byte[] array, int offset, int length, char separator) throws ServletParseException {
        this(separator);
        if (array != null) {
            this.trim(array, offset, length);
            if (separator == '&') {
                array[offset] = 38;
            }
            this.buffer = ParameterByteMap.increaseBufferIfNeeded(array, offset, this.size, 0, true);
        }
    }

    public ParameterByteMap(byte[] array, char separator) throws ServletParseException {
        this(array, 0, array == null ? 0 : array.length, separator);
    }

    private void trim(byte[] array, int offset, int length) throws ServletParseException {
        if ((length += offset) > array.length) {
            throw new ServletParseException("Illegal length");
        }
        byte whitespace = 32;
        byte quote = 34;
        int slowPos = offset;
        for (int fastPos = offset; fastPos < length; ++fastPos) {
            while (fastPos < length - 1 && array[fastPos] == whitespace) {
                ++fastPos;
            }
            if (array[fastPos] == quote) {
                if (slowPos < fastPos) {
                    array[slowPos] = array[fastPos];
                }
                ++slowPos;
                ++fastPos;
                while (fastPos < length - 1 && array[fastPos] != quote) {
                    if (slowPos < fastPos) {
                        array[slowPos] = array[fastPos];
                    }
                    ++slowPos;
                    ++fastPos;
                }
            }
            if (slowPos < fastPos) {
                array[slowPos] = array[fastPos];
            }
            ++slowPos;
        }
        this.size = slowPos - offset;
    }

    private int size() {
        return this.size;
    }

    private static int adjustedLength(int length, boolean initial) {
        int rest;
        if (!initial) {
            length += BUFFER_EXTEND_SIZE;
        }
        return (rest = length % BUFFER_ALIGNMENT_SIZE) == 0 ? length : length + BUFFER_ALIGNMENT_SIZE - rest;
    }

    private static byte[] increaseBufferIfNeeded(byte[] src, int size, int requestedExtraBytes) {
        return ParameterByteMap.increaseBufferIfNeeded(src, 0, size, requestedExtraBytes, false);
    }

    private static byte[] increaseBufferIfNeeded(byte[] src, int offset, int size, int requestedExtraBytes, boolean forceCreation) {
        if (src != null && !forceCreation && size + requestedExtraBytes <= src.length) {
            return src;
        }
        int capacity = ParameterByteMap.adjustedLength(size + requestedExtraBytes, true);
        byte[] newBuffer = new byte[capacity];
        if (src != null) {
            System.arraycopy(src, offset, newBuffer, 0, size);
        }
        return newBuffer;
    }

    private static byte[] escape(String str) {
        return encoder.encodeParameter(str).getBytes();
    }

    private static String unescape(String str) {
        try {
            return decoder.decode(str);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String getValue(byte[] key) throws UnsupportedEncodingException {
        int pos = this.indexOf(key);
        while (pos != -1 && this.buffer[pos - 1] != this.separator) {
            pos = this.indexOf(key, pos + 1);
        }
        if (pos >= 0) {
            if (pos + key.length == this.size()) {
                return "";
            }
            if (this.buffer[pos + key.length] == this.separator) {
                return "";
            }
            while (pos < this.size() && this.buffer[pos] != this.separator) {
                if (this.buffer[++pos] != 61) continue;
                int mark = ++pos;
                while (pos < this.size() && this.buffer[pos] != this.separator) {
                    ++pos;
                }
                return new String(this.buffer, mark, pos - mark, "UTF-8");
            }
        }
        return null;
    }

    private int indexOf(byte[] token) {
        return this.indexOf(token, 0);
    }

    private int indexOf(byte[] token, int fromIndex) {
        return ParameterByteMap.indexOf(this.buffer, 0, this.size(), token, 0, token.length, fromIndex);
    }

    private static int indexOf(byte[] source, int sourceOffset, int sourceCount, byte[] target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = target[targetOffset];
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    private static int append(byte[] src, byte[] dest, int destPos) {
        System.arraycopy(src, 0, dest, destPos, src.length);
        return destPos + src.length;
    }

    private byte[] append(byte[] src, int length, byte[] key, byte[] value, byte separator) {
        int appendLength = 0;
        if (key != null) {
            appendLength += key.length + 1;
        }
        if (value != null && value.length > 0) {
            appendLength += value.length + 1;
        }
        byte[] newBuffer = ParameterByteMap.increaseBufferIfNeeded(src, length, appendLength);
        int newPos = length;
        if (key != null) {
            newBuffer[newPos] = separator;
            ++newPos;
            newPos = ParameterByteMap.append(key, newBuffer, newPos);
        }
        if (value != null && value.length > 0) {
            newBuffer[newPos] = 61;
            ++newPos;
            newPos = ParameterByteMap.append(value, newBuffer, newPos);
        }
        this.size = newPos;
        return newBuffer;
    }

    private byte[] replace(byte[] src, int length, int start, int end, byte[] value) {
        int equalLength = 1;
        if (value.length == 0) {
            equalLength = 0;
        }
        int extendLength = value.length + equalLength - (end - start);
        byte[] newBuffer = ParameterByteMap.increaseBufferIfNeeded(src, length, extendLength);
        this.size = length + extendLength;
        if (src != newBuffer) {
            System.arraycopy(src, 0, newBuffer, 0, start);
        }
        if (length - end > 0) {
            int destPos = value.length == 0 ? start : start + 1 + value.length;
            System.arraycopy(src, end, newBuffer, destPos, length - end);
        }
        if (value.length > 0) {
            newBuffer[start] = 61;
            System.arraycopy(value, 0, newBuffer, start + 1, value.length);
        }
        return newBuffer;
    }

    private byte[] remove(byte[] src, int length, int start, int end) {
        this.size = length - (end - start);
        if (length - end > 0) {
            System.arraycopy(src, end, src, start, length - end);
        }
        return src;
    }

    private void removeKey(byte[] key) {
        int pos = this.indexOf(key);
        while (pos != -1 && this.buffer[pos - 1] != this.separator) {
            pos = this.indexOf(key, pos + 1);
        }
        if (pos >= 0) {
            if (pos + key.length == this.size()) {
                this.buffer = this.remove(this.buffer, this.size(), pos - 1, this.size());
            } else if (this.buffer[pos + key.length] == this.separator) {
                this.buffer = this.remove(this.buffer, this.size(), pos - 1, pos + key.length);
            } else {
                int mark = pos - 1;
                while (pos < this.size() && this.buffer[pos] != this.separator) {
                    ++pos;
                }
                this.buffer = this.remove(this.buffer, this.size(), mark, pos);
            }
        }
    }

    private void putValue(byte[] key, byte[] value) {
        int pos = this.indexOf(key);
        while (pos != -1 && this.buffer[pos - 1] != this.separator) {
            pos = this.indexOf(key, pos + 1);
        }
        if (pos == -1) {
            this.buffer = this.append(this.buffer, this.size(), key, value, this.separator);
        } else if (value != null) {
            while (pos < this.size() - 1 && this.buffer[pos] != this.separator) {
                if (this.buffer[pos] == 61) {
                    int mark = pos++;
                    while (pos < this.size() && this.buffer[pos] != this.separator) {
                        ++pos;
                    }
                    this.buffer = this.replace(this.buffer, this.size(), mark, pos, value);
                    return;
                }
                ++pos;
            }
            this.buffer = this.buffer[pos] == this.separator ? this.replace(this.buffer, this.size(), pos, pos, value) : this.append(this.buffer, this.size(), null, value, this.separator);
        }
    }

    public Object clone() {
        ParameterByteMap newMap = new ParameterByteMap();
        if (this.buffer != null) {
            byte[] newBuffer = new byte[this.buffer.length];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            newMap.buffer = newBuffer;
            newMap.size = this.size;
        }
        newMap.separator = this.separator;
        return newMap;
    }

    private boolean isQuotedString(String str) {
        return str != null && !str.equals("") && str.charAt(0) == '\"' && str.charAt(str.length() - 1) == '\"';
    }

    public String get(String key) {
        String value;
        byte[] escapedKey = Ascii7String.getBytes(key);
        try {
            value = this.getValue(escapedKey);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        String unescapedValue = this.isQuotedString(value) ? value : ParameterByteMap.unescape(value);
        return unescapedValue;
    }

    public void put(String key, String value) {
        byte[] encodedKey = Ascii7String.getBytes(key);
        try {
            byte[] encodedValue = this.isQuotedString(value) ? value.getBytes("UTF-8") : ParameterByteMap.escape(value);
            this.putValue(encodedKey, encodedValue);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void remove(String key) {
        byte[] encodedKey = Ascii7String.getBytes(key);
        this.removeKey(encodedKey);
    }

    public Iterator<String> getKeys() {
        return this.keyList().iterator();
    }

    private List<String> keyList() {
        LinkedList<String> l = new LinkedList<String>();
        int pos = 0;
        int mark = 0;
        while (pos < this.size()) {
            if (this.buffer[pos] == this.separator) {
                mark = ++pos;
                while (pos < this.size() && this.buffer[pos] != this.separator && this.buffer[pos] != 61) {
                    ++pos;
                }
                l.add(new String(this.buffer, mark, pos - mark));
                continue;
            }
            ++pos;
        }
        return l;
    }

    public Set<Map.Entry<String, String>> entrySet() {
        HashMap<String, String> entryMap = new HashMap<String, String>();
        for (String s : this.keyList()) {
            entryMap.put(s, this.get(s));
        }
        return entryMap.entrySet();
    }

    public byte[] toArray() {
        if (this.buffer == null) {
            return null;
        }
        byte[] newArray = new byte[this.size];
        System.arraycopy(this.buffer, 0, newArray, 0, this.size);
        if (this.separator == 38) {
            newArray[0] = 63;
        }
        return newArray;
    }

    public String toString() {
        if (this.buffer == null) {
            return "";
        }
        try {
            String str = null;
            if (this.separator == 38) {
                this.buffer[0] = 63;
                str = new String(this.buffer, 0, this.size(), "UTF-8");
                this.buffer[0] = 38;
            } else {
                str = new String(this.buffer, 0, this.size(), "UTF-8");
            }
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isHeaderOrSpecialParameter(String parameter) {
        return this.separator == 38 || this.isSpecialParameter(parameter);
    }

    private boolean isSpecialParameter(String parameter) {
        return this.separator == 38 || this.separator == 59 && (parameter.equalsIgnoreCase("user") || parameter.equalsIgnoreCase("method") || parameter.equalsIgnoreCase("ttl") || parameter.equalsIgnoreCase("transport") || parameter.equalsIgnoreCase("maddr"));
    }

    public boolean isOnlySpecialParameters() {
        for (String key : this.keyList()) {
            if (this.isSpecialParameter(key)) continue;
            return false;
        }
        return true;
    }

    private String findAndRemoveKey(String key, List<String> remoteKeys) {
        int i = -1;
        for (String remotekey : remoteKeys) {
            ++i;
            if (!key.equalsIgnoreCase(remotekey)) continue;
            return remoteKeys.remove(i);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ParameterByteMap) {
            ParameterByteMap remote = (ParameterByteMap)obj;
            List<String> keys = this.keyList();
            List<String> remoteKeys = remote.keyList();
            if (this.separator == 38 && keys.size() != remoteKeys.size()) {
                return false;
            }
            String value = null;
            String remoteValue = null;
            String remoteKey = null;
            for (String key : keys) {
                remoteKey = this.findAndRemoveKey(key, remoteKeys);
                if (remoteKey != null) {
                    value = this.get(key);
                    remoteValue = remote.get(remoteKey);
                    if (value != null && remoteValue == null || value == null && remoteValue != null) {
                        return false;
                    }
                    if (value == null || remoteValue == null || value.equalsIgnoreCase(remoteValue)) continue;
                    return false;
                }
                if (!this.isHeaderOrSpecialParameter(key)) continue;
                return false;
            }
            for (String leftKey : remoteKeys) {
                if (!this.isHeaderOrSpecialParameter(leftKey)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

