/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.ParameterByteMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterableImpl
implements Parameterable {
    private ParameterByteMap parameters;
    private String value;

    public void setParameterByteMap(byte[] array, int offset, int length, char separator) throws ServletParseException {
        this.parameters = new ParameterByteMap(array, offset, length, separator);
    }

    public Object clone() {
        ParameterableImpl result = null;
        try {
            result = (ParameterableImpl)super.clone();
        }
        catch (CloneNotSupportedException cex) {
            cex.printStackTrace();
        }
        if (this.value != null) {
            result.value = this.value;
        }
        if (this.parameters != null) {
            result.parameters = (ParameterByteMap)this.parameters.clone();
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParameterableImpl)) {
            return false;
        }
        ParameterableImpl p = (ParameterableImpl)o;
        if (this.value != p.value) {
            return false;
        }
        return this.parameters.equals(p.parameters);
    }

    public String getParameter(String key) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(key);
    }

    public Iterator<String> getParameterNames() {
        if (this.parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.parameters.getKeys();
    }

    public Set<Map.Entry<String, String>> getParameters() {
        if (this.parameters != null) {
            return this.parameters.entrySet();
        }
        return Collections.EMPTY_SET;
    }

    public String getValue() {
        return this.value;
    }

    public void removeParameter(String name) {
        if (this.parameters != null) {
            this.parameters.remove(name);
        }
    }

    public void setParameter(String name, String value) {
        if (this.parameters == null) {
            this.parameters = new ParameterByteMap(';');
        }
        this.parameters.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.value != null) {
            sb.append(this.value);
        }
        if (this.parameters != null) {
            sb.append(this.parameters.toString());
        }
        return sb.toString();
    }

    public void setValue(String value) {
        this.value = value;
    }

    static ParameterableImpl parse(String str) {
        ParameterableImpl result = new ParameterableImpl();
        StringTokenizer stokener = new StringTokenizer(str, ";");
        if (stokener.countTokens() > 0) {
            result.setValue(stokener.nextToken());
        }
        while (stokener.hasMoreTokens()) {
            StringTokenizer paramTokens = new StringTokenizer(stokener.nextToken(), "=");
            String paramName = null;
            String paramValue = null;
            if (paramTokens.hasMoreTokens()) {
                paramName = paramTokens.nextToken();
            }
            if (paramTokens.hasMoreTokens()) {
                paramValue = paramTokens.nextToken();
            }
            result.setParameter(paramName, paramValue);
        }
        return result;
    }
}

