/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipApplicationSessionStore;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.SipSessionManagerBase;
import com.ericsson.ssa.sip.SipSessionStore;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.timer.ServletTimerStore;
import java.io.IOException;

public abstract class PersistentSipSessionManagerBase
extends SipSessionManagerBase {
    private SipSessionStore sipSessionStore;
    private SipApplicationSessionStore sipApplicationSessionStore;
    private ServletTimerStore servletTimerStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SipSessionDialogImpl findSipSession(String id) {
        SipSessionDialogImpl sipSession = super.findSipSession(id);
        if (sipSession != null) {
            return sipSession;
        }
        ClassLoader webappCL = null;
        ClassLoader curCL = null;
        if (this.getContext() != null && this.getContext().getLoader() != null) {
            webappCL = this.getContext().getLoader().getClassLoader();
            curCL = Thread.currentThread().getContextClassLoader();
        }
        if (webappCL != null && curCL != webappCL) {
            try {
                Thread.currentThread().setContextClassLoader(webappCL);
                sipSession = this.swapInSipSession(id);
                Thread.currentThread().setContextClassLoader(curCL);
            }
            catch (IOException ioe) {
                Thread.currentThread().setContextClassLoader(curCL);
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(curCL);
                    throw throwable;
                }
            }
        } else {
            try {
                sipSession = this.swapInSipSession(id);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return sipSession;
    }

    public void removeSession(SipSessionDialogImpl sipSession) {
        super.removeSession(sipSession);
        if (this.sipSessionStore != null) {
            try {
                this.sipSessionStore.remove(sipSession.getId());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeSession(SipSessionDialogImpl sipSession) throws IOException {
        if (this.sipSessionStore != null) {
            this.sipSessionStore.save(sipSession);
        }
    }

    protected SipSessionDialogImpl swapInSipSession(String id) throws IOException {
        if (this.sipSessionStore == null) {
            return null;
        }
        SipSessionDialogImpl sipSession = this.sipSessionStore.load(id);
        if (sipSession == null) {
            return null;
        }
        this.addSession(sipSession);
        return sipSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SipApplicationSessionImpl findApplicationSession(String id) {
        SipApplicationSessionImpl sas = super.findApplicationSession(id);
        if (sas != null) {
            return sas;
        }
        ClassLoader webappCL = null;
        ClassLoader curCL = null;
        if (this.getContext() != null && this.getContext().getLoader() != null) {
            webappCL = this.getContext().getLoader().getClassLoader();
            curCL = Thread.currentThread().getContextClassLoader();
        }
        if (webappCL != null && curCL != webappCL) {
            try {
                Thread.currentThread().setContextClassLoader(webappCL);
                sas = this.swapInApplicationSession(id);
                Thread.currentThread().setContextClassLoader(curCL);
            }
            catch (IOException ioe) {
                Thread.currentThread().setContextClassLoader(curCL);
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(curCL);
                    throw throwable;
                }
            }
        } else {
            try {
                sas = this.swapInApplicationSession(id);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return sas;
    }

    public void removeSession(SipApplicationSessionImpl sas) {
        super.removeSession(sas);
        if (this.sipApplicationSessionStore != null) {
            try {
                this.sipApplicationSessionStore.remove(sas.getId());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeSession(SipApplicationSessionImpl sas) throws IOException {
        if (this.sipApplicationSessionStore != null) {
            this.sipApplicationSessionStore.save(sas);
        }
    }

    protected SipApplicationSessionImpl swapInApplicationSession(String id) throws IOException {
        if (this.sipApplicationSessionStore == null) {
            return null;
        }
        SipApplicationSessionImpl sas = this.sipApplicationSessionStore.load(id);
        if (sas == null) {
            return null;
        }
        this.addSession(sas);
        return sas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ServletTimerImpl findServletTimer(String id) {
        ServletTimerImpl servletTimer = super.findServletTimer(id);
        if (servletTimer != null) {
            return servletTimer;
        }
        ClassLoader webappCL = null;
        ClassLoader curCL = null;
        if (this.getContext() != null && this.getContext().getLoader() != null) {
            webappCL = this.getContext().getLoader().getClassLoader();
            curCL = Thread.currentThread().getContextClassLoader();
        }
        if (webappCL != null && curCL != webappCL) {
            try {
                Thread.currentThread().setContextClassLoader(webappCL);
                servletTimer = this.swapInServletTimer(id);
                Thread.currentThread().setContextClassLoader(curCL);
            }
            catch (IOException ioe) {
                Thread.currentThread().setContextClassLoader(curCL);
                catch (Throwable throwable) {
                    Thread.currentThread().setContextClassLoader(curCL);
                    throw throwable;
                }
            }
        } else {
            try {
                servletTimer = this.swapInServletTimer(id);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return servletTimer;
    }

    public void removeServletTimer(ServletTimerImpl servletTimer) {
        super.removeServletTimer(servletTimer);
        if (this.servletTimerStore != null) {
            try {
                this.servletTimerStore.remove(servletTimer.getId());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void writeServletTimer(ServletTimerImpl servletTimer) throws IOException {
        if (this.servletTimerStore != null) {
            this.servletTimerStore.save(servletTimer);
        }
    }

    protected ServletTimerImpl swapInServletTimer(String id) throws IOException {
        if (this.servletTimerStore == null) {
            return null;
        }
        ServletTimerImpl servletTimer = this.servletTimerStore.load(id);
        if (servletTimer == null) {
            return null;
        }
        this.addServletTimer(servletTimer);
        return servletTimer;
    }

    public void setSipSessionStore(SipSessionStore store) {
        this.sipSessionStore = store;
        this.sipSessionStore.setSipSessionManager(this);
    }

    public SipSessionStore getSipSessionStore() {
        return this.sipSessionStore;
    }

    public void setSipApplicationSessionStore(SipApplicationSessionStore store) {
        this.sipApplicationSessionStore = store;
        this.sipApplicationSessionStore.setSipSessionManager(this);
    }

    public SipApplicationSessionStore getSipApplicationSessionStore() {
        return this.sipApplicationSessionStore;
    }

    public void setServletTimerStore(ServletTimerStore store) {
        this.servletTimerStore = store;
        this.servletTimerStore.setSipSessionManager(this);
    }

    public ServletTimerStore getServletTimerStore() {
        return this.servletTimerStore;
    }
}

