/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.ProxyImpl;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import java.io.IOException;

public class ProxyContext
implements PathNode {
    private final ProxyImpl _proxy;
    private SipSessionBase _session = null;

    public ProxyContext(ProxyImpl proxy, SipSessionBase session) {
        this._proxy = proxy;
        this._session = session;
    }

    public ProxyImpl getProxy() {
        return this._proxy;
    }

    public PathNode.Type getType() {
        return this._proxy.getType();
    }

    public Object clone() {
        return new ProxyContext(this.getProxy(), this.getSipSession());
    }

    public synchronized SipSessionBase getSipSession() {
        return this._session;
    }

    public synchronized void setSipSession(SipSessionBase session) {
        this._session = session;
    }

    public SipApplicationSessionImpl getApplicationSession() {
        return this._session.getApplicationSessionImpl();
    }

    public void send(SipServletRequestImpl req) throws IOException, IllegalStateException {
        throw new IllegalStateException("Illegal to send from ProxyImpl, use proxyTo instead.");
    }

    public void send(SipServletResponseImpl resp) throws IOException, IllegalStateException {
        throw new IllegalStateException("Illegal to send from ProxyImpl, use proxyTo instead.");
    }

    public void dispatch(SipServletRequestImpl req) {
        this._proxy.dispatch(req, this);
    }

    public void dispatch(SipServletResponseImpl resp) {
        this._proxy.dispatch(resp, this);
    }

    public boolean isReplicable() {
        return this._session.isReplicable();
    }
}

