/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.FSM;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.UA;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;

public class SUBSCRIBE_REFERSession
extends FSM {
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private static SUBSCRIBE_REFERSession m_Instance = new SUBSCRIBE_REFERSession();

    private SUBSCRIBE_REFERSession() {
    }

    public static FSM createFSM(SipServletMessage m) {
        if (SUBSCRIBE_REFERSession.isStaticResponsible(m)) {
            return m_Instance;
        }
        return null;
    }

    public Object clone() {
        return m_Instance;
    }

    private static boolean isNotifyTerminatedState(SipServletMessage m) {
        String subState = m.getHeader("Subscription-State");
        if (subState == null) {
            return false;
        }
        return subState.matches("terminated");
    }

    protected static boolean hasEventHeader(SipServletMessage m) {
        return m.getHeader("Event") != null;
    }

    protected static boolean checkReferToHeader(SipServletMessage m) {
        ListIterator referTo = m.getHeaders("Refer-To");
        ListIterator referToShort = m.getHeaders("R");
        boolean referToCriterion = false;
        try {
            if (referTo.next() != null && !referTo.hasNext()) {
                referToCriterion = true;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        try {
            if (referToShort.next() != null && !referToShort.hasNext()) {
                referToCriterion = true;
            }
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        return referToCriterion;
    }

    protected static String getEventType(SipServletMessage m) {
        int posStop;
        int posStart;
        String event = m.getHeader("Event");
        if (event == null) {
            return null;
        }
        for (posStart = 0; event.charAt(posStart) == ' ' && posStart < event.length(); ++posStart) {
        }
        for (posStop = posStart; posStop < event.length() && event.charAt(posStop) != ';'; ++posStop) {
        }
        String eventType = null;
        if (posStop >= event.length()) {
            return event.substring(posStart, posStop);
        }
        eventType = event.substring(posStart, posStop);
        for (posStart = posStop + 1; posStart < event.length() && (event.charAt(posStart) != 'i' && event.charAt(posStart) != 'I' || event.charAt(posStart + 1) != 'd' && event.charAt(posStart + 1) != 'D'); ++posStart) {
        }
        int tmpPos = posStart - 1;
        while (event.charAt(tmpPos) == ' ') {
            --tmpPos;
        }
        if (event.charAt(tmpPos) != ';') {
            return eventType;
        }
        posStart += 2;
        while (event.charAt(posStart) == ' ' && posStart < event.length()) {
            ++posStart;
        }
        if (posStart < event.length() && event.charAt(posStart) == '=') {
            for (posStop = posStart++; posStop < event.length() && event.charAt(posStop) != ' ' && event.charAt(posStop) != ';'; ++posStop) {
            }
            return eventType + event.substring(posStart, posStop);
        }
        return eventType;
    }

    private static boolean isStaticResponsible(SipServletMessage m) {
        String method = m.getMethod();
        return method.equals("SUBSCRIBE") || method.equals("REFER") || method.equals("NOTIFY");
    }

    public boolean isResponsible(SipServletMessage m) {
        return SUBSCRIBE_REFERSession.isStaticResponsible(m);
    }

    private void setDerivedOrOriginalSession(SipServletResponseImpl resp, UA ua) {
        if (ua.getSipSession() != null && !ua.getSipSession().hasNoToTag() && resp.getDialog().getToTag() != null && resp.getDialog().getToTag().equals(ua.getSipSession().getToTag())) {
            resp.setSession(ua.getSipSession());
        } else {
            DialogFragment df = resp.getDialog();
            SipSessionBase s = resp.getSessionImpl().getOriginalOrDerivedSessionAndRegisterDialog(resp, df);
            if (s.isDerived()) {
                resp.setSession(s);
            }
            ua.setSipSession(s);
        }
    }

    private void doResponseUAC(SipServletResponseImpl resp, UA ua) {
        if (resp.hasToTag()) {
            String eventType = null;
            String method = resp.getMethod();
            if (method.equals("REFER")) {
                this.setDerivedOrOriginalSession(resp, ua);
                if (resp.getRequest().isInitial()) {
                    try {
                        ua.saveRouteSetRemoteTarget(resp);
                    }
                    catch (ServletParseException e) {
                        throw new IllegalStateException("Parse problem of Contact or Record-Route");
                    }
                }
                eventType = "refer" + resp.getCSeqNumber();
                ua.addDialogSession(method, eventType);
            } else {
                SipServletRequest req = resp.getRequest();
                eventType = SUBSCRIBE_REFERSession.getEventType((SipServletMessage)req);
                if (eventType != null) {
                    if (method.equals("SUBSCRIBE")) {
                        this.setDerivedOrOriginalSession(resp, ua);
                        if (resp.getRequest().isInitial()) {
                            try {
                                ua.saveRouteSetRemoteTarget(resp);
                            }
                            catch (ServletParseException e) {
                                throw new IllegalStateException("Parse problem of Contact or Record-Route");
                            }
                        }
                        ua.addDialogSession(method, eventType);
                    } else if (method.equals("NOTIFY") && SUBSCRIBE_REFERSession.isNotifyTerminatedState((SipServletMessage)req)) {
                        ua.removeDialogSession(method, eventType);
                    }
                }
            }
        }
    }

    private void doResponseUAS(SipServletResponseImpl resp, UA ua) {
        String eventType = null;
        String method = resp.getMethod();
        if (method.equals("REFER")) {
            if (!resp.hasToTag()) {
                resp.createTag("To");
                this.setDerivedOrOriginalSession(resp, ua);
                SipSessionDialogImpl s = (SipSessionDialogImpl)resp.getSessionImpl();
                s.swapLocalRemote();
                try {
                    ua.saveContactRouteSetRemoteTarget(resp);
                }
                catch (ServletParseException e) {
                    throw new IllegalStateException("Parse problem of Contact or Record-Route");
                }
                eventType = "refer" + resp.getCSeqNumber();
                ua.addDialogSession(method, eventType);
            }
        } else {
            SipServletRequest req = resp.getRequest();
            eventType = SUBSCRIBE_REFERSession.getEventType((SipServletMessage)req);
            int status = resp.getStatus();
            if (eventType != null) {
                if (method.equals("SUBSCRIBE")) {
                    if (!resp.hasToTag()) {
                        resp.createTag("To");
                        if (status >= 200 && status < 300) {
                            this.setDerivedOrOriginalSession(resp, ua);
                            SipSessionDialogImpl s = (SipSessionDialogImpl)resp.getSessionImpl();
                            s.swapLocalRemote();
                            try {
                                ua.saveContactRouteSetRemoteTarget(resp);
                            }
                            catch (ServletParseException e) {
                                throw new IllegalStateException("Parse problem of Contact or Record-Route");
                            }
                            ua.addDialogSession(method, eventType);
                        }
                    }
                } else if (method.equals("NOTIFY") && SUBSCRIBE_REFERSession.isNotifyTerminatedState((SipServletMessage)req)) {
                    ua.removeDialogSession(method, eventType);
                }
            } else if (status >= 200 && status < 300) {
                throw new IllegalStateException("Original request missing Event header field");
            }
        }
    }

    public void send(SipServletRequestImpl req, UA ua) throws IllegalStateException {
        String method;
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, req.toDebugString());
        }
        if ((method = req.getMethod()).equals("SUBSCRIBE") || method.equals("NOTIFY")) {
            if (!SUBSCRIBE_REFERSession.hasEventHeader(req)) {
                throw new IllegalStateException("Missing Event header field");
            }
        } else if (method.equals("REFER") && !SUBSCRIBE_REFERSession.checkReferToHeader(req)) {
            throw new IllegalStateException("Missing Refer-To header field");
        }
        SipServletRequestImpl clone = (SipServletRequestImpl)req.clone();
        clone.setTransactionRequest(req);
        super.send(clone, ua);
    }

    public void send(SipServletResponseImpl resp, UA ua) throws IllegalStateException {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, resp.toDebugString());
        }
        this.doResponseUAS(resp, ua);
        SipServletResponseImpl clone = (SipServletResponseImpl)resp.clone();
        SipServletRequestImpl req = resp.getRequestImpl().getTransactionRequest();
        if (req != null) {
            clone.setRequest(req);
            clone.setSession(req.getSessionImpl());
        }
        super.send(clone, ua);
    }

    private void setDerivedOrOriginalSession(SipServletRequestImpl req, UA ua) throws ServletParseException {
        if (req.getMethod().equals("NOTIFY")) {
            if (!ua.getSipSession().hasNoToTag() && req.getDialog().getToTag() != null && req.getDialog().getToTag().equals(ua.getSipSession().getToTag())) {
                req.setSession(ua.getSipSession());
            } else {
                DialogFragment df = req.getDialog();
                SipSessionBase s = ua.getSipSession().getOriginalOrDerivedSessionAndRegisterDialog(req, df);
                req.setSession(s);
                ua.setSipSession(s);
                ua.saveContactRouteSetRemoteTarget(req);
            }
        } else {
            req.setSession(ua.getSipSession());
        }
    }

    public void dispatch(SipServletRequestImpl req, UA ua) {
        block12: {
            String method;
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, req.toDebugString());
            }
            if ((method = req.getMethod()).equals("SUBSCRIBE") || method.equals("NOTIFY")) {
                if (!SUBSCRIBE_REFERSession.hasEventHeader(req)) {
                    SipServletResponseImpl resp = req.createTerminatingResponse(400, "Missing Event header field");
                    resp.popDispatcher().dispatch(resp);
                    return;
                }
            } else if (method.equals("REFER") && !SUBSCRIBE_REFERSession.checkReferToHeader(req)) {
                SipServletResponseImpl resp = req.createTerminatingResponse(400, "Missing Refer-To header field");
                resp.popDispatcher().dispatch(resp);
                return;
            }
            try {
                this.setDerivedOrOriginalSession(req, ua);
                Servlet s = ua.getServlet(req.getSessionImpl().getHandler());
                if (s != null) {
                    s.service((ServletRequest)req, null);
                } else if (m_Log.isLoggable(Level.INFO)) {
                    m_Log.log(Level.INFO, "Could not find servlet name: " + req.getSessionImpl().getHandler() + " in application: " + req.getSessionImpl().getApplicationSessionImpl().getName());
                }
            }
            catch (Exception e) {
                String eventType;
                SipServletResponseImpl resp;
                if (m_Log.isLoggable(Level.FINE)) {
                    m_Log.log(Level.FINE, "Caught Exception: ", e);
                }
                if ((resp = req.createTerminatingResponse(500)) != null) {
                    resp.popDispatcher().dispatch(resp);
                }
                if ((eventType = SUBSCRIBE_REFERSession.getEventType(req)) == null) break block12;
                ua.removeDialogSession(req.getMethod(), eventType);
            }
        }
    }

    public void dispatch(SipServletResponseImpl resp, UA ua) {
        block6: {
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, resp.toDebugString());
            }
            this.doResponseUAC(resp, ua);
            try {
                Servlet s = ua.getServlet(resp.getSessionImpl().getHandler());
                if (s != null) {
                    s.service(null, (ServletResponse)resp);
                } else if (m_Log.isLoggable(Level.INFO)) {
                    m_Log.log(Level.INFO, "Could not find servlet name: " + resp.getSessionImpl().getHandler() + " in application: " + resp.getSessionImpl().getApplicationSessionImpl().getName());
                }
            }
            catch (Exception e) {
                if (!m_Log.isLoggable(Level.INFO)) break block6;
                m_Log.log(Level.INFO, "Problem in servlet.", e);
            }
        }
    }

    public boolean isDeletable() {
        return false;
    }
}

