/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.lease.Lease;
import com.ericsson.ssa.config.lease.LeaseExpiredException;
import com.ericsson.ssa.container.SipBindingResolver;
import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.DialogFragmentManager;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipURIImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class SessionManager
implements Layer {
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private static SessionManager m_Instance = null;
    private static final int INITIAL_CAPACITY = 1000;
    private static Class m_FactoryClass = null;
    private ConcurrentHashMap<String, DialogSet> m_EarlyDialogs = null;
    private Layer m_NextLayer = null;
    private SipURIImpl m_URI = null;
    private SipURIImpl m_SURI = null;
    private boolean defaultTCPTransport = false;
    private AtomicLong m_EasFailedSipDialogs = new AtomicLong();
    private AtomicLong m_EasSuccessfulSipDialogs = new AtomicLong();
    private Config _config = ConfigFactory.getConfig();

    protected SessionManager() {
        this.m_EarlyDialogs = new ConcurrentHashMap(1000);
    }

    public void start() {
        this.m_URI = new SipURIImpl();
        this.m_SURI = new SipURIImpl();
        if (Boolean.getBoolean("sip.module.use_new_config")) {
            SipURIImpl[] ifs = this.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                if (this.m_URI == null && this.defaultTCPTransport && ifs[i].getTransportParam().equals("TCP")) {
                    this.m_URI = ifs[i];
                    continue;
                }
                if (this.m_URI == null && ifs[i].getTransportParam().equals("UDP")) {
                    this.m_URI = ifs[i];
                    continue;
                }
                if (this.m_SURI != null || !ifs[i].isSecure()) continue;
                this.m_SURI = ifs[i];
            }
        } else {
            this.m_URI.setHost(this._config.get("SIP_PUBLIC_HOST"));
            this.m_URI.setPort(Integer.parseInt(this._config.get("SIP_PUBLIC_PORT")));
            this.m_SURI.setHost(this._config.get("SIP_PUBLIC_HOST"));
            this.m_SURI.setPort(this.m_URI.getPort() + 1);
            this.m_SURI.setSecure(true);
            this.m_SURI.setTransportParam("TLS");
        }
        if (this.defaultTCPTransport) {
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, "SessionManager starting, defaultTCPTransport=" + this.defaultTCPTransport);
            }
            this.m_URI.setTransportParam("tcp");
        }
    }

    private SipURIImpl[] getInterfaces() {
        SipURIImpl[] interfaces = null;
        try {
            Lease<TargetTuple[]> lease = SipBindingResolver.instance().lease("PUBLIC_BINDING_CTX");
            System.out.println("SessionManager: \n" + lease.getResource()[0]);
            TargetTuple[] tt = lease.getResource();
            interfaces = new SipURIImpl[tt.length];
            for (int i = 0; i < tt.length; ++i) {
                SipURIImpl s = new SipURIImpl(tt[i].getProtocol().ordinal() == 3, null, tt[i].getIP());
                s.setPort(tt[i].getPort());
                s.setTransportParam(tt[i].getProtocol().name());
                interfaces[i] = s;
            }
        }
        catch (LeaseExpiredException e) {
            e.printStackTrace();
        }
        return interfaces;
    }

    public void addContact(SipServletRequestImpl req) {
        int fragId;
        DialogFragment df = req.getDialog();
        URI nextTarget = null;
        Header r = req.getRawHeader("Route");
        if (r == null) {
            nextTarget = req.getRequestURI();
        } else {
            try {
                nextTarget = r.getAddressValue().getURI();
            }
            catch (ServletParseException ignore) {
                // empty catch block
            }
        }
        SipURIImpl uri = null;
        uri = nextTarget != null && nextTarget.isSipURI() && ((SipURI)nextTarget).isSecure() ? (SipURIImpl)this.m_SURI.clone() : (SipURIImpl)this.m_URI.clone();
        if (df != null && (fragId = df.getFragmentId()) != 1) {
            uri.setParameter("fid", Integer.toString(fragId));
        }
        MultiLineHeader contactHeader = new MultiLineHeader("Contact", true);
        ((Header)contactHeader).setValue("<" + uri.toString() + ">", false);
        req.addHeader(contactHeader);
        req.indicateContact();
    }

    public void addContact(SipServletResponseImpl resp) {
        int fragId;
        URI nextTarget;
        DialogFragment df;
        block5: {
            df = resp.getDialog();
            nextTarget = null;
            if (resp.getRequestImpl() != null && resp.getRequestImpl().getRequestURI() != null && resp.getRequestImpl().getRequestURI().isSipURI()) {
                nextTarget = resp.getRequestImpl().getRequestURI();
            }
            if (nextTarget != null && !((SipURI)nextTarget).isSecure()) {
                Header rr = resp.getRawHeader("Record-Route");
                try {
                    nextTarget = rr != null && rr.getAddressValue().getURI().isSipURI() ? rr.getAddressValue().getURI() : resp.getRequestImpl().getRawHeader("Contact").getAddressValue().getURI();
                }
                catch (ServletParseException spe) {
                    if (!m_Log.isLoggable(Level.FINE)) break block5;
                    m_Log.log(Level.FINE, "Failed eval 12.1.1 rules", spe);
                }
            }
        }
        SipURIImpl uri = null;
        uri = nextTarget != null && nextTarget.isSipURI() && ((SipURI)nextTarget).isSecure() ? (SipURIImpl)this.m_SURI.clone() : (SipURIImpl)this.m_URI.clone();
        if (df != null && (fragId = df.getFragmentId()) != 1) {
            uri.setParameter("fid", Integer.toString(fragId));
        }
        MultiLineHeader contactHeader = new MultiLineHeader("Contact", true);
        ((Header)contactHeader).setValue("<" + uri.toString() + ">", false);
        resp.addHeader(contactHeader);
        resp.indicateContact();
    }

    public void addRecordRoute(SipServletRequestImpl req) {
        int fragId;
        DialogFragment df = req.getDialog();
        Header rrHeader = req.getRawHeader("Record-Route");
        if (rrHeader == null) {
            rrHeader = new MultiLineHeader("Record-Route", true);
            req.addHeader(rrHeader);
        }
        URI nextTarget = null;
        Header r = req.getRawHeader("Route");
        if (r == null) {
            nextTarget = req.getRequestURI();
        } else {
            try {
                nextTarget = r.getAddressValue().getURI();
            }
            catch (ServletParseException ignore) {
                // empty catch block
            }
        }
        SipURIImpl uri = null;
        if (nextTarget != null && nextTarget.isSipURI() && ((SipURI)nextTarget).isSecure()) {
            uri = (SipURIImpl)this.m_SURI.clone();
            uri.setLrParam(true);
        } else {
            uri = (SipURIImpl)this.m_URI.clone();
            uri.setLrParam(true);
        }
        if (df != null && (fragId = df.getFragmentId()) != 1) {
            uri.setParameter("fid", Integer.toString(fragId));
            boolean bl = false;
        }
        this.setRecordRouteParams(req, uri);
        rrHeader.setValue("<" + uri.toString() + ">", true);
    }

    private void setRecordRouteParams(SipServletRequestImpl req, SipURIImpl uri) {
        Iterator iter = req.getRecordRouteURIParamNames();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            uri.setParameter(name, req.getRecordRouteURIParam(name));
        }
    }

    private SipServletResponseImpl setDialogContext(SipServletRequestImpl req) {
        SipServletResponseImpl resp = null;
        SipSessionBase s = this.getSession(req);
        if (s != null) {
            req.setSession(s);
        } else if (!req.getMethod().equals("ACK")) {
            resp = req.createTerminatingResponse(481);
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "Call Leg/Transaction does not exist for request " + req.getMethod() + " with callId = " + req.getCallId() + ", from = " + req.getFrom() + ", to = " + req.getTo());
        }
        return resp;
    }

    public void next(SipServletRequestImpl req) {
        SipServletResponseImpl resp = null;
        req.pushTransactionDispatcher(this);
        req.pushApplicationDispatcher(this);
        if (!req.isInitial()) {
            resp = this.setDialogContext(req);
            if (resp != null) {
                resp.popDispatcher().dispatch(resp);
                return;
            }
        } else if (SipFactoryImpl.isDialogCreational(req.getMethod())) {
            if (req.getHeader("Contact") == null) {
                resp = req.createTerminatingResponse(400, "Missing Contact header field");
                resp.popDispatcher().dispatch(resp);
                return;
            }
            if (!this.isValidContact(req.getRawHeader("Contact"))) {
                resp = req.createTerminatingResponse(400, "Invalid Contact header field");
                if (resp == null) {
                    return;
                }
                resp.popDispatcher().dispatch(resp);
                return;
            }
        }
        LayerHelper.next(req, (Layer)this, this.m_NextLayer);
    }

    private boolean isValidContact(Header header) {
        try {
            Address adr = header.getAddressValue();
            adr.toString();
        }
        catch (ServletParseException e) {
            return false;
        }
        return true;
    }

    private void replaceTranscationPath(SipServletResponseImpl resp, DialogFragment d) {
        for (int i = 0; i < d.size(); ++i) {
            resp.popDispatcher();
        }
        PathNode p = null;
        Iterator<PathNode> i = d.getCallee2CallerPath();
        while (i.hasNext()) {
            p = i.next();
            if (!resp.getRequestImpl().getSupervised()) continue;
            resp.pushTransactionDispatcher(p);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void next(SipServletResponseImpl resp) {
        SipServletRequestImpl req = resp.getRequestImpl();
        DialogFragment dialog = req.getDialog();
        if (dialog == null) {
            resp.copyTransactionStack();
            this.dispatch(resp);
            return;
        }
        String respToTag = resp.getTo().getParameter("tag");
        if (respToTag == null && resp.getStatus() != 100) {
            throw new IllegalStateException("Missing mandatory To-tag in response");
        }
        if (req.getMethod().equals("SUBSCRIBE") && req.isInitial()) {
            DialogSet ds = dialog.getDialogSet();
            String id = DialogFragment.createKey(resp.getCallId(), ds.getFromTag(), respToTag, req.getFragmentId());
            DialogFragment clonedOrFetched = DialogFragmentManager.getInstance().findDialogFragment(id);
            if (clonedOrFetched == null) {
                boolean success = false;
                clonedOrFetched = ds.getDialog(req.getFragmentId());
                if (clonedOrFetched != null) {
                    success = clonedOrFetched.tryToSetToTagAndRegisterDialog(respToTag, true);
                }
                if (!success) {
                    clonedOrFetched = ds.cloneDialog(req.getFragmentId());
                }
            }
            resp.setDialog(clonedOrFetched);
            resp.copyTransactionStack();
            if (clonedOrFetched != dialog) {
                if (clonedOrFetched != null) {
                    this.replaceTranscationPath(resp, clonedOrFetched);
                } else {
                    if (!m_Log.isLoggable(Level.FINE)) return;
                    Iterator<DialogFragment> allDialogFragments = ds.getDialogs();
                    int counter = 0;
                    while (true) {
                        if (!allDialogFragments.hasNext()) {
                            m_Log.log(Level.FINE, "[clonedOrFetched=" + clonedOrFetched + ", FromTag=" + ds.getFromTag() + ", FragmentId=" + req.getFragmentId() + ", allDialogFragments size=" + counter + " FragmentId=" + dialog.getFragmentId());
                            return;
                        }
                        ++counter;
                    }
                }
            }
        } else if (req.isInitial() && dialog.getToTag() != null && !dialog.getToTag().equals(respToTag)) {
            String id = DialogFragment.createKey(resp.getCallId(), dialog.getDialogSet().getFromTag(), respToTag, req.getFragmentId());
            DialogFragment clonedOrFetched = DialogFragmentManager.getInstance().findDialogFragment(id);
            if (clonedOrFetched == null) {
                clonedOrFetched = (DialogFragment)dialog.clone();
            }
            resp.setDialog(clonedOrFetched);
            resp.copyTransactionStack();
            this.replaceTranscationPath(resp, clonedOrFetched);
        } else {
            resp.setDialog(dialog);
            resp.copyTransactionStack();
        }
        SipServletRequestImpl transReq = req.getTransactionRequest();
        if (transReq != null) {
            resp.setRequest(transReq);
            resp.setSession(transReq.getSessionImpl());
        } else {
            resp.setSession(req.getSessionImpl());
        }
        LayerHelper.next(resp, (Layer)this, this.m_NextLayer);
    }

    public void registerNext(Layer layer) {
        this.m_NextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, req.toDebugString());
        }
        if (!req.isContactIndicated() && req.isRecordRouteIndicated()) {
            this.addRecordRoute(req);
        }
        this.registerEarlyDialog(req);
        req.popDispatcher().dispatch(req);
    }

    public void dispatch(SipServletResponseImpl resp) {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, resp.toDebugString());
        }
        if (PerformanceMBeanListener.isEnabled() && resp.getRequest().isInitial() && SipFactoryImpl.isDialogCreational(resp.getRequest().getMethod())) {
            if (resp.getStatus() >= 200 && resp.getStatus() < 300) {
                this.m_EasSuccessfulSipDialogs.incrementAndGet();
            } else if (resp.getStatus() >= 400 && resp.getStatus() < 700) {
                this.m_EasFailedSipDialogs.incrementAndGet();
            }
        }
        resp.popDispatcher().dispatch(resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionManager getInstance() {
        if (m_Instance != null) return m_Instance;
        Class<SessionManager> clazz = SessionManager.class;
        synchronized (SessionManager.class) {
            if (m_Instance != null) return m_Instance;
            if (m_FactoryClass == null) {
                m_Instance = new SessionManager();
            } else {
                try {
                    m_Instance = (SessionManager)m_FactoryClass.newInstance();
                }
                catch (Exception e) {
                    m_Log.log(Level.SEVERE, "Failed to instantiate factory class : ", e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_Instance;
        }
    }

    public static void initInstance(Class instance) {
        if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "instantiates this layer with class = " + instance.getCanonicalName());
        }
        if (m_Instance != null) {
            throw new IllegalStateException("Can not init class after the factory has given a reference away!");
        }
        m_FactoryClass = instance;
    }

    public DialogSet getEarlyDialog(String id) {
        return this.m_EarlyDialogs.get(id);
    }

    public void removeEarlyDialog(DialogSet d) {
        if (!this.m_EarlyDialogs.isEmpty()) {
            String id = DialogFragment.createKey(d.getCallId(), d.getFromTag());
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, "removeEarlyDialog with key = " + id + ", DialogSet = " + d);
            }
            this.m_EarlyDialogs.remove(id);
        }
    }

    private void registerEarlyDialog(SipServletRequestImpl req) {
        DialogFragment d;
        if (SipFactoryImpl.isDialogCreational(req.getMethod()) && req.isInitial() && (d = req.getDialog()) != null) {
            DialogSet ds = d.getDialogSet();
            String id = DialogFragment.createKey(ds.getCallId(), ds.getFromTag());
            this.m_EarlyDialogs.putIfAbsent(id, ds);
        }
    }

    private DialogFragment createDialogByCloningEarlyDialog(SipServletMessageImpl m) {
        DialogFragment d = null;
        if (m.getMethod().equals("NOTIFY") && !this.m_EarlyDialogs.isEmpty()) {
            String toTag = m.getTo().getParameter("tag");
            String id = DialogFragment.createKey(m.getCallId(), toTag);
            DialogSet ds = this.m_EarlyDialogs.get(id);
            if (ds != null) {
                boolean success = false;
                d = ds.getDialog(m.getFragmentId());
                if (d != null) {
                    success = d.tryToSetToTagAndRegisterDialog(m.getFrom().getParameter("tag"), true);
                }
                if (!success) {
                    d = ds.cloneDialog(m.getFragmentId());
                }
                m.setDialog(d);
            }
        }
        return d;
    }

    private SipSessionBase getEarlySession(SipServletRequestImpl req) {
        SipSessionBase s = null;
        DialogFragment d = this.createDialogByCloningEarlyDialog(req);
        if (d != null) {
            Iterator<PathNode> iter = null;
            PathNode p = null;
            req.setDirection(PathNode.Type.Callee);
            req.setDialog(d);
            iter = d.getCaller2CalleePath();
            while (iter.hasNext()) {
                p = iter.next();
                req.pushApplicationDispatcher(p);
            }
            s = p.getSipSession();
        }
        return s;
    }

    public SipSessionBase getSession(SipServletRequestImpl m) {
        SipSessionBase s = null;
        String toTag = null;
        String fromTag = null;
        DialogFragment d = null;
        Iterator<PathNode> iter = null;
        PathNode p = null;
        int fragmentId = m.getFragmentId();
        toTag = m.getTo().getParameter("tag");
        fromTag = m.getFrom().getParameter("tag");
        String id = DialogFragment.createKey(m.getCallId(), toTag, fromTag, fragmentId);
        d = DialogFragmentManager.getInstance().findDialogFragment(id);
        if (d != null) {
            m.setDirection(PathNode.Type.Callee);
            m.setDialog(d);
            iter = d.getCaller2CalleePath();
            while (iter.hasNext()) {
                p = iter.next();
                m.pushApplicationDispatcher(p);
            }
            s = p.getSipSession();
        } else {
            id = DialogFragment.createKey(m.getCallId(), fromTag, toTag, fragmentId);
            d = DialogFragmentManager.getInstance().findDialogFragment(id);
            if (d != null) {
                m.setDirection(PathNode.Type.Caller);
                m.setDialog(d);
                iter = d.getCallee2CallerPath();
                while (iter.hasNext()) {
                    p = iter.next();
                    m.pushApplicationDispatcher(p);
                }
                s = p.getSipSession();
            } else {
                s = this.getEarlySession(m);
            }
        }
        return s;
    }

    public void setDefaultTCPTransport(Boolean defaultTCPTransport) {
        this.defaultTCPTransport = defaultTCPTransport;
    }

    public long getEasFailedSipDialogs() {
        return this.m_EasFailedSipDialogs.longValue();
    }

    public long getEasExpiredSipDialogs() {
        return DialogFragmentManager.getInstance().getEasExpiredSipDialogs();
    }

    public long getEasSuccessfulSipDialogs() {
        return this.m_EasSuccessfulSipDialogs.longValue();
    }

    public long getEasTotalSipDialogCount() {
        return DialogFragmentManager.getInstance().getEasTotalSipDialogCount();
    }

    public long getEasTotalSipDialogLifeTime() {
        return DialogFragmentManager.getInstance().getEasTotalSipDialogLifeTime();
    }

    public long getEasConcurrentSipDialogs() {
        return DialogFragmentManager.getInstance().getEasConcurrentSipDialogs();
    }

    public long getEasHeapMemoryUsage() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }
}

