/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.container.sim.ApplicationDispatcher;
import com.ericsson.ssa.container.sim.ServletDispatcher;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipSessionManagerBase;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.TimerListener;
import javax.servlet.sip.URI;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.SessionLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipApplicationSessionImpl
implements SipApplicationSession,
TimerListener {
    private static final long serialVersionUID = 1972145565288132288L;
    private static Logger logger = Logger.getLogger("SipContainer");
    private static TimerServiceImpl m_timerService = null;
    private static ApplicationDispatcher m_ApplicationDispatcher = ApplicationDispatcher.getInstance();
    private String m_Name = null;
    private boolean m_IsValid = true;
    private int m_defaultSessionTimeout;
    private String m_Id = null;
    private long m_CreationDate = new Date().getTime();
    private Map<String, Object> m_ApplicationAttributeMap = null;
    private HashSet<String> m_SipProtocolSessions = new HashSet();
    private HashSet<String> m_HttpProtocolSessions = null;
    private SipApplicationListeners m_SipApplicationListeners = null;
    private Collection<ServletTimerImpl> m_applicationTimers = new HashSet<ServletTimerImpl>();
    private ServletTimerImpl m_applicationSessionTimer = null;
    private int m_deltaSessionTimeout = 0;
    private String m_currentServlet = null;
    private SipSessionManager m_SipSessionManager;
    private Manager m_HttpSessionManager;
    private SessionLock m_SessionLock = new SessionLock();
    private final Object SIP_APP_LOCK = new Object();
    private volatile boolean invalidateInProgress;
    protected AtomicLong version = new AtomicLong(-1L);

    public SipApplicationSessionImpl(SipSessionManagerBase manager, String id) {
        this.m_SipSessionManager = manager;
        this.m_Id = id;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "creating app session:" + this);
        }
    }

    public SipApplicationSessionImpl() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_Id);
        out.writeObject(this.version);
        out.writeObject(this.m_Name);
        out.writeLong(this.m_CreationDate);
        out.writeInt(this.m_defaultSessionTimeout);
        out.writeObject(this.m_currentServlet);
        out.writeObject(this.m_SipProtocolSessions);
        out.writeObject(this.m_HttpProtocolSessions);
        out.writeObject(this.m_applicationTimers);
        out.writeObject(this.m_applicationSessionTimer);
        out.writeObject(this.m_ApplicationAttributeMap);
        out.writeObject(this.m_SessionLock);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        ConvergedContext ctxt;
        this.m_Id = (String)in.readObject();
        this.version = (AtomicLong)in.readObject();
        this.m_Name = (String)in.readObject();
        this.m_SipSessionManager = SipSessionManagerBase.get(this.m_Name);
        if (this.m_SipSessionManager != null && (ctxt = this.m_SipSessionManager.getContext()) != null) {
            this.m_HttpSessionManager = ctxt.getManager();
        }
        this.m_CreationDate = in.readLong();
        this.m_defaultSessionTimeout = in.readInt();
        this.m_currentServlet = (String)in.readObject();
        this.m_SipProtocolSessions = (HashSet)in.readObject();
        this.m_HttpProtocolSessions = (HashSet)in.readObject();
        this.m_applicationTimers = (HashSet)in.readObject();
        this.m_applicationSessionTimer = (ServletTimerImpl)in.readObject();
        this.m_ApplicationAttributeMap = (Map)in.readObject();
        this.m_SessionLock = (SessionLock)in.readObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeURI(URI arg0) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String key) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            if (this.m_ApplicationAttributeMap == null) {
                return null;
            }
            return this.m_ApplicationAttributeMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<String> getAttributeNames() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            if (this.m_ApplicationAttributeMap == null) {
                return null;
            }
            return this.m_ApplicationAttributeMap.keySet().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCreationTime() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            return this.m_CreationDate;
        }
    }

    public String getId() {
        return this.m_Id;
    }

    public long getLastAccessedTime() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<?> getSessions() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            SipSessionDialogImpl sess;
            Iterator<String> ids;
            this.validateSessionState();
            ArrayList<SipSessionDialogImpl> list = new ArrayList<SipSessionDialogImpl>();
            if (this.m_SipProtocolSessions != null) {
                ids = this.m_SipProtocolSessions.iterator();
                while (ids.hasNext()) {
                    sess = this.m_SipSessionManager.findSipSession(ids.next());
                    if (sess == null) continue;
                    list.add(sess);
                }
            }
            if (this.m_HttpProtocolSessions != null) {
                ids = this.m_HttpProtocolSessions.iterator();
                while (ids.hasNext()) {
                    try {
                        sess = this.m_HttpSessionManager.findSession(ids.next());
                        if (sess == null) continue;
                        list.add((SipSessionDialogImpl)sess.getSession());
                    }
                    catch (IOException ioe) {}
                }
            }
            return list.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<?> getSessions(String protocol) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            if ("sip".equalsIgnoreCase(protocol) && this.m_SipProtocolSessions != null) {
                ArrayList<SipSessionDialogImpl> ss = new ArrayList<SipSessionDialogImpl>();
                Iterator<String> ids = this.m_SipProtocolSessions.iterator();
                while (ids.hasNext()) {
                    SipSessionDialogImpl sess = this.m_SipSessionManager.findSipSession(ids.next());
                    if (sess == null) continue;
                    ss.add(sess);
                }
                return ss.iterator();
            }
            if ("http".equalsIgnoreCase(protocol) && this.m_HttpProtocolSessions != null) {
                ArrayList<HttpSession> sw = new ArrayList<HttpSession>();
                Iterator<String> ids = this.m_HttpProtocolSessions.iterator();
                while (ids.hasNext()) {
                    try {
                        Session sess = this.m_HttpSessionManager.findSession(ids.next());
                        if (sess == null) continue;
                        sw.add(sess.getSession());
                    }
                    catch (IOException ioe) {}
                }
                return sw.iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServletTimer> getTimers() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            ArrayList<ServletTimer> timers = null;
            timers = new ArrayList<ServletTimer>(this.m_applicationTimers);
            return timers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        if (this.invalidateInProgress) {
            return;
        }
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.invalidate(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String key) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            if (this.m_ApplicationAttributeMap == null) {
                return;
            }
            this.m_ApplicationAttributeMap.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String key, Object value) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            if (this.m_ApplicationAttributeMap == null) {
                this.m_ApplicationAttributeMap = new HashMap<String, Object>();
            }
            this.m_ApplicationAttributeMap.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setExpires(int deltaMinutes) {
        if (deltaMinutes < 1) {
            throw new IllegalArgumentException();
        }
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            if (this.m_applicationSessionTimer != null) {
                this.m_applicationSessionTimer.cancel();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Started timer, session-timeout:" + deltaMinutes);
            }
            this.m_deltaSessionTimeout = deltaMinutes;
            this.m_applicationSessionTimer = m_timerService.createTimer(this, (long)(this.m_deltaSessionTimeout * 60) * 1000L, false, (Serializable)null);
            return this.m_deltaSessionTimeout;
        }
    }

    public void initAppSessionTimer() {
        int configuredSessionTimeout = this.getDefaultSessionTimeout();
        if (configuredSessionTimeout >= 1) {
            this.m_applicationSessionTimer = m_timerService.createTimer(this, (long)(configuredSessionTimeout * 60) * 1000L, false, (Serializable)null);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Started timer defined in sip.xml : session-timeout:" + configuredSessionTimeout);
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "No default timer, sip.xml : session-timeout:" + configuredSessionTimeout);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "app:" + this.m_Name + " " + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(ServletTimer timer) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "app session timeout:" + this.m_Name);
        }
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            boolean shouldContinue = false;
            this.invalidateInProgress = true;
            this.m_deltaSessionTimeout = 0;
            for (SipApplicationSessionListener listener : this.m_SipApplicationListeners.getSipApplicationSessionListeners()) {
                try {
                    listener.sessionExpired(new SipApplicationSessionEvent((SipApplicationSession)this));
                }
                catch (RuntimeException e) {
                    logger.log(Level.WARNING, "SipApplicationSessionListener.sessionExpired() generated an exception", e);
                }
                if (this.m_deltaSessionTimeout < 1) continue;
                shouldContinue = true;
                break;
            }
            this.invalidateInProgress = false;
            if (!shouldContinue && this.isValid()) {
                this.invalidate(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            return this.m_IsValid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            return this.m_Name;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String applicationName) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.m_Name = applicationName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(SipSessionBase session) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            this.m_SipProtocolSessions.add(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(SipSessionBase session) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            this.m_SipProtocolSessions.remove(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSession(HttpSession session) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            if (this.m_HttpProtocolSessions == null && this.m_HttpProtocolSessions == null) {
                this.m_HttpProtocolSessions = new HashSet();
            }
            this.m_HttpProtocolSessions.add(session.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServletTimer(ServletTimerImpl st) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.m_applicationTimers.add(st);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelServletTimer(ServletTimer st) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.m_applicationTimers.remove(st);
        }
        this.m_SipSessionManager.removeServletTimer((ServletTimerImpl)st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SipApplicationListeners getSipApplicationListeners() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            return this.m_SipApplicationListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSipApplicationListeners(SipApplicationListeners sipApplicationListeners) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            this.m_SipApplicationListeners = sipApplicationListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimerListener getTimerListener() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.validateSessionState();
            return this.m_SipApplicationListeners.getTimerListener();
        }
    }

    public int getDefaultSessionTimeout() {
        return this.m_defaultSessionTimeout;
    }

    public void setDefaultSessionTimeout(int sessionTimeout) {
        if (sessionTimeout == Integer.MIN_VALUE) {
            this.m_defaultSessionTimeout = 60;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "session-timeout not configured, using default:" + this.m_defaultSessionTimeout);
            }
        } else {
            this.m_defaultSessionTimeout = sessionTimeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentServlet(String servlet) {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            this.m_currentServlet = servlet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentServlet() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            return this.m_currentServlet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServletDispatcher getServletDispatcher() {
        Object object = this.SIP_APP_LOCK;
        synchronized (object) {
            return m_ApplicationDispatcher.getServletDispatcher(this.m_Name);
        }
    }

    private void invalidate(boolean hasTimedOut) {
        this.validateSessionState("Should not call invalidate() when appsession is not valid");
        if (this.m_applicationSessionTimer != null) {
            if (hasTimedOut) {
                this.m_applicationSessionTimer.cancel();
            } else {
                this.m_applicationSessionTimer.cancel(true);
            }
        }
        this.cancelAllServletTimers();
        this.m_applicationTimers.clear();
        ArrayList<SipApplicationSessionListener> listeners = this.getSipApplicationListeners().getSipApplicationSessionListeners();
        this.m_IsValid = false;
        for (SipApplicationSessionListener list : listeners) {
            try {
                list.sessionDestroyed(new SipApplicationSessionEvent((SipApplicationSession)this));
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "SipApplicationSessionListener.sessionDestroyed() generated an exception", e);
            }
        }
        Iterator<String> iter = this.m_SipProtocolSessions.iterator();
        while (iter.hasNext()) {
            SipSessionDialogImpl sess = this.m_SipSessionManager.findSipSession(iter.next());
            if (sess == null || !sess.isValid()) continue;
            sess.invalidate(hasTimedOut);
        }
        this.m_SipProtocolSessions.clear();
        if (this.m_HttpProtocolSessions != null) {
            iter = this.m_HttpProtocolSessions.iterator();
            while (iter.hasNext()) {
                try {
                    Session session = this.m_HttpSessionManager.findSession(iter.next());
                    if (session == null) continue;
                    session.getSession().invalidate();
                }
                catch (Exception ignore) {}
            }
            this.m_HttpProtocolSessions.clear();
        }
        this.m_SipSessionManager.removeSession(this);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "done invalidating app session:" + this);
        }
    }

    private void cancelAllServletTimers() {
        for (ServletTimer timer : this.getTimers()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancel timer:" + timer.toString());
            }
            ((ServletTimerImpl)timer).cancel(true);
        }
    }

    private void validateSessionState(String message) {
        if (!this.m_IsValid) {
            throw new IllegalStateException(message);
        }
    }

    private void validateSessionState() {
        this.validateSessionState("");
    }

    public SipSession getSipSession(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        Iterator<?> i = this.getSessions();
        while (i.hasNext()) {
            SipSession s = (SipSession)i.next();
            if (!s.getId().equals(id)) continue;
            return s;
        }
        return null;
    }

    public URL encodeURL(URL url) {
        throw new RuntimeException(" Not implemented yet ");
    }

    public long getExpirationTime() {
        throw new RuntimeException(" Not implemented yet ");
    }

    public SipSessionManager getSipSessionManager() {
        return this.m_SipSessionManager;
    }

    public void setHttpSessionManager(Manager manager) {
        this.m_HttpSessionManager = manager;
    }

    public String getCurrentOwnerInstanceName() {
        return this.m_SipSessionManager.getInstanceName();
    }

    protected boolean getSessionLockForForeground() {
        boolean result = false;
        long pollTime = 200L;
        int tryNumber = 0;
        int numTries = 7;
        boolean keepTrying = true;
        boolean lockResult = false;
        while (keepTrying) {
            lockResult = this.lockForeground();
            if (lockResult) {
                keepTrying = false;
                result = true;
                break;
            }
            if (++tryNumber < numTries - 1) {
                pollTime *= 2L;
                continue;
            }
            this.unlockBackground();
        }
        return result;
    }

    public synchronized boolean isForegroundLocked() {
        return this.m_SessionLock.isForegroundLocked();
    }

    public synchronized boolean lockBackground() {
        return this.m_SessionLock.lockBackground();
    }

    public synchronized boolean lockForeground() {
        return this.m_SessionLock.lockForeground();
    }

    public synchronized void unlockForegroundCompletely() {
        this.m_SessionLock.unlockForegroundCompletely();
    }

    public synchronized void unlockForeground() {
        this.m_SessionLock.unlockForeground();
    }

    public synchronized void unlockBackground() {
        this.m_SessionLock.unlockBackground();
    }

    public SessionLock getSessionLock() {
        return this.m_SessionLock;
    }

    public boolean isReplicable() {
        return "replicated".equals(this.m_SipSessionManager.getPersistenceType());
    }

    public void incrementVersion() {
        this.version.incrementAndGet();
    }

    static {
        m_timerService = TimerServiceImpl.getInstance();
    }
}

