/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.container.sim.ApplicationDispatcher;
import com.ericsson.ssa.dd.SessionCase;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.GeneralURIImpl;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.HeaderRequirement;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.ParameterableImpl;
import com.ericsson.ssa.sip.ServiceHandler;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SingleLineHeader;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.SipURIImpl;
import com.ericsson.ssa.sip.TelURLImpl;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.Address;
import javax.servlet.sip.AuthInfo;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.jvnet.glassfish.comms.security.auth.impl.AuthInfoImpl;

public class SipFactoryImpl
implements SipFactory {
    public static final String SIP_CHARSET = "UTF-8";
    public static final String PROTOCOL_LINE = "SIP/2.0";
    public static final String NEW_LINE = "\r\n";
    public static final String SIP_URI_PROTOCOL = "sip";
    public static final String HTTP_URI_PROTOCOL = "http";
    public static final String MAILTO_URI_PROTOCOL = "mailto";
    public static final String SIPS_URI_PROTOCOL = "sips";
    public static final String TEL_URI_PROTOCOL = "tel";
    public static final String SUPPORTED_100REL = "100rel";
    public static final String REMOTE_TARGET = "com.ericsson.ssa.RemoteTarget";
    public static final int START_CSEQ = 1;
    private static AtomicInteger m_GlobalCallID = new AtomicInteger(1);
    private static AtomicLong m_GlobalTag = new AtomicLong(1L);
    private static ServiceHandler m_ServiceHandler = null;
    private static final SipFactoryImpl _instance = new SipFactoryImpl();
    private static final Logger _log = Logger.getLogger("SipContainer");
    public static final int SIP_RFC_PORT = 5060;
    public static final int SIPS_RFC_PORT = 5061;
    private Config _config = ConfigFactory.getConfig();

    public static SipFactoryImpl getInstance() {
        return _instance;
    }

    public URI createURI(String uri) throws ServletParseException {
        int cnt;
        String protocol = null;
        byte[] buri = null;
        try {
            buri = uri.getBytes(SIP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.SEVERE, "All JVM must have UTF-8 enc", e);
            throw new ServletParseException("Unsupported URI protocol = " + protocol);
        }
        int position = 0;
        for (cnt = 0; cnt < buri.length && buri[cnt] != 58; ++cnt) {
        }
        try {
            protocol = new String(buri, position, cnt - position, SIP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.SEVERE, "All JVM must have UTF-8 enc", e);
            throw new ServletParseException("Unsupported URI protocol = " + protocol);
        }
        if (protocol.equals(SIP_URI_PROTOCOL)) {
            return new SipURIImpl(SIP_URI_PROTOCOL, buri, cnt + 1);
        }
        if (protocol.equals(TEL_URI_PROTOCOL)) {
            return new TelURLImpl(buri, cnt + 1);
        }
        if (protocol.equals(SIPS_URI_PROTOCOL)) {
            return new SipURIImpl(SIPS_URI_PROTOCOL, buri, cnt + 1);
        }
        if (protocol.equals(MAILTO_URI_PROTOCOL)) {
            return new GeneralURIImpl(MAILTO_URI_PROTOCOL, buri, cnt + 1);
        }
        if (protocol.equals(HTTP_URI_PROTOCOL)) {
            return new GeneralURIImpl(HTTP_URI_PROTOCOL, buri, cnt + 1);
        }
        throw new ServletParseException("Unsupported URI protocol = " + protocol);
    }

    public SipURI createSipURI(String user, String host) {
        SipURIImpl uri = new SipURIImpl();
        uri.setHost(host);
        uri.setUser(user);
        return uri;
    }

    public Address createAddress(String sipAddress) throws ServletParseException {
        return new AddressImpl(sipAddress);
    }

    public Address createAddress(URI uri) {
        return new AddressImpl(uri);
    }

    public Address createAddress(URI uri, String displayName) {
        AddressImpl result = new AddressImpl(uri);
        result.setDisplayName(displayName);
        return result;
    }

    public SipServletRequestImpl createRequest(SipApplicationSession appSession, String method, Address from, Address to) {
        return this.createRequestImpl((SipApplicationSessionImpl)appSession, method, from, to, false, null);
    }

    private void createSession(SipServletRequestImpl req, SipApplicationSessionImpl appSess, String handlerName) {
        DialogSet ds = new DialogSet(req.getCallId(), req.getFrom());
        DialogFragment df = new DialogFragment(ds);
        req.setDialog(df);
        DialogFragment d = req.getDialog();
        SipSessionDialogImpl s = appSess.getSipSessionManager().createSipSession(d.getDialogSet(), req.getTo(), appSess, handlerName);
        req.setSession(s);
    }

    public SipServletRequestImpl createRequestImpl(SipApplicationSessionImpl appSession, String method, Address from, Address to, boolean sameCallID, SipServletRequestImpl origRequest) {
        if (!method.equals("ACK") && !method.equals("CANCEL")) {
            Address fromCopy = (Address)from.clone();
            Address toCopy = (Address)to.clone();
            ((AddressImpl)fromCopy).setReadOnly(false);
            ((AddressImpl)toCopy).setReadOnly(false);
            fromCopy.setParameter("tag", this.createTag());
            toCopy.removeParameter("tag");
            ((AddressImpl)fromCopy).setReadOnly(true);
            ((AddressImpl)toCopy).setReadOnly(true);
            SipServletRequestImpl req = null;
            String defaultHandler = null;
            if (origRequest == null) {
                req = new SipServletRequestImpl(method, toCopy.getURI(), PROTOCOL_LINE);
            } else {
                req = (SipServletRequestImpl)origRequest.clone();
                req.clearApplicationDispatchers();
                req.setSessionCase(SessionCase.INTERNAL);
                req.removeSystemHeaders();
                defaultHandler = origRequest.getSessionImpl().getHandler();
            }
            SingleLineHeader callIDHeader = new SingleLineHeader("Call-Id", true);
            if (origRequest == null || !sameCallID) {
                ((Header)callIDHeader).setValue(this.createCallID(), false);
            } else {
                ((Header)callIDHeader).setValue(origRequest.getCallId(), false);
            }
            req.setHeader(callIDHeader);
            SingleLineHeader toHeader = new SingleLineHeader("To", true);
            ((Header)toHeader).setAddressValue(toCopy, false);
            req.setHeader(toHeader);
            SingleLineHeader fromHeader = new SingleLineHeader("From", true);
            ((Header)fromHeader).setAddressValue(fromCopy, false);
            req.setHeader(fromHeader);
            req.setMaxForwards(70);
            if (defaultHandler == null) {
                defaultHandler = appSession.getCurrentServlet();
            }
            this.createSession(req, appSession, defaultHandler);
            if (SipFactoryImpl.isDialogCreational(req.getMethod())) {
                SessionManager.getInstance().addContact(req);
            }
            SingleLineHeader cSeqHeader = new SingleLineHeader("Cseq", true);
            ((Header)cSeqHeader).setValue(Integer.toString(1) + " " + req.getMethod(), false);
            req.setHeader(cSeqHeader);
            req.setInitial(true);
            List<Layer> layers = LayerHandler.getInstance().getLayers();
            req._applicationStack.addAll(layers);
            if (!layers.isEmpty()) {
                Layer layer2 = layers.get(layers.size() - 1);
                if (layer2 instanceof ApplicationDispatcher) {
                    ((ApplicationDispatcher)layer2).pushServiceDispatcher(req);
                } else {
                    for (Layer layer2 : layers) {
                        if (!(layer2 instanceof ApplicationDispatcher)) continue;
                        ((ApplicationDispatcher)layer2).pushServiceDispatcher(req);
                    }
                }
            }
            return req;
        }
        throw new IllegalArgumentException("ACK and CANCEL is not allowed to create here.");
    }

    public SipServletRequestImpl createRequest(SipApplicationSession appSession, String method, URI from, URI to) {
        return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to));
    }

    public SipServletRequestImpl createRequest(SipApplicationSession appSession, String method, String from, String to) throws ServletParseException {
        return this.createRequest(appSession, method, this.createAddress(from), this.createAddress(to));
    }

    public SipServletRequestImpl createRequest(SipServletRequest origRequest, boolean sameCallId) {
        SipServletRequestImpl origRequestImpl = (SipServletRequestImpl)origRequest;
        SipServletRequestImpl req = this.createRequestImpl((SipApplicationSessionImpl)origRequest.getApplicationSession(), origRequest.getMethod(), origRequest.getFrom(), origRequest.getTo(), sameCallId, origRequestImpl);
        Header route = origRequestImpl.getRawHeader("Route");
        if (route != null) {
            req.setHeader((Header)route.clone());
        }
        return req;
    }

    public SipApplicationSessionImpl createApplicationSession() {
        return null;
    }

    public String createTag() {
        StringBuilder sb = new StringBuilder(Long.toString(System.currentTimeMillis(), 36)).append('-').append(Long.toString(m_GlobalTag.getAndIncrement(), 36));
        return sb.toString();
    }

    public String createCallID() {
        int id = m_GlobalCallID.getAndIncrement();
        long r = Math.abs(new Random().nextLong());
        StringBuilder sb = new StringBuilder();
        sb.append(this._config.get("SIP_PUBLIC_HOST"));
        sb.append('_').append(id).append('_').append(r);
        return sb.toString();
    }

    public Parameterable createParameterable(String s) {
        return ParameterableImpl.parse(s);
    }

    public ServiceHandler getServiceHandler() {
        return m_ServiceHandler;
    }

    public void setServiceHandler(ServiceHandler s) {
        m_ServiceHandler = s;
    }

    public static HeaderRequirement getContactRequirement(SipServletResponse resp) {
        int status = resp.getStatus();
        String method = resp.getMethod();
        if ("BYE".equals(method) && (status >= 300 && status < 400 || status == 485)) {
            return HeaderRequirement.OPTIONAL;
        }
        if ("INVITE".equals(method)) {
            if (status > 100 && status < 200) {
                return HeaderRequirement.OPTIONAL;
            }
            if (status >= 200 && status < 300) {
                return HeaderRequirement.MANDATORY;
            }
            if (status >= 300 && status < 400 || status == 485) {
                return HeaderRequirement.OPTIONAL;
            }
        }
        if (("OPTION".equals(method) || "REGISTER".equals(method)) && (status >= 200 && status < 400 || status == 485)) {
            return HeaderRequirement.OPTIONAL;
        }
        if ("SUBSCRIBE".equals(method)) {
            if (status >= 100 && status < 200) {
                return HeaderRequirement.OPTIONAL;
            }
            if (status >= 200 && status < 400) {
                return HeaderRequirement.MANDATORY;
            }
            if (status == 485) {
                return HeaderRequirement.OPTIONAL;
            }
        }
        if ("NOTIFY".equals(method)) {
            if (status >= 100 && status < 300) {
                return HeaderRequirement.OPTIONAL;
            }
            if (status >= 300 && status < 400) {
                return HeaderRequirement.MANDATORY;
            }
            if (status == 485) {
                return HeaderRequirement.OPTIONAL;
            }
        }
        if ("REFER".equals(method)) {
            if (status >= 200 && status < 300) {
                return HeaderRequirement.MANDATORY;
            }
            if (status >= 300 && status < 700) {
                return HeaderRequirement.OPTIONAL;
            }
        }
        if ("UPDATE".equals(method)) {
            if (status >= 100 && status < 200) {
                return HeaderRequirement.OPTIONAL;
            }
            if (status >= 200 && status < 300) {
                return HeaderRequirement.MANDATORY;
            }
            if (status >= 300 && status < 400 || status == 485) {
                return HeaderRequirement.OPTIONAL;
            }
        }
        if ("MESSAGE".equals(method) && (status >= 300 && status < 400 || status == 485)) {
            return HeaderRequirement.OPTIONAL;
        }
        if ("PRACK".equals(method) && (status >= 300 && status < 400 || status == 485)) {
            return HeaderRequirement.OPTIONAL;
        }
        return HeaderRequirement.NOT_APPLICAPLE;
    }

    public static boolean isDialogCreational(String method) {
        return method.equals("SUBSCRIBE") || method.equals("INVITE") || method.equals("REFER") || method.equals("NOTIFY");
    }

    public static boolean isContactMandatory(SipServletRequest req) {
        return SipFactoryImpl.isDialogCreational(req.getMethod()) || req.getMethod().equals("UPDATE");
    }

    public AuthInfo createAuthInfo() {
        return new AuthInfoImpl();
    }
}

