/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.container.SipParserErrorHandler;
import com.ericsson.ssa.sip.AddressHeaderValidator;
import com.ericsson.ssa.sip.CSeqHeaderValidator;
import com.ericsson.ssa.sip.CallIDValidator;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.MandatoryHeaderValidator;
import com.ericsson.ssa.sip.MaxForwardsValidator;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.ViaHeaderValidator;
import com.ericsson.ssa.sip.dns.SipTransports;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.URI;

public class SipParser {
    private static SipFactory sf = SipFactoryImpl.getInstance();
    private static SipParser _instance = null;
    Logger log = Logger.getLogger("SipContainer");
    private ArrayList<MandatoryHeaderValidator> mandatoryHeaderValidators = new ArrayList();

    private SipParser() {
        this.mandatoryHeaderValidators.add(new CallIDValidator());
        this.mandatoryHeaderValidators.add(new AddressHeaderValidator("From"));
        this.mandatoryHeaderValidators.add(new AddressHeaderValidator("To"));
        this.mandatoryHeaderValidators.add(new CSeqHeaderValidator());
        this.mandatoryHeaderValidators.add(new ViaHeaderValidator());
        this.mandatoryHeaderValidators.add(new MaxForwardsValidator());
    }

    public static synchronized SipParser getInstance() {
        if (_instance != null) {
            return _instance;
        }
        _instance = new SipParser();
        return _instance;
    }

    public SipServletMessageImpl parseMessage(SipServletMessageImpl message, ByteBuffer bb, InetSocketAddress local, TargetTuple remote, SipParserErrorHandler errorHandler) throws UnsupportedEncodingException {
        int cnt;
        long startTime = 0L;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Data is ready for process : " + bb.limit());
        }
        if (this.log.isLoggable(Level.FINE)) {
            startTime = System.nanoTime();
        }
        byte[] bs = bb.array();
        int limit = bb.limit();
        int offset = bb.arrayOffset();
        for (cnt = bb.position(); message == null && cnt < limit; cnt += 2) {
            try {
                int x;
                int position = bb.position();
                int foundSipVersion = -1;
                boolean isRequest = false;
                boolean isResponse = false;
                while (cnt + 1 < limit && (bs[cnt + offset] != 13 || bs[cnt + 1 + offset] != 10)) {
                    if (!(isRequest || isResponse || cnt + 6 >= limit || bs[cnt + offset] != 115 && bs[cnt + offset] != 83 || bs[cnt + 1 + offset] != 105 && bs[cnt + 1 + offset] != 73 || bs[cnt + 2 + offset] != 112 && bs[cnt + 2 + offset] != 80 || bs[cnt + 3 + offset] != 47 || bs[cnt + 4 + offset] != 50 || bs[cnt + 5 + offset] != 46 || bs[cnt + 6 + offset] != 48)) {
                        foundSipVersion = cnt;
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, "Found SIP/2.0 version at index = " + foundSipVersion);
                        }
                        if (cnt + 8 < limit && bs[cnt + 7 + offset] == 13 && bs[cnt + 8 + offset] == 10) {
                            isRequest = true;
                            cnt += 6;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.log(Level.FINE, "The message is a SIP request");
                            }
                        } else if (cnt + 7 < limit && bs[cnt + 7 + offset] == 32) {
                            isResponse = true;
                            cnt += 7;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.log(Level.FINE, "The message is a SIP response");
                            }
                        } else {
                            cnt += 6;
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.log(Level.FINE, "Not a valid SIP/2.0 string");
                            }
                            foundSipVersion = -1;
                        }
                    }
                    ++cnt;
                }
                if (cnt + 2 >= limit) {
                    return null;
                }
                bb.position(cnt + 2);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "The first line is : " + new String(bs, position + offset, cnt - position, "UTF-8"));
                }
                if (isRequest) {
                    URI uri;
                    int foundMethod;
                    for (x = foundSipVersion - 2; x > 0 && bs[x + offset] != 32; --x) {
                    }
                    String reqUri = new String(bs, x + 1 + offset, foundSipVersion - x - 2, "UTF-8");
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "ReqUri = " + reqUri + " x = " + x + " len = " + (foundSipVersion - x - 2));
                    }
                    if (x == 0) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, "Error in parser the first line is corrupt!");
                        }
                        return null;
                    }
                    --x;
                    while (x > 0 && bs[x - 1] > 64 && bs[x - 1] < 91) {
                        --x;
                    }
                    String method = new String(bs, x + offset, foundMethod - x, "UTF-8");
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "method = " + method);
                    }
                    if ((uri = sf.createURI(reqUri)) == null) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, "Error could not create Request Uri.");
                        }
                        return null;
                    }
                    message = new SipServletRequestImpl(method, uri, "SIP/2.0");
                    message.setLocal(local);
                    message.setRemote(remote);
                    continue;
                }
                if (isResponse) {
                    int code;
                    int start = foundSipVersion + 8;
                    for (x = foundSipVersion + 8; x < cnt && bs[x + offset] != 32; ++x) {
                    }
                    String codeStr = new String(bs, start + offset, x - start, "UTF-8");
                    String phrase = new String(bs, x + 1 + offset, cnt - x - 1, "UTF-8");
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "codeStr = " + codeStr + " phrase = " + phrase);
                    }
                    if (699 < (code = Integer.parseInt(codeStr)) || code < 100) {
                        if (this.log.isLoggable(Level.FINE)) {
                            this.log.log(Level.FINE, "Error code out of range in response : " + code);
                        }
                        return null;
                    }
                    message = new SipServletResponseImpl(null, "SIP/2.0", code, phrase);
                    message.setLocal(local);
                    message.setRemote(remote);
                    continue;
                }
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "The URI is not a request nor a response!");
                }
                return null;
            }
            catch (Exception e) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Error in parser = ", e);
                }
                return null;
            }
        }
        if (message == null) {
            return null;
        }
        if (cnt < limit && !message.isHeadersComplete()) {
            Header header = null;
            int quoteCnt = 0;
            boolean startToken = true;
            int position = bb.position();
            boolean incrCnt = true;
            while (cnt < limit) {
                incrCnt = true;
                if (bs[cnt + offset] == 58 && header == null) {
                    if (cnt - position < 1) {
                        if (errorHandler != null) {
                            errorHandler.handleError((SipServletRequestImpl)message, 400, "Malformed header");
                        }
                        return null;
                    }
                    header = Header.create(bs, position + offset, cnt - position, message);
                    position = cnt + 1;
                    startToken = true;
                } else if (startToken && (bs[cnt + offset] == 32 || bs[cnt + offset] == 9)) {
                    position = cnt + 1;
                } else if (bs[cnt + offset] == 34) {
                    ++quoteCnt;
                } else if (bs[cnt + offset] == 44 && quoteCnt % 2 == 0 && header != null) {
                    if (!(header == null || header._singleLine || cnt - position == 3 && cnt + 1 < limit && bs[cnt + 1 + offset] == 32)) {
                        header.setValue(new String(bs, position + offset, cnt - position, "UTF-8"), false);
                        header.setIsNextValueOnSameLine(true, false);
                        position = ++cnt;
                        while (cnt < limit && bs[cnt + offset] == 32) {
                            position = ++cnt;
                        }
                        if (header._singleLine && this.log.isLoggable(Level.INFO)) {
                            this.log.log(Level.INFO, "SingleLineHeader " + header.getName() + " is parsed as multiline header with a separator ',' ");
                            if (this.log.isLoggable(Level.FINE)) {
                                this.log.log(Level.FINE, "The SingleLineHeader value : " + header.getValue() + " will be overwritten!");
                            }
                        }
                    }
                } else if (cnt + 1 < limit && bs[cnt + offset] == 13 && bs[cnt + 1 + offset] == 10) {
                    int x;
                    ListIterator<String> li;
                    if (header == null) {
                        message.setHeadersComplete(true);
                        position = cnt += 2;
                        bb.position(cnt > limit ? limit : cnt);
                        break;
                    }
                    if (cnt + 3 < limit && bs[cnt + 2 + offset] == 13 && bs[cnt + 3 + offset] == 10) {
                        header.setValue(new String(bs, position + offset, cnt - position, "UTF-8"), false);
                        header.setIsNextValueOnSameLine(false, false);
                        message.addHeader(header);
                        message.setHeadersComplete(true);
                        bb.position((cnt += 4) > limit ? limit : cnt);
                        if (this.log.isLoggable(Level.FINE)) {
                            if (header._singleLine) {
                                this.log.log(Level.FINE, "Adding Header " + header.getName() + " = " + header.getValue() + " (" + bb.position() + ')');
                            } else {
                                li = header.getValues();
                                x = 0;
                                while (li.hasNext()) {
                                    this.log.log(Level.FINE, "Adding Header " + header.getName() + " = " + li.next() + " (" + bb.position() + ')' + '<' + ++x + '>');
                                }
                            }
                        }
                        header = null;
                        quoteCnt = 0;
                        position = cnt;
                        break;
                    }
                    if (cnt + 2 < limit && (bs[cnt + 2] == 32 || bs[cnt + 2] == 9)) {
                        bs[cnt + offset] = 32;
                        bs[cnt + 1 + offset] = 32;
                        bs[cnt + 2 + offset] = 32;
                        cnt += 3;
                    } else if (header != null) {
                        header.setValue(new String(bs, position + offset, cnt - position, "UTF-8"), false);
                        header.setIsNextValueOnSameLine(false, false);
                        message.addHeader(header);
                        bb.position((cnt += 2) > limit ? limit : cnt);
                        if (this.log.isLoggable(Level.FINE)) {
                            if (header._singleLine) {
                                this.log.log(Level.FINE, "Adding Header " + header.getName() + " = " + header.getValue() + " (" + bb.position() + ')');
                            } else {
                                li = header.getValues();
                                x = 0;
                                while (li.hasNext()) {
                                    this.log.log(Level.FINE, "Adding Header " + header.getName() + " = " + li.next() + " (" + bb.position() + ')' + '<' + ++x + '>');
                                }
                            }
                        }
                        header = null;
                        quoteCnt = 0;
                        startToken = true;
                        incrCnt = false;
                    }
                    position = cnt;
                } else if (startToken) {
                    startToken = false;
                }
                if (!incrCnt) continue;
                ++cnt;
            }
        }
        if (message.isHeadersComplete() && !message.isMessageComplete()) {
            int contentLength;
            long endTime;
            String errorStr = null;
            Header header = message.getRawHeader("Call-Id");
            if (header == null || header.getValue() == null || header.getValue().length() == 0) {
                errorStr = "Failed to validate mandatory header CallId";
            }
            if ((header = message.getRawHeader("To")) == null || header.getValue() == null || header.getValue().length() == 0) {
                errorStr = "Failed to validate mandatory header To";
            }
            if (message.getMessageType() == SipServletMessageImpl.SipMessageType.SipRequest) {
                try {
                    if (header.getAddressValue().getParameter("tag") == null) {
                        ((SipServletRequestImpl)message).setInitial(true);
                    }
                }
                catch (ServletParseException ignore) {
                    errorStr = "To header not formated as a name address!";
                }
            }
            if ((header = message.getRawHeader("From")) == null || header.getValue() == null || header.getValue().length() == 0) {
                errorStr = "Failed to validate mandatory header From";
            }
            if ((header = message.getRawHeader("Cseq")) == null || header.getValue() == null || header.getValue().length() == 0) {
                errorStr = "Failed to validate mandatory header Cseq";
            }
            if ((header = message.getRawHeader("Via")) == null || header.getValue() == null || header.getValue().length() == 0) {
                errorStr = "Failed to validate mandatory header Via";
            }
            if (((header = message.getRawHeader("Max-Forwards")) == null || header.getValue() == null) && message.getMessageType() == SipServletMessageImpl.SipMessageType.SipRequest) {
                Header mf = Header.createFormated("Max-Forwards", message);
                mf.setValue("70", false);
                message.setHeader(mf);
                if (this.log.isLoggable(Level.INFO)) {
                    this.log.log(Level.INFO, "Added Max-Forwards = 70");
                }
            }
            if (errorStr != null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, errorStr + " \r\n" + message);
                }
                return null;
            }
            if (this.log.isLoggable(Level.FINE)) {
                endTime = System.nanoTime();
                this.log.log(Level.FINE, "Headers = " + (endTime - startTime) / 1000L + "\u00ef\u00bf\u00bds");
            }
            if ((contentLength = message.getContentLengthHeader()) < 0) {
                if (message.getRemote().getProtocol() == SipTransports.UDP_PROT) {
                    contentLength = bb.remaining();
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Assigning missing Content-Length");
                    }
                    message.internalSetContentLength(contentLength);
                } else {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Content length is mandatory for TCP!");
                    }
                    return null;
                }
            }
            boolean contentComplete = false;
            if (contentLength == 0) {
                contentComplete = true;
            }
            if (!contentComplete) {
                int position = bb.position();
                int remaining = bb.remaining();
                int remainingContent = contentLength - message.getContentOffset();
                int bytesToCopy = remainingContent < remaining ? remainingContent : remaining;
                if (bytesToCopy > 0) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.log(Level.FINE, "Copy content bytes:" + bytesToCopy);
                    }
                    message.addContent(bs, position + offset, bytesToCopy);
                    remainingContent = contentLength - message.getContentOffset();
                    if (remainingContent == 0) {
                        contentComplete = true;
                    }
                    if (this.log.isLoggable(Level.FINE) && remainingContent != 0) {
                        this.log.log(Level.FINE, "Content remaining after this chunk:" + remainingContent);
                    }
                    bb.position(position + bytesToCopy);
                }
            }
            if (contentComplete) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.log(Level.FINE, "Message content is complete. --> Message is complete took : ");
                }
                message.setMessageComplete(true);
                if (this.log.isLoggable(Level.FINE)) {
                    endTime = System.nanoTime();
                    this.log.log(Level.FINE, "Total = " + (endTime - startTime) / 1000L + "\u00ef\u00bf\u00bds");
                }
            }
        }
        return message;
    }
}

