/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.container.auth.AuthModule;
import com.ericsson.ssa.dd.ServletMappingCriteria;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.EnumerationConverter;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.LazyParsingException;
import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.NotEqualDialogException;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipListIterator;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.ThreadData;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.ericsson.ssa.utils.ParserHelper;
import com.ericsson.ssa.utils.StringDataSource;
import com.ericsson.ssa.utils.StringOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.sip.Address;
import javax.servlet.sip.Parameterable;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SipServletMessageImpl
implements SipServletMessage,
ServletMappingCriteria,
Externalizable {
    protected static final EnumerationConverter<String> empty = new EnumerationConverter();
    private static ThreadLocal<ThreadData> _tlData = new ThreadLocal();
    protected SipFactoryImpl _sf = SipFactoryImpl.getInstance();
    protected SipSessionBase _session = null;
    protected String _method = "";
    protected String _protocol;
    protected String _default_enc;
    protected String _content_enc = this._default_enc = "UTF8";
    protected byte[] _content_byte = null;
    protected Object _content_obj = null;
    protected Map<String, Object> attrib = null;
    protected Map<String, Object> systemAttrib = null;
    protected Map<String, Header> headerMap = new HashMap<String, Header>();
    protected List<Dispatcher> _transactionStack = new ArrayList<Dispatcher>();
    protected List<Dispatcher> _applicationStack = new ArrayList<Dispatcher>();
    protected List<String> _roles = new ArrayList<String>();
    protected int _content_byte_offset = 0;
    protected TargetTuple _remote;
    protected InetSocketAddress _local;
    protected PathNode.Type _Type = PathNode.Type.Undefined;
    protected boolean _IsContactIndicated = false;
    protected boolean _headersComplete = false;
    protected boolean _messageComplete = false;
    protected DialogFragment _dialog = null;
    protected boolean _isRedirect = false;
    protected int _fragmentId = 1;
    private Principal _principal = null;
    private String _user = null;
    private X509Certificate[] _clientCert = null;
    private AuthModule _authModule = null;
    protected SipMessageType _messageType;

    public SipServletMessageImpl() {
    }

    public SipServletMessageImpl(String protocol) {
        this._protocol = protocol;
    }

    public SipServletMessageImpl(String method, String protocol) {
        this._protocol = protocol;
        this._method = method;
    }

    public SipMessageType getMessageType() {
        return this._messageType;
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        try {
            output.writeUTF(this._method);
            output.writeUTF(this._protocol);
            if (this._content_byte != null) {
                output.writeInt(this._content_byte.length);
                output.write(this._content_byte);
            } else {
                output.writeInt(0);
            }
            output.writeInt(this.headerMap.size());
            Iterator<String> key = this.headerMap.keySet().iterator();
            Iterator<Header> value = this.headerMap.values().iterator();
            while (key.hasNext()) {
                output.writeUTF(key.next());
                output.writeObject(value.next());
            }
            output.writeObject(this._remote);
            output.writeObject(this._local);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        try {
            this._method = input.readUTF();
            this._protocol = input.readUTF();
            int cbl = input.readInt();
            this._content_byte = new byte[cbl];
            input.read(this._content_byte);
            int hml = input.readInt();
            if (this.headerMap == null) {
                this.headerMap = new HashMap<String, Header>(hml);
            }
            for (int i = 0; i < hml; ++i) {
                String key = input.readUTF();
                Header value = (Header)input.readObject();
                this.headerMap.put(key, value);
            }
            this._remote = (TargetTuple)input.readObject();
            this._local = (InetSocketAddress)input.readObject();
            this._transactionStack = new ArrayList<Dispatcher>();
            this._applicationStack = new ArrayList<Dispatcher>();
            _tlData = new ThreadLocal();
            this._sf = SipFactoryImpl.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PathNode.Type isDirection() {
        block4: {
            if (this._Type != PathNode.Type.Caller && this._Type != PathNode.Type.Callee) {
                try {
                    if (this.getDialog() != null) {
                        this._Type = this.getDialog().isMessageFromCaller(this) ? PathNode.Type.Caller : PathNode.Type.Callee;
                        break block4;
                    }
                    return PathNode.Type.Undefined;
                }
                catch (NotEqualDialogException e) {
                    return PathNode.Type.Undefined;
                }
            }
        }
        return this._Type;
    }

    public void setDirection(PathNode.Type direction) {
        this._Type = direction;
    }

    public Address getFrom() {
        try {
            return this.headerMap.get("From").getAddressValue();
        }
        catch (ServletParseException e) {
            throw new LazyParsingException(400, e.getMessage(), e);
        }
    }

    public Address getTo() {
        try {
            return this.headerMap.get("To").getAddressValue();
        }
        catch (ServletParseException e) {
            throw new LazyParsingException(400, e.getMessage(), e);
        }
    }

    public String createTag(String name) {
        String tag = this._sf.createTag();
        try {
            Address adr = this.headerMap.get(name).getAddressValue();
            ((AddressImpl)adr).setReadOnly(false);
            adr.setParameter("tag", tag);
            ((AddressImpl)adr).setReadOnly(true);
        }
        catch (ServletParseException e) {
            return null;
        }
        return tag;
    }

    public String getMethod() {
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public String getProtocol() {
        return this._protocol;
    }

    public String getHeader(String name) {
        Header header = this.headerMap.get(Header.format(name));
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public ListIterator<String> getHeaders(String name) {
        String pretty = Header.format(name);
        if (this.headerMap.containsKey(pretty)) {
            return this.headerMap.get(pretty).getValues();
        }
        return Collections.EMPTY_LIST.listIterator();
    }

    public Iterator<String> getHeaderNames() {
        return this.headerMap.keySet().iterator();
    }

    public void setHeader(String name, String value) {
        Header header = null;
        String pretty = Header.format(name);
        boolean system = Header.isSystemHeader(pretty, this);
        String crap = "\r\n\t";
        if (value.indexOf(crap) > 0) {
            value = value.replaceAll(crap, "");
        }
        if (system) {
            throw new IllegalArgumentException("You can not modify a system header!");
        }
        if (this.headerMap.containsKey(pretty)) {
            header = this.headerMap.get(pretty);
            header.removeValues();
            header.setValue(value, true);
        } else {
            header = Header.createFormated(pretty, this);
            header.setValue(value, true);
            this.headerMap.put(pretty, header);
        }
    }

    public void addHeader(String name, String value) {
        Header header = null;
        String pretty = Header.format(name);
        boolean system = Header.isSystemHeader(pretty, this);
        if (system) {
            throw new IllegalArgumentException("You can not modify a system header!");
        }
        if (this.headerMap.containsKey(pretty)) {
            header = this.headerMap.get(pretty);
            header.setValue(value, false);
        } else {
            header = Header.createFormated(pretty, this);
            header.setValue(value, false);
            this.headerMap.put(pretty, header);
        }
    }

    public void addHeader(Header header) {
        Header in = this.headerMap.get(header.getName());
        if (in != null) {
            in.merge(header);
        } else {
            this.headerMap.put(header.getName(), header);
        }
    }

    public void setHeader(Header header) {
        this.headerMap.put(header.getName(), header);
    }

    public Header getRawHeader(String header) {
        return this.headerMap.get(header);
    }

    public void removeHeader(String name) {
        String pretty = Header.format(name);
        if (Header.isSystemHeader(pretty, this)) {
            throw new IllegalArgumentException("You can not modify a system header!");
        }
        this.headerMap.remove(name);
    }

    public Address getAddressHeader(String name) throws ServletParseException {
        Header address = this.headerMap.get(Header.format(name));
        if (address == null) {
            return null;
        }
        return address.getAddressValue();
    }

    public ListIterator<Address> getAddressHeaders(String name) throws ServletParseException {
        String pretty = Header.format(name);
        boolean systemHeader = Header.isSystemHeader(pretty, this);
        if (this.headerMap.containsKey(pretty)) {
            return new SipListIterator<Address>(this.headerMap.get(pretty).getAddressValues(), systemHeader);
        }
        Header header = Header.createFormated(pretty, this);
        this.headerMap.put(pretty, header);
        return new SipListIterator<Address>(this.headerMap.get(pretty).getAddressValues(), systemHeader);
    }

    public void setAddressHeader(String name, Address value) {
        Header header = null;
        String pretty = Header.format(name);
        boolean system = Header.isSystemHeader(pretty, this);
        if (system) {
            throw new IllegalArgumentException("You can not modify a system header!");
        }
        if (this.headerMap.containsKey(pretty)) {
            header = this.headerMap.get(pretty);
            header.removeValues();
            header.setAddressValue(value, false);
        } else {
            header = Header.createFormated(pretty, this);
            header.setAddressValue(value, false);
            this.headerMap.put(pretty, header);
        }
    }

    public void addAddressHeader(String name, Address value, boolean first) {
        Header header = null;
        String pretty = Header.format(name);
        boolean system = Header.isSystemHeader(pretty, this);
        if (system) {
            throw new IllegalArgumentException("You can not modify a system header!");
        }
        if (this.headerMap.containsKey(pretty)) {
            header = this.headerMap.get(pretty);
            header.setAddressValue(value, first);
        } else {
            header = Header.createFormated(pretty, this);
            header.setAddressValue(value, first);
            this.headerMap.put(pretty, header);
        }
    }

    public void addParameterableHeader(String name, Parameterable param, boolean first) {
        throw new RuntimeException(" Not yet implemented ");
    }

    public Parameterable getParameterableHeader(String name) throws ServletParseException {
        throw new RuntimeException(" Not yet implemented ");
    }

    public ListIterator<Parameterable> getParameterableHeaders(String name) throws ServletParseException {
        throw new RuntimeException(" Not yet implemented ");
    }

    public void setParameterableHeader(String name, Parameterable param) {
        throw new RuntimeException(" Not yet implemented ");
    }

    public SipServletMessage.HeaderForm getHeaderForm() {
        return SipServletMessage.HeaderForm.DEFAULT;
    }

    public void setHeaderForm(SipServletMessage.HeaderForm form) {
        throw new RuntimeException(" Not yet implemented ");
    }

    public String getCallId() {
        return this.headerMap.get("Call-Id").getValue();
    }

    public int getExpires() {
        Header header = this.headerMap.get("Expires");
        if (header == null) {
            return -1;
        }
        String exp = header.getValue();
        if (exp == null) {
            return -1;
        }
        return Integer.parseInt(exp);
    }

    public void setExpires(int seconds) {
        this.setHeader("Expires", String.valueOf(seconds));
    }

    public String getCharacterEncoding() {
        Header h = this.headerMap.get("Content-Encoding");
        if (h != null) {
            return h.getValue();
        }
        Header sh = this.headerMap.get("Content-Type");
        if (sh != null) {
            String value = sh.getValue();
            if (value != null) {
                this._content_enc = ParserHelper.getValue(value, "charset", ";");
            }
            if (this._content_enc != null) {
                return this._content_enc;
            }
        }
        return null;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        Header h = this.headerMap.get("Content-Type");
        if (h != null) {
            String newEnc = ParserHelper.replaceParam(h.getValue(), "charset", enc, ";", true);
            this.setHeader("Content-Type", newEnc);
            this._content_enc = enc;
        }
    }

    public int getContentLengthHeader() {
        if (this.headerMap.get("Content-Length") == null) {
            return -1;
        }
        return this.getContentLength();
    }

    public int getContentLength() {
        Header header = this.headerMap.get("Content-Length");
        if (header == null) {
            return 0;
        }
        String len = header.getValue();
        if (len == null) {
            return 0;
        }
        return Integer.parseInt(len);
    }

    public int getMessageSize() {
        if (this._content_byte == null && this._content_obj == null) {
            return 0;
        }
        if (this._content_byte != null) {
            return this._content_byte.length;
        }
        if (this._content_obj != null) {
            return this._content_obj.toString().length();
        }
        return 0;
    }

    public String getContentType() {
        if (this._content_byte == null || this._content_byte.length == 0) {
            return null;
        }
        Header h = this.headerMap.get("Content-Type");
        if (h != null) {
            return h.getValue();
        }
        return null;
    }

    public byte[] getRawContent() throws IOException {
        Header sh;
        byte[] bytes = null;
        if ((this._content_byte != null || this._content_obj != null) && (sh = this.headerMap.get("Content-Type")) != null) {
            String newEnc = ParserHelper.getValue(sh.getValue(), "charset", ";");
            if (newEnc != null) {
                this._content_enc = newEnc;
            }
            if (this._content_obj != null) {
                if (this._content_obj instanceof Multipart) {
                    try {
                        ByteArrayOutputStream stream = new ByteArrayOutputStream();
                        ((Multipart)this._content_obj).writeTo((OutputStream)stream);
                        bytes = stream.toByteArray();
                        stream.close();
                    }
                    catch (MessagingException e) {
                        throw new IOException(e.getMessage());
                    }
                } else {
                    String msg = this._content_obj.toString();
                    bytes = msg.getBytes(this._content_enc);
                }
            } else if (this._content_byte != null) {
                return this._content_byte;
            }
        }
        return bytes;
    }

    public Object getContent() throws IOException, UnsupportedEncodingException {
        Object body = null;
        Header h = this.headerMap.get("Content-Type");
        if (h != null) {
            String mediaType = ParserHelper.getFirstToken(h.getValue(), "/");
            String charset = ParserHelper.getValue(h.getValue(), "charset", ";");
            if (this._content_byte != null) {
                if (charset == null && (charset = this._content_enc) == null) {
                    charset = this._default_enc;
                }
                body = "text".equalsIgnoreCase(mediaType) ? this.getContentAsString(charset) : (this._content_obj != null && "multipart".equalsIgnoreCase(mediaType) && this._content_obj instanceof Multipart ? this._content_obj : (Object)this.getRawContent());
            } else if (this._content_obj != null && "multipart".equalsIgnoreCase(mediaType) && this._content_obj instanceof Multipart) {
                body = this._content_obj;
            }
        }
        return body;
    }

    public Object getContent(Class[] classes) throws IOException, UnsupportedEncodingException {
        throw new RuntimeException(" Not yet implemeneted ");
    }

    public void setContent(Object content, String contentType) throws UnsupportedEncodingException {
        if (content == null || contentType == null) {
            throw new NullPointerException("null content");
        }
        int contentLength = -1;
        String mediatype = ParserHelper.getFirstToken(contentType, "/");
        if (mediatype == null) {
            throw new UnsupportedEncodingException("media type not known or null");
        }
        if (mediatype.equalsIgnoreCase("text")) {
            if (content instanceof byte[]) {
                this._content_byte = (byte[])content;
                contentLength = this._content_byte.length;
            } else if (content instanceof String) {
                String encoding = this.getCharacterEncoding();
                if (encoding == null) {
                    encoding = this._default_enc;
                }
                this._content_byte = ((String)content).getBytes(encoding);
                contentLength = this._content_byte.length;
            } else {
                this._content_obj = content.toString();
                contentLength = this._content_obj.toString().length();
            }
        } else if (mediatype.equalsIgnoreCase("multipart")) {
            if (content instanceof Multipart) {
                this._content_obj = content;
                StringBuffer buffer = new StringBuffer();
                StringOutputStream stream = new StringOutputStream(buffer);
                try {
                    ((Multipart)this._content_obj).writeTo((OutputStream)stream);
                    stream.close();
                    contentLength = buffer.length();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e.toString());
                }
                catch (MessagingException e) {
                    throw new IllegalStateException(e.toString());
                }
            } else {
                try {
                    String encoding = this.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = this._default_enc;
                    }
                    contentLength = this.parseMultipart(content, contentType, encoding);
                }
                catch (MessagingException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
        } else if (content instanceof byte[]) {
            this._content_byte = (byte[])content;
            contentLength = this._content_byte.length;
        } else if (content instanceof String) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = this._default_enc;
            }
            this._content_byte = ((String)content).getBytes(encoding);
            contentLength = this._content_byte.length;
        } else {
            throw new IllegalArgumentException("Content object is not supported for this MIME type");
        }
        this.setHeader("Content-Type", contentType);
        if (contentLength > -1) {
            this.setHeader("Content-Length", String.valueOf(contentLength));
        }
    }

    public void setContent(byte[] content) {
        this._content_byte = content;
        try {
            String ctype = this.getContentType();
            if (ctype != null) {
                this.setContent(content, ctype);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public int getContentMaxLength() {
        return 500000;
    }

    public void addContent(byte[] srcBytes, int pos, int length) {
        if (this._content_byte == null) {
            int content_len = this.getContentLengthHeader();
            if (content_len > this.getContentMaxLength()) {
                throw new RuntimeException("Content-length exceeds defined max value:" + this.getContentLengthHeader() + "(" + this.getContentMaxLength() + ")");
            }
            this._content_byte = new byte[this.getContentLengthHeader()];
        }
        System.arraycopy(srcBytes, pos, this._content_byte, this._content_byte_offset, length);
        this._content_byte_offset += length;
    }

    public int getContentOffset() {
        return this._content_byte_offset;
    }

    public void internalSetContentLength(int len) {
        this.setHeader("Content-Length", new Integer(len).toString());
    }

    public void setContentLength(int len) {
        new IllegalStateException("Instead use the setContent method please!");
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public Object getAttribute(String name) {
        if (this.attrib != null) {
            return this.attrib.get(name);
        }
        if (this.systemAttrib != null) {
            return this.systemAttrib.get(name);
        }
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        if (this.attrib != null) {
            return new EnumerationConverter<String>(this.attrib.keySet());
        }
        if (this.systemAttrib != null) {
            return new EnumerationConverter<String>(this.systemAttrib.keySet());
        }
        return empty;
    }

    public void setAttribute(String name, Object o) {
        if (this.attrib == null) {
            this.attrib = this.systemAttrib != null ? new HashMap<String, Object>(this.systemAttrib) : new HashMap<String, Object>(1, 1.0f);
        }
        this.attrib.put(name, o);
    }

    public SipSession getSession() {
        return this.getSession(true);
    }

    public SipSession getSession(boolean create) {
        return this.getSessionImpl();
    }

    public SipApplicationSession getApplicationSession() {
        return this.getApplicationSession(true);
    }

    public SipSessionBase getSessionImpl() {
        return this._session;
    }

    public void setSession(SipSessionBase sessionImpl) {
        this._session = sessionImpl;
    }

    public SipApplicationSession getApplicationSession(boolean create) {
        return this.getApplicationSessionImpl();
    }

    public SipApplicationSessionImpl getApplicationSessionImpl() {
        return this.getSessionImpl().getApplicationSessionImpl();
    }

    public Locale getAcceptLanguage() {
        String val;
        Header al = this.headerMap.get("Accept-Language");
        if (al != null && (val = al.getValue()) != null && val.length() == 2) {
            return new Locale(val);
        }
        return Locale.getDefault();
    }

    public Iterator<Locale> getAcceptLanguages() {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        Header al = this.headerMap.get("Accept-Language");
        if (al != null) {
            ListIterator<String> i = al.getValues();
            while (i.hasNext()) {
                locales.add(new Locale((String)i.next()));
            }
        } else {
            locales.add(Locale.getDefault());
        }
        return locales.iterator();
    }

    public void setAcceptLanguage(Locale locale) {
        if (locale == null) {
            this.headerMap.remove("Accept-Language");
        } else {
            Header al = this.headerMap.get("Accept-Language");
            if (al == null) {
                al = new MultiLineHeader("Accept-Language", false);
                this.headerMap.put("Accept-Language", al);
            } else {
                al.removeValues();
            }
            al.setValue(locale.getLanguage(), false);
        }
    }

    public void addAcceptLanguage(Locale locale) {
        Header al = this.headerMap.get("Accept-Language");
        if (al == null) {
            al = new MultiLineHeader("Accept-Language", false);
            this.headerMap.put("Accept-Language", al);
        }
        al.setValue(locale.getLanguage(), false);
    }

    public void setContentLanguage(Locale locale) {
        this.setHeader("Content-Language", locale.getLanguage());
    }

    public Locale getContentLanguage() {
        String cl = this.getHeader("Content-Language");
        if (cl != null) {
            return new Locale(cl);
        }
        return Locale.getDefault();
    }

    public abstract void send() throws IOException;

    public boolean isSecure() {
        return "TLS".equals(this.getTransport());
    }

    public boolean isCommitted() {
        return false;
    }

    public String getRemoteUser() {
        return this._user;
    }

    public boolean isUserInRole(String role) {
        if (this._authModule == null) {
            return false;
        }
        String servletName = this.getApplicationSessionImpl().getCurrentServlet();
        return this._authModule.hasRoleRefPermission(this._method, servletName);
    }

    public void setRoles(List<String> roles) {
        this._roles = roles;
    }

    public List<String> getRoles() {
        return this._roles;
    }

    public void setRole(String role) {
        this._roles = new ArrayList<String>();
        this._roles.add(role);
    }

    public String popRole() {
        int size;
        if (this._roles != null && (size = this._roles.size()) > 0) {
            return this._roles.remove(size - 1);
        }
        return null;
    }

    public String peekRole() {
        int size = this._roles.size();
        if (size > 0) {
            return this._roles.get(size - 1);
        }
        return null;
    }

    public Principal getUserPrincipal() {
        return this._principal;
    }

    public void setCertificate(X509Certificate[] cert) {
        this._clientCert = cert;
    }

    public X509Certificate[] getCertificate() {
        return this._clientCert;
    }

    public void setRemote(TargetTuple remote) {
        this._remote = remote;
    }

    public TargetTuple getRemote() {
        return this._remote;
    }

    public void setLocal(InetSocketAddress local) {
        this._local = local;
    }

    public InetSocketAddress getLocal() {
        return this._local;
    }

    public String getLocalAddr() {
        if (this._local != null) {
            return this._local.getAddress().toString();
        }
        return null;
    }

    public int getLocalPort() {
        if (this._local != null) {
            return this._local.getPort();
        }
        return -1;
    }

    public String getRemoteAddr() {
        if (this._remote != null) {
            return this._remote.getIP();
        }
        return null;
    }

    public int getRemotePort() {
        if (this._remote != null) {
            return this._remote.getPort();
        }
        return -1;
    }

    public String getTransport() {
        if (this._remote != null) {
            return this._remote.getProtocol().name().toUpperCase();
        }
        return null;
    }

    public boolean hasToTag() {
        return this.getTo().getParameter("tag") != null;
    }

    public boolean isValidMessage() {
        return false;
    }

    public void pushTransactionDispatcher(Dispatcher disp) {
        this._transactionStack.add(disp);
    }

    public void pushApplicationDispatcher(Dispatcher disp) {
        this._applicationStack.add(disp);
    }

    public void clearTransactionDispatchers() {
        this._transactionStack.clear();
    }

    public void clearApplicationDispatchers() {
        this._applicationStack.clear();
    }

    public abstract Dispatcher popDispatcher();

    public abstract Dispatcher peekDispatcher();

    String toDebugString() {
        StringBuilder sb = new StringBuilder("Call-ID: ");
        sb.append(this.headerMap.get("Call-Id").getValue());
        sb.append(" To-tag: ");
        try {
            sb.append(this.headerMap.get("To").getAddressValue().getParameter("tag"));
        }
        catch (Exception e) {
            sb.append("undefined");
        }
        sb.append(" From-tag: ");
        try {
            sb.append(this.headerMap.get("From").getAddressValue().getParameter("tag"));
        }
        catch (Exception e) {
            sb.append("undefined");
        }
        sb.append(" CSeq: ");
        sb.append(this.headerMap.get("Cseq").getValue());
        return sb.toString();
    }

    public void setSent(boolean hasSent) {
        ThreadData threadData = new ThreadData();
        threadData.setSent(new Boolean(hasSent));
        if (this.getSessionImpl() != null) {
            threadData.setSipApplicationSessionImpl(this.getSessionImpl().getApplicationSessionImpl());
        }
        _tlData.set(threadData);
    }

    public boolean hasSent() {
        ThreadData threadData = _tlData.get();
        if (threadData == null) {
            return false;
        }
        Boolean sent = threadData.getSent();
        if (sent == null) {
            return false;
        }
        return threadData.getSent();
    }

    public static ThreadData getThreadLocalData() {
        return _tlData.get();
    }

    public static void removeThreadLocalData() {
        _tlData.remove();
    }

    public void indicateContact() {
        this._IsContactIndicated = true;
    }

    public boolean isContactIndicated() {
        return this._IsContactIndicated;
    }

    private int parseMultipart(Object content, String contentType, String charSet) throws UnsupportedEncodingException, MessagingException {
        String multipart = null;
        if (content instanceof byte[]) {
            multipart = new String((byte[])content, charSet);
        } else if (content instanceof String) {
            multipart = (String)content;
        } else {
            throw new IllegalArgumentException("Content object needs to be a Multipart object or a byte[] or a String for MIME multipart type");
        }
        this._content_obj = new MimeMultipart((DataSource)new StringDataSource(multipart, contentType, charSet));
        return multipart.length();
    }

    private String getContentAsString(String charSet) {
        if (this._content_obj != null) {
            return this._content_obj.toString();
        }
        if (this._content_byte != null) {
            try {
                return new String(this._content_byte, charSet);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("Unsupported encoding " + e);
            }
        }
        return null;
    }

    public boolean isHeadersComplete() {
        return this._headersComplete;
    }

    public void setHeadersComplete(boolean complete) {
        this._headersComplete = complete;
    }

    public boolean isMessageComplete() {
        return this._messageComplete;
    }

    public void setMessageComplete(boolean complete) {
        this._messageComplete = complete;
        String ctype = this.getContentType();
        if (ctype != null) {
            try {
                this.setContent(this._content_byte, ctype);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public DialogFragment getDialog() {
        return this._dialog;
    }

    public void setDialog(DialogFragment dialog) {
        this._dialog = dialog;
    }

    public int getFragmentId() {
        return this._fragmentId;
    }

    public void addInternalHeader(String name, String value) {
        Header header = null;
        String pretty = Header.format(name);
        if (this.headerMap.containsKey(pretty)) {
            header = this.headerMap.get(pretty);
            header.removeValues();
            header.setValue(value, true);
        } else {
            header = Header.createFormated(pretty, this);
            header.setValue(value, true);
            this.headerMap.put(pretty, header);
        }
    }

    public boolean hasBody() {
        return this._content_byte != null || this._content_obj != null;
    }

    public int getCSeqNumber() throws NumberFormatException {
        int posStop;
        int posStart;
        String CSeq = this.getHeader("CSeq");
        if (CSeq == null) {
            throw new NumberFormatException("Could not extract CSeq number from message.");
        }
        for (posStart = 0; CSeq.charAt(posStart) == ' ' && posStart < CSeq.length(); ++posStart) {
        }
        for (posStop = posStart; Character.isDigit(CSeq.charAt(posStop)) && posStop < CSeq.length(); ++posStop) {
        }
        if (posStop >= CSeq.length()) {
            throw new NumberFormatException("Could not extract CSeq number from message.");
        }
        return Integer.parseInt(CSeq.substring(posStart, posStop));
    }

    public boolean isRedirect() {
        return this._isRedirect;
    }

    public void setRedirect() {
        this._isRedirect = true;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public void setUserPrincipal(Principal value) {
        this._principal = value;
    }

    public abstract ByteBuffer toBuffer(ByteBuffer var1) throws UnsupportedEncodingException;

    public void setAuthModule(AuthModule module) {
        this._authModule = module;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SipMessageType {
        SipRequest,
        SipResponse;

    }
}

