/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.LayerHandler;
import com.ericsson.ssa.sip.AddressImpl;
import com.ericsson.ssa.sip.DialogFragment;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.HeaderRequirement;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SessionManager;
import com.ericsson.ssa.sip.SingleLineHeader;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.UA;
import com.ericsson.ssa.sip.ViaImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.sip.Address;
import javax.servlet.sip.Proxy;
import javax.servlet.sip.Rel100Exception;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.SipSession;
import javax.servlet.sip.TooManyHopsException;
import javax.servlet.sip.URI;
import org.jvnet.glassfish.comms.security.auth.impl.AuthHeaderProcessor;

public class SipServletResponseImpl
extends SipServletMessageImpl
implements SipServletResponse,
Serializable {
    public static final String CLIENT_CERT = "javax.servlet.response.X509Certificate";
    private static final long serialVersionUID = 3256728389854769457L;
    private static final int SIZE_ALLHEADERS = 8192;
    private static ThreadLocal<ByteBuffer> _bytebuffer = new ThreadLocal<ByteBuffer>(){

        @Override
        protected synchronized ByteBuffer initialValue() {
            return ByteBuffer.allocate(8192);
        }
    };
    public static final Map<Integer, String> REASON_PHRASE_MAP = new HashMap<Integer, String>();
    private int _statusCode;
    private String _phrase;
    private SipServletRequestImpl _currentRequest;
    private byte[] _byteArr = null;
    protected List<Dispatcher> _retransmission_transactionStack = null;
    private boolean _isAlreadyACKGenerated = false;
    private boolean _reliableProvisionalResponse = false;
    private PathNode _current = null;
    private PathNode _previous = null;
    Header _viaOfCancel = null;
    private SipSessionBase m_SessionToLink = null;
    private boolean _alreadyRedirected = false;

    public SipServletResponseImpl() {
        this._messageType = SipServletMessageImpl.SipMessageType.SipResponse;
    }

    public SipServletResponseImpl(SipServletRequestImpl originalRequest, String protocol, int code) {
        super(protocol);
        this._messageType = SipServletMessageImpl.SipMessageType.SipResponse;
        this._statusCode = code;
        this._phrase = REASON_PHRASE_MAP.get(new Integer(code));
        this._currentRequest = originalRequest;
        if (this._phrase == null) {
            int defaultCode = code / 100;
            switch (defaultCode) {
                case 1: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(100));
                    break;
                }
                case 2: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(200));
                    break;
                }
                case 3: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(300));
                    break;
                }
                case 4: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(400));
                    break;
                }
                case 5: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(500));
                    break;
                }
                case 6: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(600));
                    break;
                }
                default: {
                    this._phrase = REASON_PHRASE_MAP.get(new Integer(500));
                }
            }
        }
    }

    public SipServletResponseImpl(SipServletRequestImpl originalRequest, String protocol, int code, String phrase) {
        super(protocol);
        this._messageType = SipServletMessageImpl.SipMessageType.SipResponse;
        this._statusCode = code;
        this._phrase = phrase;
        this._currentRequest = originalRequest;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            ByteBuffer bb = _bytebuffer.get();
            if (bb != null && bb.limit() > 0) {
                stream.writeBoolean(true);
                stream.writeObject(bb);
                stream.writeObject(this._local);
                stream.writeObject(this._remote);
            } else {
                stream.writeBoolean(false);
                stream.defaultWriteObject();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        try {
            boolean compact = stream.readBoolean();
            if (compact) {
                _bytebuffer.set((ByteBuffer)stream.readObject());
                this._local = (InetSocketAddress)stream.readObject();
                this._remote = (TargetTuple)stream.readObject();
            } else {
                stream.defaultReadObject();
            }
            this._transactionStack = new ArrayList();
            this._applicationStack = new ArrayList();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isAlreadyRedirected() {
        return this._alreadyRedirected;
    }

    public void setAlreadyRedirected() {
        if (this.getStatus() / 100 == 3) {
            this._alreadyRedirected = true;
        }
    }

    public SipServletRequest getRequest() {
        return this.getRequestImpl();
    }

    public SipServletRequestImpl getRequestImpl() {
        return this._currentRequest;
    }

    public void setRequest(SipServletRequestImpl request) {
        this._currentRequest = request;
    }

    public String getMethod() {
        String s = super.getMethod();
        if (!s.equals("")) {
            return s;
        }
        if (this._currentRequest != null) {
            return this._currentRequest.getMethod();
        }
        return "";
    }

    public int getStatus() {
        return this._statusCode;
    }

    public void setStatus(int code) {
        this._statusCode = code;
    }

    public void setStatus(int code, String phrase) {
        this._statusCode = code;
        this._phrase = phrase;
    }

    public String getReasonPhrase() {
        return this._phrase;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return null;
    }

    public PrintWriter getWriter() throws IOException {
        return null;
    }

    public Proxy getProxy() {
        Proxy p = null;
        try {
            p = this.getRequest().getProxy();
        }
        catch (TooManyHopsException tooManyHopsException) {
            // empty catch block
        }
        return p;
    }

    public void sendReliably() throws Rel100Exception {
        String headerValue;
        if (!this.getRequestImpl().getMethod().equals("INVITE")) {
            throw new Rel100Exception(1);
        }
        if (this.getStatus() < 101 || this.getStatus() > 199) {
            throw new Rel100Exception(0);
        }
        boolean rel100supported = false;
        ListIterator<String> lIterator = this.getRequestImpl().getHeaders("Require");
        while (lIterator.hasNext()) {
            headerValue = lIterator.next();
            if (!headerValue.equalsIgnoreCase("100rel")) continue;
            rel100supported = true;
        }
        lIterator = this.getRequestImpl().getHeaders("Supported");
        while (lIterator.hasNext()) {
            headerValue = lIterator.next();
            if (!headerValue.equalsIgnoreCase("100rel")) continue;
            rel100supported = true;
        }
        if (!rel100supported) {
            throw new Rel100Exception(2);
        }
        if (!this.getSessionImpl().set1xxReliableOngoing(this.getContentLength() != 0)) {
            throw new Rel100Exception(3);
        }
        this.setReliableProvisionalResponse(true);
        this.setHeader("Require", "100rel");
        SingleLineHeader rseq = new SingleLineHeader("Rseq", true);
        ((Header)rseq).setValue(Integer.toString(this.getRequestImpl().getAndIncrementRSeq()), true);
        this.setHeader(rseq);
        try {
            this.sendInternal();
        }
        catch (IOException e) {
            this.getSessionImpl().reset1xxReliable();
            throw new IllegalStateException("Problem while sending response.", e);
        }
    }

    private boolean isLocallyCreated() {
        if (this.getDialog().getToTag() == null) {
            return true;
        }
        return !this._currentRequest.getFrom().equals(this.getSessionImpl().getLocalParty());
    }

    public SipServletRequest createAck() throws IllegalStateException {
        if (this._currentRequest.getMethod().equals("INVITE") && this._statusCode > 199 && !this._isAlreadyACKGenerated && !this.isLocallyCreated()) {
            this._isAlreadyACKGenerated = true;
            return this.createAckImpl();
        }
        throw new IllegalStateException("Not allowed to create an ACK at this transaction state.");
    }

    public SipServletRequest createPrack() {
        throw new RuntimeException(" Not yet implemenetd ");
    }

    public SipServletRequestImpl createHopAckImpl(SipServletRequestImpl req) throws IllegalStateException {
        if (this._currentRequest.getMethod().equals("INVITE") && this._statusCode > 199 && !this._isAlreadyACKGenerated) {
            this._isAlreadyACKGenerated = true;
            Address fromCopy = (Address)((AddressImpl)this.getFrom()).clone(true, true);
            Address toCopy = (Address)((AddressImpl)this.getTo()).clone(true, true);
            SipServletRequestImpl ack = new SipServletRequestImpl("ACK", req.getRequestURI(), "SIP/2.0");
            SingleLineHeader toHeader = new SingleLineHeader("To", true);
            ((Header)toHeader).setAddressValue(toCopy, false);
            ack.setHeader(toHeader);
            SingleLineHeader fromHeader = new SingleLineHeader("From", true);
            ((Header)fromHeader).setAddressValue(fromCopy, false);
            ack.setHeader(fromHeader);
            SingleLineHeader maxForwardsHeader = new SingleLineHeader("Max-Forwards", false);
            ((Header)maxForwardsHeader).setValue("70", false);
            ack.setHeader(maxForwardsHeader);
            SingleLineHeader callIDHeader = new SingleLineHeader("Call-Id", true);
            ((Header)callIDHeader).setValue(this.getCallId(), false);
            ack.setHeader(callIDHeader);
            SingleLineHeader cSeqHeader = new SingleLineHeader("Cseq", true);
            ((Header)cSeqHeader).setValue(Integer.toString(this.getCSeqNumber()) + " ACK", false);
            ack.setHeader(cSeqHeader);
            ViaImpl v = new ViaImpl(req.getHeader("Via"));
            MultiLineHeader via = new MultiLineHeader("Via", true);
            ((Header)via).setValue(v.toString(), true);
            ack.setHeader(via);
            ack.setRemote(req.getRemote());
            ack.setInitial(false);
            Header rawRoute = req.getRawHeader("Route");
            if (rawRoute != null) {
                Header route = (Header)rawRoute.clone();
                ack.setHeader(route);
            }
            return ack;
        }
        throw new IllegalStateException("Not allowed to create an ACK in this transaction state.");
    }

    public SipServletRequestImpl createAckImpl() throws IllegalStateException {
        Address fromCopy = (Address)((AddressImpl)this.getFrom()).clone(true, true);
        Address toCopy = (Address)((AddressImpl)this.getTo()).clone(true, true);
        DialogFragment df = this.getDialog();
        UA uac = null;
        if (this.isDirection() == PathNode.Type.Caller) {
            uac = (UA)df.getFirst();
        } else if (this.isDirection() == PathNode.Type.Callee) {
            uac = (UA)df.getLast();
        } else {
            throw new IllegalStateException("Don't know the direction of the flow.");
        }
        URI remoteTarget = uac.getRemoteTarget();
        if (remoteTarget == null) {
            try {
                Address contact = this.getAddressHeader("Contact");
                if (contact == null) {
                    throw new IllegalStateException("Missing Contact header field");
                }
                remoteTarget = this.getAddressHeader("Contact").getURI();
            }
            catch (ServletParseException e) {
                throw new IllegalStateException(e);
            }
        }
        SipServletRequestImpl req = new SipServletRequestImpl("ACK", remoteTarget, "SIP/2.0");
        SingleLineHeader toHeader = new SingleLineHeader("To", true);
        ((Header)toHeader).setAddressValue(toCopy, false);
        req.setHeader(toHeader);
        SingleLineHeader fromHeader = new SingleLineHeader("From", true);
        ((Header)fromHeader).setAddressValue(fromCopy, false);
        req.setHeader(fromHeader);
        SingleLineHeader maxForwardsHeader = new SingleLineHeader("Max-Forwards", false);
        ((Header)maxForwardsHeader).setValue("70", false);
        req.setHeader(maxForwardsHeader);
        SingleLineHeader callIDHeader = new SingleLineHeader("Call-Id", true);
        ((Header)callIDHeader).setValue(this.getCallId(), false);
        req.setHeader(callIDHeader);
        SingleLineHeader cSeqHeader = new SingleLineHeader("Cseq", true);
        ((Header)cSeqHeader).setValue(Integer.toString(this.getCSeqNumber()) + " ACK", false);
        req.setHeader(cSeqHeader);
        req.setSession(this.getSessionImpl());
        req.setDialog(this.getDialog());
        req.setDirection(this.isDirection());
        req.setInitial(false);
        List<Layer> layers = LayerHandler.getInstance().getLayers();
        req._applicationStack.addAll(layers);
        return req;
    }

    public void setCharacterEncoding(String arg0) {
    }

    public void setBufferSize(int arg0) {
    }

    public int getBufferSize() {
        return 0;
    }

    public void flushBuffer() throws IOException {
    }

    public void resetBuffer() {
    }

    public void reset() {
    }

    public void setLocale(Locale arg0) {
    }

    public Locale getLocale() {
        return null;
    }

    public void restoreRetransmissionTransactionStack() {
        this._transactionStack = new ArrayList<Dispatcher>(this._retransmission_transactionStack);
    }

    public void serializeForTransmission() throws UnsupportedEncodingException {
        this._applicationStack.clear();
        this._retransmission_transactionStack = new ArrayList<Dispatcher>(this._transactionStack);
        ByteBuffer theByteBuf = null;
        theByteBuf = _bytebuffer.get();
        theByteBuf.clear();
        this.toBuffer(theByteBuf);
        this._byteArr = new byte[theByteBuf.position()];
        theByteBuf.flip();
        theByteBuf.get(this._byteArr);
    }

    public void copyTransactionStack() {
        if (this._currentRequest != null) {
            this._transactionStack.addAll(this._currentRequest._transactionStack);
        }
    }

    public Object clone() {
        SipServletResponseImpl clone = new SipServletResponseImpl(this._currentRequest, this.getProtocol(), this.getStatus(), this.getReasonPhrase());
        for (Header next : this.headerMap.values()) {
            clone.headerMap.put(next.getName(), (Header)next.clone());
        }
        if (this.attrib != null) {
            clone.attrib = this.systemAttrib != null ? new HashMap(this.systemAttrib) : new HashMap(this.attrib.size());
            clone.attrib.putAll(this.attrib);
        }
        if (this.systemAttrib != null) {
            clone.systemAttrib = new HashMap(this.systemAttrib.size());
            clone.systemAttrib.putAll(this.systemAttrib);
        }
        clone._reliableProvisionalResponse = this._reliableProvisionalResponse;
        clone._content_enc = this._content_enc;
        clone._content_byte = this._content_byte;
        clone._content_obj = this._content_obj;
        clone._roles = this._roles;
        clone._remote = this._remote;
        clone._local = this._local;
        clone._session = this._session;
        clone._dialog = this._dialog;
        clone._isRedirect = this._isRedirect;
        clone._method = this._method;
        clone._sf = this._sf;
        clone._headersComplete = this._headersComplete;
        clone._messageComplete = this._messageComplete;
        clone._current = this._current;
        clone._previous = this._previous;
        clone._viaOfCancel = this._viaOfCancel;
        clone.setDirection(this.isDirection());
        if (this._transactionStack != null) {
            clone._transactionStack.addAll(this._transactionStack);
        }
        return clone;
    }

    public String toString() {
        if (this._byteArr != null) {
            try {
                return new String(this._byteArr, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        StringBuilder sb = new StringBuilder("SIP/2.0");
        sb.append(' ');
        sb.append(this._statusCode);
        sb.append(' ');
        sb.append(this._phrase);
        sb.append("\r\n");
        Iterator i = this.headerMap.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next());
        }
        if (!this.headerMap.containsKey("Content-Length")) {
            int length = 0;
            if (this._content_byte != null && this._content_byte.length > 0) {
                length = this._content_byte.length;
            }
            SingleLineHeader cl = new SingleLineHeader("Content-Length", false);
            ((Header)cl).setValue(String.valueOf(length), false);
            this.headerMap.put("Content-Length", cl);
            sb.append(((Object)cl).toString());
        }
        sb.append("\r\n");
        if (this._content_byte != null && this._content_byte.length > 0) {
            sb.append(this._content_byte);
        }
        return sb.toString();
    }

    public ByteBuffer toBuffer() throws UnsupportedEncodingException {
        if (this._byteArr == null) {
            this.serializeForTransmission();
        }
        ByteBuffer buf = ByteBuffer.wrap(this._byteArr);
        buf.position(buf.limit());
        return buf;
    }

    public ByteBuffer toBuffer(ByteBuffer bb) throws UnsupportedEncodingException {
        if (this._byteArr != null) {
            bb.put(this._byteArr);
            return bb;
        }
        bb.put("SIP/2.0".getBytes());
        bb.put((byte)32);
        bb.put(String.valueOf(this._statusCode).getBytes());
        bb.put((byte)32);
        bb.put(this._phrase.getBytes("UTF-8"));
        bb.put("\r\n".getBytes());
        Iterator i = this.headerMap.values().iterator();
        while (i.hasNext()) {
            bb.put(((Header)i.next()).toString().getBytes("UTF-8"));
        }
        if (!this.headerMap.containsKey("Content-Length")) {
            int length = 0;
            if (this._content_byte != null && this._content_byte.length > 0) {
                length = this._content_byte.length;
            }
            SingleLineHeader cl = new SingleLineHeader("Content-Length", false);
            ((Header)cl).setValue(String.valueOf(length), false);
            this.headerMap.put("Content-Length", cl);
            bb.put(((Object)cl).toString().getBytes());
        }
        bb.put("\r\n".getBytes());
        if (this._content_byte != null && this._content_byte.length > 0) {
            bb.put(this._content_byte);
        }
        return bb;
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder(Integer.toString(this._statusCode));
        sb.append(" ");
        sb.append(this._phrase);
        sb.append(" ");
        if (this._byteArr == null) {
            sb.append(super.toDebugString());
        } else {
            sb.append("BLOB");
        }
        return sb.toString();
    }

    public void send() throws IOException {
        if (this.getRequestImpl().getMethod().equals("INVITE")) {
            if (this.getStatus() > 100 && this.getStatus() < 200) {
                ListIterator<String> lIterator = this.getRequestImpl().getHeaders("Require");
                while (lIterator.hasNext()) {
                    String headerValue = lIterator.next();
                    if (!headerValue.equalsIgnoreCase("100rel")) continue;
                    throw new IllegalStateException("Request with Require header 100rel, Provisional Response must be sent reliable");
                }
            } else if (this.getStatus() == 200 && this.getSessionImpl().is1xxReliableSDP()) {
                throw new IllegalStateException("Final response not allowed, 1XX reliable response with SDP ongoing RFC3262");
            }
        }
        this.sendInternal();
    }

    private void startVirtualProxyBranch() throws IOException {
        if (this._currentRequest.isInitial() && this._currentRequest.getProxyContext() != null) {
            this._currentRequest.getProxyContext().getProxy().startVirtualProxyBranch(this);
            this.pushTransactionDispatcher(this._currentRequest.getProxyContext());
            if (SipFactoryImpl.getContactRequirement(this) != HeaderRequirement.NOT_APPLICAPLE) {
                Header contact = this.getRawHeader("Contact");
                contact.setReadOnly(false);
                contact.removeValues();
                SessionManager.getInstance().addContact(this);
            }
        }
    }

    private void loadVirtualProxyBranch() throws IOException {
        if (this._currentRequest.isInitial() && this._currentRequest.getProxyContext() != null) {
            this.pushTransactionDispatcher(this._currentRequest.getProxyContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendInternal() throws IOException {
        PathNode uas = null;
        if (this.getRequest().isInitial() && !this._currentRequest.isInApplicationPath()) {
            SipServletRequestImpl sipServletRequestImpl = this._currentRequest;
            synchronized (sipServletRequestImpl) {
                if (!this._currentRequest.isInApplicationPath()) {
                    this.startVirtualProxyBranch();
                    uas = new UA(this.getApplicationSessionImpl(), false);
                    this.getDialog().addToPath(uas);
                    this._currentRequest.setInApplicationPath(true);
                    this.setCurrentVisited(uas);
                } else {
                    uas = this.getDialog().getLast();
                    this.setCurrentVisited(uas);
                }
                this.setSent(true);
            }
        } else {
            this.loadVirtualProxyBranch();
            if (this.isDirection() == PathNode.Type.Caller) {
                uas = this.getDialog().getLast();
            } else if (this.isDirection() == PathNode.Type.Callee) {
                uas = this.getDialog().getFirst();
            } else {
                throw new IOException("Don't know the direction of the flow.");
            }
        }
        if (this._statusCode > 199 && this._statusCode < 700) {
            this._currentRequest.setSentFinalResponse(this._statusCode);
        }
        uas.send(this);
    }

    public void setCertificate(X509Certificate[] cert) {
        super.setCertificate(cert);
        if (this.systemAttrib == null) {
            this.systemAttrib = new HashMap();
        }
        this.systemAttrib.put(CLIENT_CERT, cert);
    }

    public String getSessionCase() {
        return null;
    }

    public void setSessionCase(String sessionCase) {
    }

    public Header getCancelVia() {
        return this._viaOfCancel;
    }

    public void setCancelVia(Header via) {
        this._viaOfCancel = via;
    }

    public PathNode getPreviousVisited() {
        return this._previous;
    }

    public PathNode getCurrentVisited() {
        return this._current;
    }

    private void setCurrentVisited(PathNode p) {
        this._current = p;
    }

    public Dispatcher popDispatcher() {
        int size = this._transactionStack.size();
        if (size > 0) {
            Dispatcher d = (Dispatcher)this._transactionStack.remove(size - 1);
            if (this.getRequestImpl() != null && this.getRequestImpl().isInitial() && d instanceof PathNode) {
                this._previous = this._current;
                this._current = (PathNode)d;
            }
            return d;
        }
        return null;
    }

    public Dispatcher peekDispatcher() {
        int size = this._transactionStack.size();
        if (size > 0) {
            return (Dispatcher)this._transactionStack.get(size - 1);
        }
        return null;
    }

    public boolean isReliableProvisionalResponse() {
        return this._reliableProvisionalResponse;
    }

    public void setReliableProvisionalResponse(boolean reliableProvisionalResponse) {
        this._reliableProvisionalResponse = reliableProvisionalResponse;
    }

    public SipSessionBase getSessionToLink() {
        return this.m_SessionToLink;
    }

    public void setSessionToLink(SipSessionBase s) {
        this.m_SessionToLink = s;
    }

    public void setSession(SipSessionBase sessionImpl) {
        if (this.getSessionToLink() != null) {
            this.getRequest().getB2buaHelper().linkSipSessions((SipSession)sessionImpl, (SipSession)this.getSessionToLink());
        }
        super.setSession(sessionImpl);
    }

    public String[] getChallengeRealm() {
        if (this.getStatus() == 401) {
            AuthHeaderProcessor ahp = new AuthHeaderProcessor();
            return ahp.getHeaderValues((SipServletMessage)this, "WWW-Authenticate", "Realm");
        }
        if (this.getStatus() == 407) {
            AuthHeaderProcessor ahp = new AuthHeaderProcessor();
            return ahp.getHeaderValues((SipServletMessage)this, "Proxy-Authenticate", "Realm");
        }
        return null;
    }

    static {
        REASON_PHRASE_MAP.put(new Integer(100), "Trying");
        REASON_PHRASE_MAP.put(new Integer(180), "Ringing");
        REASON_PHRASE_MAP.put(new Integer(181), "Call Is Being Forwarded");
        REASON_PHRASE_MAP.put(new Integer(182), "Queued");
        REASON_PHRASE_MAP.put(new Integer(183), "Session Progress");
        REASON_PHRASE_MAP.put(new Integer(200), "OK");
        REASON_PHRASE_MAP.put(new Integer(202), "Accepted");
        REASON_PHRASE_MAP.put(new Integer(300), "Multiple Choices");
        REASON_PHRASE_MAP.put(new Integer(301), "Moved Permanently");
        REASON_PHRASE_MAP.put(new Integer(302), "Moved Temporarily");
        REASON_PHRASE_MAP.put(new Integer(305), "Use Proxy");
        REASON_PHRASE_MAP.put(new Integer(380), "Alternative Service");
        REASON_PHRASE_MAP.put(new Integer(400), "Bad Request");
        REASON_PHRASE_MAP.put(new Integer(401), "Unauthorized");
        REASON_PHRASE_MAP.put(new Integer(402), "Payment Required");
        REASON_PHRASE_MAP.put(new Integer(403), "Forbidden");
        REASON_PHRASE_MAP.put(new Integer(404), "Not Found");
        REASON_PHRASE_MAP.put(new Integer(405), "Method Not Allowed");
        REASON_PHRASE_MAP.put(new Integer(406), "Not Acceptable");
        REASON_PHRASE_MAP.put(new Integer(407), "Proxy Authentication Required");
        REASON_PHRASE_MAP.put(new Integer(408), "Request Timeout");
        REASON_PHRASE_MAP.put(new Integer(410), "Gone");
        REASON_PHRASE_MAP.put(new Integer(412), "Conditional Request Failed");
        REASON_PHRASE_MAP.put(new Integer(413), "Request Entity Too Large");
        REASON_PHRASE_MAP.put(new Integer(414), "Request-URI Too Long");
        REASON_PHRASE_MAP.put(new Integer(415), "Unsupported Media Type");
        REASON_PHRASE_MAP.put(new Integer(416), "Unsupported URI Scheme");
        REASON_PHRASE_MAP.put(new Integer(420), "Bad Extension");
        REASON_PHRASE_MAP.put(new Integer(421), "Extension Required");
        REASON_PHRASE_MAP.put(new Integer(422), "Session Interval Too Small");
        REASON_PHRASE_MAP.put(new Integer(423), "Interval Too Brief");
        REASON_PHRASE_MAP.put(new Integer(480), "Temporarily Unavailable");
        REASON_PHRASE_MAP.put(new Integer(481), "Call/Transaction Does Not Exist");
        REASON_PHRASE_MAP.put(new Integer(482), "Loop Detected");
        REASON_PHRASE_MAP.put(new Integer(483), "Too Many Hops");
        REASON_PHRASE_MAP.put(new Integer(484), "Address Incomplete");
        REASON_PHRASE_MAP.put(new Integer(485), "Ambiguous");
        REASON_PHRASE_MAP.put(new Integer(486), "Busy Here");
        REASON_PHRASE_MAP.put(new Integer(487), "Request Terminated");
        REASON_PHRASE_MAP.put(new Integer(488), "Not Acceptable Here");
        REASON_PHRASE_MAP.put(new Integer(489), "Bad Event");
        REASON_PHRASE_MAP.put(new Integer(491), "Request Pending");
        REASON_PHRASE_MAP.put(new Integer(493), "Undecipherable");
        REASON_PHRASE_MAP.put(new Integer(500), "Server Internal Error");
        REASON_PHRASE_MAP.put(new Integer(501), "Not Implemented");
        REASON_PHRASE_MAP.put(new Integer(502), "Bad Gateway");
        REASON_PHRASE_MAP.put(new Integer(503), "Service Unavailable");
        REASON_PHRASE_MAP.put(new Integer(504), "Server Time-out");
        REASON_PHRASE_MAP.put(new Integer(505), "Version Not Supported");
        REASON_PHRASE_MAP.put(new Integer(513), "Message Too Large");
        REASON_PHRASE_MAP.put(new Integer(600), "Busy Everywhere");
        REASON_PHRASE_MAP.put(new Integer(603), "Decline");
        REASON_PHRASE_MAP.put(new Integer(604), "Does Not Exist Anywhere");
        REASON_PHRASE_MAP.put(new Integer(606), "Not Acceptable");
    }
}

