/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.config.ConvergedContext;
import com.ericsson.ssa.dd.SipApplicationListeners;
import com.ericsson.ssa.sip.DialogSet;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipSessionDialogImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipSessionsUtilImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.sun.enterprise.web.ServerConfigLookup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.sip.Address;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.SipApplicationSessionEvent;
import javax.servlet.sip.SipApplicationSessionListener;
import javax.servlet.sip.TimerListener;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.util.LifecycleSupport;

public class SipSessionManagerBase
implements SipSessionManager,
Lifecycle {
    private static final ConcurrentHashMap<String, SipSessionManager> sipSessionManagers = new ConcurrentHashMap();
    private String instanceName;
    protected SipFactoryImpl sipFactory = null;
    protected boolean started;
    protected boolean initialized;
    protected int sessionTimeout;
    protected ConvergedContext convergedContext;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected Map<String, SipApplicationSessionImpl> applicationSessions = new ConcurrentHashMap<String, SipApplicationSessionImpl>(100, 0.75f, 16);
    protected Map<String, SipSessionDialogImpl> sipSessions = new ConcurrentHashMap<String, SipSessionDialogImpl>();
    protected Map<String, ServletTimerImpl> servletTimers = new ConcurrentHashMap<String, ServletTimerImpl>();
    protected boolean isRepairDuringFailure = true;
    protected SipSessionsUtilImpl sipSessionsUtil = null;

    public SipSessionManagerBase() {
        ServerConfigLookup lookup = new ServerConfigLookup();
        this.instanceName = lookup.getServerName();
    }

    public static void register(SipSessionManager manager) {
        sipSessionManagers.put(manager.getContext().getName(), manager);
    }

    public static void unregister(SipSessionManager manager) {
        sipSessionManagers.remove(manager.getContext().getName());
    }

    public static SipSessionManager get(String contextName) {
        return sipSessionManagers.get(contextName);
    }

    public void setContext(ConvergedContext context) {
        this.convergedContext = context;
    }

    public ConvergedContext getContext() {
        return this.convergedContext;
    }

    public SipApplicationSessionImpl createApplicationSession(SipApplicationListeners sipApplicationListeners) {
        return this.createApplicationSession(null, sipApplicationListeners);
    }

    public SipApplicationSessionImpl createApplicationSession(String id, SipApplicationListeners sipApplicationListeners) {
        SipApplicationSessionImpl sess = null;
        sess = id != null ? this.createNewApplicationSession(id) : this.createNewApplicationSession(UUID.randomUUID().toString());
        if (this.convergedContext != null) {
            sess.setHttpSessionManager(this.convergedContext.getManager());
        }
        this.applicationSessions.put(sess.getId(), sess);
        this.initApplicationSession(sess, sipApplicationListeners);
        return sess;
    }

    public SipApplicationSessionImpl findApplicationSession(String id) {
        return this.applicationSessions.get(id);
    }

    public void removeSession(SipApplicationSessionImpl sas) {
        this.applicationSessions.remove(sas.getId());
        if (this.sipSessionsUtil != null) {
            this.sipSessionsUtil.removeSessionsMapping(sas);
        }
    }

    public void addSession(SipApplicationSessionImpl sas) {
        this.applicationSessions.put(sas.getId(), sas);
    }

    public SipSessionDialogImpl createSipSession(DialogSet set, Address to, SipApplicationSessionImpl appSession, String handler) {
        return this.createSipSession(set, to, appSession, handler, null);
    }

    public SipSessionDialogImpl createSipSession(DialogSet set, Address to, SipApplicationSessionImpl appSession, String handler, PathNode.Type type) {
        SipSessionDialogImpl sess = null;
        sess = type != null ? this.createNewSipSession(set, to, appSession, handler, type) : this.createNewSipSession(set, to, appSession, handler, PathNode.Type.Undefined);
        this.sipSessions.put(sess.getId(), sess);
        return sess;
    }

    public SipSessionDialogImpl findSipSession(String id) {
        return this.sipSessions.get(id);
    }

    public void removeSession(SipSessionDialogImpl sipSession) {
        SipApplicationSessionImpl sas = sipSession.getApplicationSessionImpl();
        if (sas != null) {
            sas.removeSession(sipSession);
        }
        this.sipSessions.remove(sipSession.getId());
    }

    public void addSession(SipSessionDialogImpl sipSession) {
        this.sipSessions.put(sipSession.getId(), sipSession);
    }

    public ServletTimerImpl createServletTimer(SipApplicationSessionImpl sas, Serializable info, long delay, TimerListener listener) {
        ServletTimerImpl timer = new ServletTimerImpl(sas, info, delay, listener);
        this.servletTimers.put(timer.getId(), timer);
        return timer;
    }

    public ServletTimerImpl createServletTimer(SipApplicationSessionImpl sas, Serializable info, long delay, boolean fixedDelay, long period, TimerListener listener) {
        ServletTimerImpl timer = new ServletTimerImpl(sas, info, delay, fixedDelay, period, listener);
        this.servletTimers.put(timer.getId(), timer);
        return timer;
    }

    public ServletTimerImpl findServletTimer(String id) {
        return this.servletTimers.get(id);
    }

    public void removeServletTimer(ServletTimerImpl timer) {
        this.servletTimers.remove(timer.getId());
    }

    public void addServletTimer(ServletTimerImpl timer) {
        this.servletTimers.put(timer.getId(), timer);
    }

    public void setSessionTimeout(int timeout) {
        this.sessionTimeout = timeout;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setRepairDuringFailure(boolean isRepairDuringFailure) {
        this.isRepairDuringFailure = isRepairDuringFailure;
    }

    public boolean isRepairDuringFailure() {
        return this.isRepairDuringFailure;
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            return;
        }
        this.started = true;
        this.sipFactory = SipFactoryImpl.getInstance();
        SipSessionManagerBase.register(this);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("Not started");
        }
        this.started = false;
        SipSessionManagerBase.unregister(this);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    protected SipSessionDialogImpl createNewSipSession(DialogSet set, Address to, SipApplicationSessionImpl appSession, String handler, PathNode.Type type) {
        return new SipSessionDialogImpl(this, set, to, appSession, handler, type);
    }

    protected SipApplicationSessionImpl createNewApplicationSession(String id) {
        return new SipApplicationSessionImpl(this, id);
    }

    public String getPersistenceType() {
        return "memory";
    }

    void setSipSessionsUtil(SipSessionsUtilImpl util) {
        this.sipSessionsUtil = util;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
    }

    private void initApplicationSession(SipApplicationSessionImpl as, SipApplicationListeners sipApplicationListeners) {
        as.setName(this.getContext().getName());
        if (sipApplicationListeners != null) {
            as.setSipApplicationListeners(sipApplicationListeners);
            as.setDefaultSessionTimeout(this.sessionTimeout);
            ArrayList<SipApplicationSessionListener> listeners = as.getSipApplicationListeners().getSipApplicationSessionListeners();
            for (SipApplicationSessionListener list : listeners) {
                list.sessionCreated(new SipApplicationSessionEvent((SipApplicationSession)as));
            }
        }
        as.initAppSessionTimer();
    }
}

