/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.BitSet;

public class SipURIEncoder {
    protected static final char[] hexadecimal;
    protected static final char[] unreserved_mark;
    protected static final char[] user_unreserved;
    protected static final char[] password;
    protected static final char[] token;
    protected static final char[] param_unreserved;
    protected static final char[] hnv_unreserved;
    protected static BitSet userPartSafeCharacters;
    protected static BitSet passwordPartSafeCharacters;
    protected static BitSet parametersSafeCharacters;
    protected static BitSet headersSafeCharacters;

    public String encodeUserPart(String toEncode) {
        return this.encode(toEncode, userPartSafeCharacters);
    }

    public String encodePasswordPart(String toEncode) {
        return this.encode(toEncode, passwordPartSafeCharacters);
    }

    public String encodeParameter(String toEncode) {
        return this.encode(toEncode, parametersSafeCharacters);
    }

    public String encodeHeader(String toEncode) {
        return this.encode(toEncode, headersSafeCharacters);
    }

    private String encode(String path, BitSet safeCharacters) {
        if (path == null) {
            return null;
        }
        int maxBytesPerChar = 10;
        StringBuffer rewrittenPath = new StringBuffer(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    static {
        int i;
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        unreserved_mark = new char[]{'-', '_', '.', '!', '~', '*', '\u00b4', '(', ')'};
        user_unreserved = new char[]{'&', '=', '+', '$', ',', ';', '?', '/'};
        password = new char[]{'&', '=', '+', '$', ','};
        token = new char[]{'-', '.', '!', '%', '*', '_', '+', '`', '\u00b4', '~'};
        param_unreserved = new char[]{'[', ']', '/', ':', '&', '+', '$'};
        hnv_unreserved = new char[]{'[', ']', '/', '?', ':', '+', '$'};
        userPartSafeCharacters = new BitSet(256);
        passwordPartSafeCharacters = new BitSet(256);
        parametersSafeCharacters = new BitSet(256);
        headersSafeCharacters = new BitSet(256);
        for (i = 97; i <= 122; i = (int)((char)(i + 1))) {
            userPartSafeCharacters.set(i);
            passwordPartSafeCharacters.set(i);
            parametersSafeCharacters.set(i);
            headersSafeCharacters.set(i);
        }
        for (i = 65; i <= 90; i = (int)((char)(i + 1))) {
            userPartSafeCharacters.set(i);
            passwordPartSafeCharacters.set(i);
            parametersSafeCharacters.set(i);
            headersSafeCharacters.set(i);
        }
        for (i = 48; i <= 57; i = (int)((char)(i + 1))) {
            userPartSafeCharacters.set(i);
            passwordPartSafeCharacters.set(i);
            parametersSafeCharacters.set(i);
            headersSafeCharacters.set(i);
        }
        for (i = 0; i < unreserved_mark.length; ++i) {
            userPartSafeCharacters.set(unreserved_mark[i]);
            passwordPartSafeCharacters.set(i);
            parametersSafeCharacters.set(i);
            headersSafeCharacters.set(i);
        }
        for (i = 0; i < user_unreserved.length; ++i) {
            userPartSafeCharacters.set(user_unreserved[i]);
        }
        for (i = 0; i < password.length; ++i) {
            passwordPartSafeCharacters.set(password[i]);
        }
        for (i = 0; i < token.length; ++i) {
            parametersSafeCharacters.set(token[i]);
        }
        for (i = 0; i < param_unreserved.length; ++i) {
            parametersSafeCharacters.set(param_unreserved[i]);
        }
        for (i = 0; i < hnv_unreserved.length; ++i) {
            headersSafeCharacters.set(hnv_unreserved[i]);
        }
    }
}

