/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.Ascii7String;
import com.ericsson.ssa.sip.ParameterByteMap;
import com.ericsson.ssa.sip.SipURIDecoder;
import com.ericsson.ssa.sip.SipURIEncoder;
import com.ericsson.ssa.sip.URIImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipURI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SipURIImpl
extends URIImpl
implements SipURI,
Externalizable {
    private static final long serialVersionUID = 3616450094292218936L;
    static String DUPLICATE_PARAM = "The parsed SIP URI has two parameter with the same name : ";
    public static final String LOOSE_ROUTE_PARAM = "lr";
    public static final String MADDR_PARAM = "maddr";
    public static final String METHOD_PARAM = "method";
    public static final String TTL_PARAM = "ttl";
    public static final String TRANSPORT_PARAM = "transport";
    public static final String USER_PARAM = "user";
    public static final String FRAGID_PARAM = "fid";
    private static SipURIDecoder _uriDecoder = new SipURIDecoder();
    private static SipURIEncoder _uriEncoder = new SipURIEncoder();
    private boolean _secure = false;
    private Ascii7String _user = null;
    private Ascii7String _password = null;
    private Ascii7String _host = null;
    private int _port = -1;
    private ParameterByteMap _headers = null;

    public SipURIImpl() {
    }

    public SipURIImpl(boolean secure, String user, String host) {
        this._secure = secure;
        this._user = new Ascii7String(user);
        this._host = new Ascii7String(host);
    }

    public SipURIImpl(String protocol, byte[] bytes, int offset) throws ServletParseException {
        if (protocol.equals("sips")) {
            this._secure = true;
        }
        try {
            this.parse(bytes, offset, bytes.length);
        }
        catch (RuntimeException e) {
            throw new ServletParseException("Unexpected exception while parsing URI: " + e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        try {
            output.writeBoolean(this._secure);
            if (this._user != null) {
                output.writeInt(this._user.length());
                output.write(this._user.getBytes());
            } else {
                output.writeInt(0);
            }
            if (this._password != null) {
                output.writeInt(this._password.length());
                output.write(this._password.getBytes());
            } else {
                output.writeInt(0);
            }
            output.writeUTF(this._host.toString());
            output.writeInt(this._port);
            if (this._parameters != null) {
                byte[] parameter_data = this._parameters.toArray();
                output.writeInt(parameter_data.length);
                output.write(parameter_data);
            }
            if (this._headers != null) {
                byte[] headers_data = this._headers.toArray();
                output.writeInt(headers_data.length);
                output.write(headers_data);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException {
        try {
            byte[] b;
            this._secure = input.readBoolean();
            int len = input.readInt();
            if (len > 0) {
                b = new byte[len];
                input.read(b);
                this._user = new Ascii7String(b);
            }
            if ((len = input.readInt()) > 0) {
                b = new byte[len];
                input.read(b);
                this._password = new Ascii7String(b);
            }
            this._host = new Ascii7String(input.readUTF());
            this._port = input.readInt();
            len = input.readInt();
            byte[] parameter_data = new byte[len];
            int readBytes = input.read(parameter_data, 0, len);
            if (readBytes != len) {
                throw new IOException("failed to read parameter section len:" + len);
            }
            this._parameters = new ParameterByteMap(parameter_data, ';');
            len = input.readInt();
            byte[] headers_data = new byte[len];
            readBytes = input.read(headers_data, 0, len);
            if (readBytes != len) {
                throw new IOException("failed to read headers section len:" + len);
            }
            this._parameters = new ParameterByteMap(headers_data, ';');
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void parse(byte[] bytes, int offset, int length) throws ServletParseException {
        int passwdIndex = -1;
        int portIndex = -1;
        int semiIndex = -1;
        int qIndex = -1;
        int atIndex = -1;
        int endHostIndex = length;
        int endParamIndex = length;
        for (int i = offset; i < length; ++i) {
            if (bytes[i] >= 0 && bytes[i] < 32 || bytes[i] == 127) {
                throw new ServletParseException("The URI contains a control character.");
            }
            if (bytes[i] == 58) {
                if (atIndex > 0) {
                    portIndex = i;
                    continue;
                }
                passwdIndex = i;
                continue;
            }
            if (atIndex == -1 && bytes[i] == 64) {
                atIndex = i;
                continue;
            }
            if (semiIndex == -1 && bytes[i] == 59) {
                semiIndex = i;
                endHostIndex = i;
                continue;
            }
            if (bytes[i] != 63) continue;
            qIndex = i;
            if (semiIndex > 0) {
                endParamIndex = i;
                break;
            }
            endHostIndex = i;
            break;
        }
        if (passwdIndex > 0 && atIndex < 0) {
            portIndex = passwdIndex;
        }
        try {
            try {
                if (atIndex > 0) {
                    if (passwdIndex > 0) {
                        this._user = new Ascii7String(new String(bytes, offset, passwdIndex - offset, "UTF-8"));
                        this._password = new Ascii7String(new String(bytes, passwdIndex + 1, atIndex - (passwdIndex + 1), "UTF-8"));
                    } else {
                        this._user = new Ascii7String(new String(bytes, offset, atIndex - offset, "UTF-8"));
                    }
                    offset = atIndex + 1;
                }
                if (portIndex > 0) {
                    this._host = new Ascii7String(bytes, offset, portIndex - offset, "UTF-8");
                    this._port = Integer.parseInt(new String(bytes, portIndex + 1, endHostIndex - (portIndex + 1), "UTF-8"));
                } else {
                    this._host = new Ascii7String(bytes, offset, endHostIndex - offset, "UTF-8");
                }
            }
            catch (IllegalStateException e) {
                throw new ServletParseException("CharacterCodingException");
            }
            offset = endHostIndex + 1;
            if (semiIndex > 0) {
                int numBytes = endParamIndex - semiIndex;
                this._parameters = new ParameterByteMap(bytes, semiIndex, numBytes, ';');
            }
            if (qIndex > 0) {
                int endIndex = length - 1;
                int numBytes = endIndex - qIndex;
                this._headers = new ParameterByteMap(bytes, qIndex, numBytes + 1, '&');
            }
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
    }

    public String getUser() {
        try {
            if (this._user == null) {
                return null;
            }
            return _uriDecoder.decode(this._user.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setUser(String user) {
        if (user != null) {
            this._user = new Ascii7String(_uriEncoder.encodeUserPart(user));
        }
    }

    public String getUserPassword() {
        try {
            if (this._password == null) {
                return null;
            }
            return _uriDecoder.decode(this._password.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public void setUserPassword(String passwd) {
        if (this._password != null) {
            this._password = new Ascii7String(_uriEncoder.encodePasswordPart(passwd));
        }
    }

    public String getHost() {
        return this._host.toString();
    }

    public void setHost(String host) {
        this._host = new Ascii7String(host);
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        this._port = port < 0 ? -1 : port;
    }

    public boolean isSecure() {
        return this._secure;
    }

    public void setSecure(boolean sec) {
        this._secure = sec;
    }

    public String getTransportParam() {
        return this.getParameter(TRANSPORT_PARAM);
    }

    public void setTransportParam(String value) {
        this.setParameter(TRANSPORT_PARAM, value);
    }

    public String getMAddrParam() {
        return this.getParameter(MADDR_PARAM);
    }

    public void setMAddrParam(String value) {
        this.setParameter(MADDR_PARAM, value);
    }

    public String getMethodParam() {
        return this.getParameter(METHOD_PARAM);
    }

    public void setMethodParam(String value) {
        this.setParameter(METHOD_PARAM, value);
    }

    public int getTTLParam() {
        int ttl = -1;
        String value = this.getParameter(TTL_PARAM);
        if (value != null) {
            try {
                ttl = Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ttl;
    }

    public void setTTLParam(int value) {
        this.setParameter(TTL_PARAM, String.valueOf(value));
    }

    public String getUserParam() {
        return this.getParameter(USER_PARAM);
    }

    public void setUserParam(String value) {
        this.setParameter(USER_PARAM, value);
    }

    public void setLrParam(boolean lr) {
        if (lr) {
            this.setParameter(LOOSE_ROUTE_PARAM, "");
        } else {
            this.removeParameter(LOOSE_ROUTE_PARAM);
        }
    }

    public String getHeader(String header) {
        if (this._headers == null) {
            return null;
        }
        return this._headers.get(header);
    }

    public void setHeader(String header, String value) {
        if (this._headers == null) {
            this._headers = new ParameterByteMap('&');
        }
        this._headers.put(header, value);
    }

    public Iterator<String> getHeaderNames() {
        if (this._headers == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this._headers.getKeys();
    }

    @Override
    public String getScheme() {
        return this._secure ? "sips" : "sip";
    }

    @Override
    public boolean isSipURI() {
        return true;
    }

    @Override
    public Object clone() {
        SipURIImpl newUri = new SipURIImpl();
        newUri._secure = this._secure;
        newUri._user = this._user;
        newUri._password = this._password;
        newUri._host = this._host;
        newUri._port = this._port;
        if (this._parameters != null) {
            newUri._parameters = (ParameterByteMap)this._parameters.clone();
            newUri._parameters.remove("tag");
        }
        if (this._headers != null) {
            newUri._headers = (ParameterByteMap)this._headers.clone();
        }
        return newUri;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SipURIImpl)) {
            return false;
        }
        SipURIImpl uri = (SipURIImpl)o;
        if (this._port != uri._port) {
            return false;
        }
        if (this._secure != uri._secure) {
            return false;
        }
        if (this._user == null && uri._user != null || this._user != null && uri._user == null) {
            return false;
        }
        if (this._user != null && !this.getUser().equals(uri.getUser())) {
            return false;
        }
        if (this._password == null && uri._password != null || this._password != null && uri._password == null) {
            return false;
        }
        if (this._password != null && !this.getUserPassword().equals(uri.getUserPassword())) {
            return false;
        }
        if (!this._host.equalsIgnoreCase(uri._host)) {
            return false;
        }
        if (this._headers == null && uri._headers != null || this._headers != null && uri._headers == null) {
            return false;
        }
        if (this._headers != null && uri._headers != null && !this._headers.equals(uri._headers)) {
            return false;
        }
        if (this._parameters == null && uri._parameters != null && uri._parameters.isOnlySpecialParameters()) {
            return false;
        }
        if (this._parameters != null && uri._parameters == null && this._parameters.isOnlySpecialParameters()) {
            return false;
        }
        return this._parameters == null || uri._parameters == null || this._parameters.equals(uri._parameters);
    }

    public int hashCode() {
        int result = this._host.hashCode() ^ this._port;
        if (this._user != null) {
            result = this._user.hashCode() ^ result;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getScheme());
        sb.append(':');
        if (this._user != null) {
            sb.append(this._user.toString());
            if (this._password != null) {
                sb.append(':');
                sb.append(this._password.toString());
            }
            sb.append('@');
        }
        sb.append(this._host.toString());
        if (this._port > 0) {
            sb.append(':');
            sb.append(this._port);
        }
        if (this._parameters != null) {
            sb.append(this._parameters.toString());
        }
        if (this._headers != null) {
            sb.append('?');
            sb.append(this._headers.toString());
        }
        return sb.toString();
    }

    void removeToTag() {
        if (this._parameters != null) {
            this._parameters.remove("tag");
        }
    }
}

