/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.ParameterByteMap;
import com.ericsson.ssa.sip.URIImpl;
import com.ericsson.ssa.sip.dns.EnumUtil;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.TelURL;

public class TelURLImpl
extends URIImpl
implements TelURL,
Serializable {
    private static final long serialVersionUID = 3690194326332258097L;
    static String NO_NUMBER = "The parsed TEL URL did not cantain any number";
    static String DUPLICATE_PARAM = "The parsed TEL URL has two parameter with the same name : ";
    static String PHONE_CTX_MISSING = "The parsed TEL URL doesn't contain the mandatory parameter phone-context";
    static String PHONE_CONTEXT = "phone-context";
    private static Charset _cs = Charset.forName("UTF-8");
    private static final Logger _logger = Logger.getLogger("SipContainer");
    private boolean _global = false;
    private String _number = null;

    private TelURLImpl() {
    }

    public TelURLImpl(byte[] bytes, int offset) throws ServletParseException {
        ByteBuffer bb = ByteBuffer.wrap(bytes, offset, bytes.length - offset);
        CharBuffer cb = _cs.decode(bb);
        this.parse(cb);
    }

    public String getPhoneNumber() {
        return this._number;
    }

    public void setPhoneNumber(String number) {
        this._number = number;
    }

    public boolean isGlobal() {
        return this._global;
    }

    public Object clone() {
        TelURLImpl uri = new TelURLImpl();
        uri._global = this._global;
        uri._number = this._number;
        uri._parameters = (ParameterByteMap)this._parameters.clone();
        return uri;
    }

    public boolean equals(Object o) {
        String tel2;
        TelURLImpl uri;
        if (o == null) {
            return false;
        }
        try {
            uri = (TelURLImpl)o;
        }
        catch (Exception e) {
            return false;
        }
        if (this._global != uri.isGlobal()) {
            return false;
        }
        String tel1 = EnumUtil.getAUSValue(this._number);
        if (!tel1.equals(tel2 = EnumUtil.getAUSValue(uri.getPhoneNumber()))) {
            return false;
        }
        if (!this._global) {
            ParameterByteMap map1 = (ParameterByteMap)this._parameters.clone();
            ParameterByteMap map2 = (ParameterByteMap)uri._parameters.clone();
            String phoneContext1 = map1.get(PHONE_CONTEXT);
            map1.remove(PHONE_CONTEXT);
            String phoneContext2 = map2.get(PHONE_CONTEXT);
            map2.remove(PHONE_CONTEXT);
            if (phoneContext1.startsWith("+") && phoneContext2.startsWith("+") ? !(phoneContext1 = EnumUtil.getAUSValue(phoneContext1)).equals(phoneContext2 = EnumUtil.getAUSValue(phoneContext2)) : !phoneContext1.equals(phoneContext2)) {
                return false;
            }
            if (!map1.equals(map2)) {
                return false;
            }
        } else if (!this._parameters.equals(uri._parameters)) {
            return false;
        }
        return true;
    }

    private void parse(CharBuffer cb) throws ServletParseException {
        cb.mark();
        char c = '\u0000';
        if (cb.hasRemaining()) {
            c = cb.get();
        }
        if (c == '+') {
            this._global = true;
            cb.mark();
            if (cb.hasRemaining()) {
                c = cb.get();
            }
        }
        CharBuffer rest = null;
        while (cb.hasRemaining()) {
            if (c == ';') {
                rest = cb.slice();
                cb.limit(cb.position() - 1);
                continue;
            }
            c = cb.get();
        }
        cb.reset();
        this._number = cb.toString();
        if (rest != null) {
            String pname = null;
            StringBuilder temp = new StringBuilder();
            StringBuilder pvalue = new StringBuilder();
            while (rest.hasRemaining()) {
                c = rest.get();
                if (c == '=') {
                    pname = temp.toString();
                    continue;
                }
                if (c == ';') {
                    if (this._parameters.get(pname) != null) {
                        throw new ServletParseException(DUPLICATE_PARAM + pname);
                    }
                    this._parameters.put(pname, pvalue.toString());
                    pname = null;
                    temp = new StringBuilder();
                    pvalue = new StringBuilder();
                    continue;
                }
                if (pname == null) {
                    temp.append(c);
                    continue;
                }
                pvalue.append(c);
            }
            if (this._parameters.get(pname) != null) {
                throw new ServletParseException(DUPLICATE_PARAM + pname);
            }
            this._parameters.put(pname, pvalue.toString());
        }
        if (this._number == null || this._number.length() == 0) {
            throw new ServletParseException(NO_NUMBER);
        }
        if (!this._global && this._parameters.get(PHONE_CONTEXT) == null) {
            throw new ServletParseException(PHONE_CTX_MISSING);
        }
    }

    public String getScheme() {
        return "tel";
    }

    public boolean isSipURI() {
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("tel:");
        if (this._global) {
            sb.append('+');
        }
        sb.append(this._number);
        Iterator<String> i = this._parameters.getKeys();
        while (i.hasNext()) {
            String pname = i.next();
            sb.append(';');
            sb.append(pname);
            sb.append('=');
            sb.append(this._parameters.get(pname));
        }
        return sb.toString();
    }
}

