/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.ssa.sip.FSM;
import com.ericsson.ssa.sip.GeneralSession;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.HeaderRequirement;
import com.ericsson.ssa.sip.INVITESession;
import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SUBSCRIBE_REFERSession;
import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.SipServletMessageImpl;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.SipSessionBase;
import com.ericsson.ssa.sip.URIImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import javax.servlet.sip.URI;

public class UA
implements PathNode,
Externalizable {
    private static final long serialVersionUID = -8507246342015896916L;
    private static final Logger m_Log = Logger.getLogger("SipContainer");
    private SipApplicationSessionImpl m_SipApplicationSession = null;
    FSM m_InviteFsm = null;
    private final LinkedList<URI> m_RouteSet = new LinkedList();
    private PathNode.Type m_Type = PathNode.Type.Caller;
    private SipSessionBase m_SipSession = null;
    private int m_RemoteCSeq = -1;
    private Object m_RemoteCSeqSynch = new Object();

    public UA(SipApplicationSessionImpl appSession, boolean isCaller) {
        this.m_SipApplicationSession = appSession;
        this.m_Type = isCaller ? PathNode.Type.Caller : PathNode.Type.Callee;
    }

    public UA() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.m_InviteFsm);
        out.writeInt(this.m_RouteSet.size());
        Iterator ui = this.m_RouteSet.iterator();
        while (ui.hasNext()) {
            out.writeObject(ui.next());
        }
        out.writeObject(this.getRemoteTarget());
        if (this.m_Type == PathNode.Type.Caller) {
            out.writeInt(1);
        } else if (this.m_Type == PathNode.Type.Callee) {
            out.writeInt(2);
        } else {
            out.writeInt(3);
        }
        out.writeObject(this.m_SipSession);
        out.writeInt(this.m_RemoteCSeq);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i = in.readInt();
        for (int c = 0; c < i; ++c) {
            this.m_RouteSet.add((URI)in.readObject());
        }
        switch (in.readInt()) {
            case 1: {
                this.m_Type = PathNode.Type.Caller;
                break;
            }
            case 2: {
                this.m_Type = PathNode.Type.Callee;
                break;
            }
            default: {
                this.m_Type = PathNode.Type.Undefined;
            }
        }
        this.m_SipSession = (SipSessionBase)in.readObject();
        this.m_SipSession.setType(this.m_Type);
        this.m_SipApplicationSession = this.m_SipSession.getApplicationSessionImpl();
        this.m_RemoteCSeq = in.readInt();
        this.m_RemoteCSeqSynch = new Object();
    }

    public PathNode.Type getType() {
        return this.m_Type;
    }

    private boolean isCaller() {
        return this.m_Type == PathNode.Type.Caller;
    }

    public boolean isEmptyDialogSession() {
        return true;
    }

    public boolean isDialogSession(String method, String id) {
        return true;
    }

    public boolean addDialogSession(String method, String id) {
        return true;
    }

    public boolean removeDialogSession(String method, String id) {
        return true;
    }

    public Object clone() {
        UA clone = new UA(this.m_SipApplicationSession, this.isCaller());
        clone.m_InviteFsm = this.m_InviteFsm != null ? (FSM)this.m_InviteFsm.clone() : null;
        clone.m_SipSession = this.m_SipSession;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FSM getFSM(SipServletMessage m) {
        FSM fsm = SUBSCRIBE_REFERSession.createFSM(m);
        if (fsm != null) {
            return fsm;
        }
        fsm = GeneralSession.createFSM(m);
        if (fsm != null) {
            return fsm;
        }
        if (this.m_InviteFsm == null) {
            UA uA = this;
            synchronized (uA) {
                if (this.m_InviteFsm == null) {
                    this.m_InviteFsm = INVITESession.createFSM(m);
                }
            }
        }
        return this.m_InviteFsm;
    }

    private void saveRemoteTarget(SipServletMessage m, boolean contactIsMandatory) throws ServletParseException {
        Address contact = m.getAddressHeader("Contact");
        if (contact != null) {
            this.m_SipSession.setRemoteTarget(m.getAddressHeader("Contact").getURI());
        } else if (contactIsMandatory) {
            if (m_Log.isLoggable(Level.FINE)) {
                m_Log.log(Level.FINE, "No Contact Header found, unable to continue this session, invalidating session: ");
            }
            this.m_SipSession.invalidate();
            throw new IllegalStateException("Missing Contact header field");
        }
    }

    private void addRouteSet(SipServletMessageImpl m) {
        Iterator iter = this.m_RouteSet.iterator();
        while (iter.hasNext()) {
            MultiLineHeader routeHeader = new MultiLineHeader("Route", true);
            URI u = (URI)iter.next();
            ((Header)routeHeader).setValue("<" + u.toString() + ">", false);
            m.addHeader(routeHeader);
        }
    }

    private void saveRouteSet(SipServletRequest req) throws ServletParseException {
        String dummy = req.getHeader("Record-Route");
        if (dummy == null) {
            return;
        }
        ListIterator iter = req.getAddressHeaders("Record-Route");
        Address addr = null;
        this.m_RouteSet.clear();
        while (iter.hasNext()) {
            addr = (Address)iter.next();
            this.m_RouteSet.add(addr.getURI());
        }
    }

    private void saveRouteSet(SipServletResponse resp) throws ServletParseException {
        ListIterator iter = resp.getAddressHeaders("Record-Route");
        Address addr = null;
        this.m_RouteSet.clear();
        while (iter.hasNext()) {
            addr = (Address)iter.next();
            this.m_RouteSet.addFirst(addr.getURI());
        }
    }

    private boolean isLooseRoute() {
        boolean toReturn = false;
        if (this.m_RouteSet != null && !this.m_RouteSet.isEmpty()) {
            URI uri = this.m_RouteSet.getFirst();
            URIImpl uriImpl = (URIImpl)uri;
            toReturn = uriImpl.getLrParam();
        }
        return toReturn;
    }

    public void send(SipServletRequestImpl req) throws IOException, IllegalStateException {
        FSM fsm = this.getFSM(req);
        if (fsm != null) {
            if (req.isInitial()) {
                this.m_SipSession = req.getSessionImpl();
            } else if (!req.getMethod().equals("CANCEL")) {
                if (this.m_RouteSet.isEmpty()) {
                    req.setRequestURI(this.getRemoteTarget());
                } else if (this.isLooseRoute()) {
                    req.setRequestURI(this.getRemoteTarget());
                    this.addRouteSet(req);
                } else {
                    if (m_Log.isLoggable(Level.FINE)) {
                        m_Log.log(Level.FINE, "NOT IMPLEMENTED: strict routing; cannot send request: " + req);
                    }
                    throw new IllegalStateException("Strict routing not implemented");
                }
            }
            fsm.send(req, this);
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "No state machine for request could be found: " + req.toDebugString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContactRouteSetRemoteTarget(SipServletRequestImpl req) throws ServletParseException {
        if (this.getRemoteTarget() == null) {
            UA uA = this;
            synchronized (uA) {
                if (this.getRemoteTarget() == null) {
                    this.saveRouteSet(req);
                    this.saveRemoteTarget(req, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveContactRouteSetRemoteTarget(SipServletResponseImpl resp) throws ServletParseException {
        if (this.getRemoteTarget() == null) {
            UA uA = this;
            synchronized (uA) {
                if (this.getRemoteTarget() == null) {
                    SipServletRequest req = resp.getRequest();
                    this.saveRouteSet(req);
                    HeaderRequirement contactRequirement = SipFactoryImpl.getContactRequirement(resp);
                    if (contactRequirement != HeaderRequirement.NOT_APPLICAPLE) {
                        this.saveRemoteTarget((SipServletMessage)req, contactRequirement == HeaderRequirement.MANDATORY);
                    }
                }
            }
        }
    }

    public void send(SipServletResponseImpl resp) throws IOException, IllegalStateException {
        FSM fsm = this.getFSM(resp);
        if (fsm != null) {
            if (resp.getRequest().isInitial() && this.m_RemoteCSeq == -1) {
                this.setRemoteCSeq(resp.getRequestImpl());
            }
            fsm.send(resp, this);
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "No state machine for response could be found: " + resp.toDebugString());
        }
    }

    public void dispatch(SipServletRequestImpl req) {
        FSM fsm = this.getFSM(req);
        if (fsm != null) {
            boolean success;
            if (this.m_RemoteCSeq == -1) {
                boolean success2 = this.setRemoteCSeq(req);
                if (!success2 && !(success2 = this.verifyAndUpdateCSeq(req))) {
                    SipServletResponseImpl resp = req.createTerminatingResponse(500);
                    if (resp == null) {
                        return;
                    }
                    resp.popDispatcher().dispatch(resp);
                    return;
                }
            } else if (!req.getMethod().equals("ACK") && !(success = this.verifyAndUpdateCSeq(req))) {
                SipServletResponseImpl resp = req.createTerminatingResponse(500);
                resp.popDispatcher().dispatch(resp);
                return;
            }
            fsm.dispatch(req, this);
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "No state machine for request could be found: " + req.toDebugString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRouteSetRemoteTarget(SipServletResponseImpl resp) throws ServletParseException {
        if (this.getRemoteTarget() == null) {
            UA uA = this;
            synchronized (uA) {
                if (this.getRemoteTarget() == null) {
                    this.saveRouteSet(resp);
                    HeaderRequirement contactRequirement = SipFactoryImpl.getContactRequirement(resp);
                    if (contactRequirement != HeaderRequirement.NOT_APPLICAPLE) {
                        this.saveRemoteTarget(resp, contactRequirement == HeaderRequirement.MANDATORY);
                    }
                }
            }
        }
    }

    public void dispatch(SipServletResponseImpl resp) {
        FSM fsm = this.getFSM(resp);
        if (fsm != null) {
            fsm.dispatch(resp, this);
        } else if (m_Log.isLoggable(Level.FINE)) {
            m_Log.log(Level.FINE, "No state machine for response could be found: " + resp.toDebugString());
        }
    }

    public SipSessionBase getSipSession() {
        return this.m_SipSession;
    }

    public void setSipSession(SipSessionBase s) {
        s.setType(this.getType());
        this.m_SipSession = s;
    }

    public SipApplicationSessionImpl getApplicationSession() {
        return this.m_SipApplicationSession;
    }

    public Servlet getServlet(String handler) {
        return SipFactoryImpl.getInstance().getServiceHandler().getHandler(this.getApplicationSession().getName(), handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRemoteCSeq(SipServletRequestImpl req) throws NumberFormatException {
        boolean success = false;
        Object object = this.m_RemoteCSeqSynch;
        synchronized (object) {
            if (this.m_RemoteCSeq == -1) {
                this.m_RemoteCSeq = req.getCSeqNumber();
                success = true;
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyAndUpdateCSeq(SipServletRequestImpl req) throws NumberFormatException {
        boolean success = false;
        int messageCSeq = req.getCSeqNumber();
        int CSeq = -1;
        if (req.getMethod().equals("ACK") || req.getMethod().equals("CANCEL")) {
            Object object = this.m_RemoteCSeqSynch;
            synchronized (object) {
                CSeq = this.m_RemoteCSeq;
                success = messageCSeq == CSeq;
            }
        }
        Object object = this.m_RemoteCSeqSynch;
        synchronized (object) {
            CSeq = this.m_RemoteCSeq;
            if (messageCSeq > CSeq) {
                this.m_RemoteCSeq = messageCSeq;
                success = true;
            }
        }
        return success;
    }

    public URI getRemoteTarget() {
        return this.m_SipSession != null ? this.m_SipSession.getRemoteTarget() : null;
    }

    public boolean isReplicable() {
        return this.m_SipApplicationSession.isReplicable();
    }
}

