/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip;

import com.ericsson.eas.telurl.TelUrlResolver;
import com.ericsson.eas.telurl.TelUrlResolverException;
import com.ericsson.ssa.sip.SipFactoryImpl;
import com.ericsson.ssa.sip.TelURLImpl;
import com.ericsson.ssa.sip.UriUtil;
import com.ericsson.ssa.sip.dns.DnsResolver;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;

public class UriWrapper {
    private static Logger _log = Logger.getLogger("SipContainer");
    private static SipFactory sf = SipFactoryImpl.getInstance();
    static TelUrlResolver resolver = DnsResolver.getInstance();
    private URI transformedUri;
    private SipServletRequest req;
    private boolean hasDoneTransform;

    public UriWrapper(SipServletRequest req) {
        this.req = req;
        URI uriToBeWrapped = req.getRequestURI();
        if (!(uriToBeWrapped instanceof SipURI) && !(uriToBeWrapped instanceof TelURLImpl)) {
            throw new IllegalArgumentException("The URI class: " + uriToBeWrapped.getClass() + " is not supported");
        }
    }

    public URI getTransformedUri() {
        if (!this.hasDoneTransform) {
            URI uri = this.req.getRequestURI();
            this.transformedUri = this.transformURI(uri);
            if ("tel".equals(uri.getScheme()) && this.transformedUri == null) {
                this.transformedUri = uri;
            }
            this.hasDoneTransform = true;
        }
        return this.transformedUri;
    }

    private SipURI transformURI(URI uri) {
        SipURI sipUri = null;
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "transformURI uri: " + uri);
        }
        if (uri.isSipURI()) {
            sipUri = (SipURI)uri;
            String user = sipUri.getParameter("user");
            if (user != null && user.equals("phone")) {
                sipUri = this.resolve(uri);
            }
        } else if (resolver.isTelephoneNumber(uri)) {
            sipUri = this.resolve(uri);
        }
        return sipUri;
    }

    private SipURI resolve(URI uri) {
        SipURI sipUri;
        block7: {
            sipUri = null;
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "resolve uri: " + uri);
            }
            if (resolver.isTelephoneNumber(uri)) {
                try {
                    sipUri = resolver.lookupSipURI(uri);
                    if (_log.isLoggable(Level.FINE)) {
                        _log.log(Level.FINE, "uri: " + uri);
                        _log.log(Level.FINE, "resolves to: " + sipUri);
                    }
                }
                catch (IOException ioe) {
                    if (_log.isLoggable(Level.FINE)) {
                        _log.log(Level.FINE, "failed to resolve: " + ioe);
                    }
                }
                catch (TelUrlResolverException telExc) {
                    if (!_log.isLoggable(Level.FINE)) break block7;
                    _log.log(Level.FINE, "TelUrlResolverException, failed to resolve: " + uri);
                }
            }
        }
        return sipUri;
    }

    public void setParameter(String name, String value) {
        UriUtil.setParameter(this.req.getRequestURI(), name, value);
    }

    public String removeParameter(String name) {
        return UriUtil.removeParameter(this.req.getRequestURI(), name);
    }

    public String getParameter(String name) {
        return UriUtil.getParameter(this.req.getRequestURI(), name);
    }

    public String toString() {
        return "Request-URI: " + this.req.getRequestURI() + "; Transformed Request-URI: " + this.getTransformedUri();
    }
}

