/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.ssa.sip.dns.TrivialMatchResult;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xbill.DNS.Name;

public class EnumUtil {
    public static final int MAX_DEPTH = 5;
    private static final char BACKSLASH = '\\';
    public static final String TRIVIAL_REGEXP = "^.*$";
    private static final Pattern POSIX_DIGIT_PATTERN = Pattern.compile("[:digit:]", 16);
    private static final String POSIX_DIGIT_REPLACEMENT = Matcher.quoteReplacement("\\p{Digit}");

    public static String applyRegExp(String AUS, String regexpStr) {
        String[] regexp = EnumUtil.splitRegexp(EnumUtil.unescape(regexpStr));
        MatchResult matchResult = null;
        if (regexp[0].equals(TRIVIAL_REGEXP)) {
            matchResult = new TrivialMatchResult(AUS);
        } else {
            Pattern pattern = Pattern.compile(EnumUtil.toAlmostPosix(regexp[0]));
            String substitution = regexp[1];
            Matcher matcher = pattern.matcher(AUS);
            if (matcher.find()) {
                matchResult = matcher;
            }
        }
        if (matchResult == null) {
            return null;
        }
        return EnumUtil.substitute(matchResult, regexp[1]);
    }

    public static String toAlmostPosix(String regexp) {
        return POSIX_DIGIT_PATTERN.matcher(regexp).replaceAll(POSIX_DIGIT_REPLACEMENT);
    }

    public static boolean isEmpty(Name name) {
        return Name.root.equals((Object)name);
    }

    public static String unescape(String str) {
        if (str.indexOf(92) < 0) {
            return str;
        }
        State state = State.NORMAL;
        StringBuilder result = new StringBuilder(str.length());
        boolean escaped = false;
        block6: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (state) {
                case NORMAL: {
                    if (ch == '\\') {
                        state = State.ESCAPE;
                        continue block6;
                    }
                    result.append(ch);
                    continue block6;
                }
                case ESCAPE: {
                    if (Character.isDigit(ch)) {
                        state = State.DIGIT1;
                        continue block6;
                    }
                    result.append(ch);
                    state = State.NORMAL;
                    continue block6;
                }
                case DIGIT1: {
                    if (Character.isDigit(ch)) {
                        state = State.DIGIT2;
                        continue block6;
                    }
                    throw new IllegalArgumentException(str);
                }
                case DIGIT2: {
                    if (Character.isDigit(ch)) {
                        result.append((char)Integer.parseInt(str.substring(i - 2, i + 1)));
                        state = State.NORMAL;
                        continue block6;
                    }
                    throw new IllegalArgumentException(str);
                }
            }
        }
        return result.toString();
    }

    public static String toDomain(String telNumber, String enumTopDomain) {
        if (telNumber.charAt(0) != '+') {
            throw new IllegalArgumentException("This is not a global phone number:" + telNumber);
        }
        StringBuilder domain = new StringBuilder(2 * telNumber.length() + 10);
        for (int i = telNumber.length() - 1; i > 0; --i) {
            char ch = telNumber.charAt(i);
            if (!Character.isDigit(ch)) continue;
            domain.append(ch);
            domain.append('.');
        }
        domain.append(enumTopDomain);
        return domain.toString();
    }

    public static String substitute(MatchResult matcher, String substitution) {
        StringBuilder result = new StringBuilder();
        boolean backslash = false;
        for (int i = 0; i < substitution.length(); ++i) {
            char ch = substitution.charAt(i);
            if (backslash) {
                if (Character.isDigit(ch)) {
                    result.append(matcher.group(Character.digit(ch, 10)));
                } else {
                    result.append('\\').append(ch);
                }
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            result.append(ch);
        }
        if (backslash) {
            result.append('\\');
        }
        return result.toString();
    }

    public static String[] splitRegexp(String regexp) {
        String[] result = new String[3];
        int index = 0;
        boolean backslash = false;
        char delimiter = regexp.charAt(0);
        int start = 1;
        for (int i = 1; i < regexp.length(); ++i) {
            char ch = regexp.charAt(i);
            if (backslash) {
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            if (ch != delimiter) continue;
            if (index < 2) {
                result[index++] = regexp.substring(start, i);
                start = i + 1;
                continue;
            }
            throw new IllegalArgumentException(regexp);
        }
        if (index != 2) {
            throw new IllegalArgumentException(regexp);
        }
        result[2] = regexp.substring(start);
        return result;
    }

    public static String getAUSValue(String input) {
        StringBuilder sb = new StringBuilder();
        sb.append('+');
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (!Character.isDigit(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        NORMAL,
        ESCAPE,
        DIGIT1,
        DIGIT2;

    }
}

