/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.dns;

import com.ericsson.ssa.sip.dns.UDPProtocol;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class SipTransports
implements Externalizable {
    private static final long serialVersionUID = 4049076025512440630L;
    public static final int UNDEFINED = -1;
    public static final int UDP = 1;
    public static final int TCP = 2;
    public static final int TLS = 3;
    public static final UDPProtocol UDP_PROT = new UDPProtocol(1, "udp", 5060, "SIP+D2U", "_sip._udp");
    public static final SipTransports TCP_PROT = new SipTransports(2, "tcp", 5060, "SIP+D2T", "_sip._tcp");
    public static final SipTransports TLS_PROT = new SipTransports(3, "tls", 5061, "SIPS+D2T", "_sips._tcp");
    public static final SipTransports UNDEFINED_PROT = new SipTransports(-1, "undefined", -1, "", "");
    private int myOrdinal;
    private boolean myIsSupported = false;
    private String myProtocolName;
    private String myNaptrString;
    private String mySRVToken;
    private int myDefaultPort;

    SipTransports(int ordinal, String protocolName, int defaultPort, String naptrString, String srvToken) {
        this.myOrdinal = ordinal;
        this.myProtocolName = protocolName;
        this.myDefaultPort = defaultPort;
        this.myNaptrString = naptrString;
        this.mySRVToken = srvToken;
    }

    public SipTransports() {
    }

    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeInt(this.myOrdinal);
    }

    public void readExternal(ObjectInput input) throws IOException {
        int o = input.readInt();
        SipTransports st = null;
        switch (o) {
            case 1: {
                st = UDP_PROT;
                break;
            }
            case 2: {
                st = TCP_PROT;
                break;
            }
            case 3: {
                st = TLS_PROT;
                break;
            }
            default: {
                st = UNDEFINED_PROT;
            }
        }
        this.myOrdinal = o;
        this.myProtocolName = st.myProtocolName;
        this.myDefaultPort = st.myDefaultPort;
        this.myNaptrString = st.myNaptrString;
        this.mySRVToken = st.mySRVToken;
    }

    public boolean isSupported() {
        return this.myIsSupported;
    }

    public int ordinal() {
        return this.myOrdinal;
    }

    public void setSupported(boolean value) {
        this.myIsSupported = value;
    }

    public String name() {
        return this.myProtocolName;
    }

    public int getDefaultPort() {
        return this.myDefaultPort;
    }

    public String getNAPTRId() {
        return this.myNaptrString;
    }

    public String getSRVToken() {
        return this.mySRVToken;
    }

    public static SipTransports getTransport(String transportId) throws Exception {
        SipTransports theProtocol = null;
        if (transportId.equalsIgnoreCase(UDP_PROT.name())) {
            theProtocol = UDP_PROT;
        } else if (transportId.equalsIgnoreCase(TCP_PROT.name())) {
            theProtocol = TCP_PROT;
        } else if (transportId.equalsIgnoreCase(TLS_PROT.name())) {
            theProtocol = TLS_PROT;
        } else {
            throw new Exception("Transport protocol not supported:" + transportId);
        }
        return theProtocol;
    }

    static {
        UDP_PROT.setSupported(true);
        TCP_PROT.setSupported(true);
        TLS_PROT.setSupported(true);
    }
}

