/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.timer;

import com.ericsson.ssa.sip.SipApplicationSessionImpl;
import com.ericsson.ssa.sip.SipSessionManager;
import com.ericsson.ssa.sip.SipSessionManagerBase;
import com.ericsson.ssa.sip.timer.TimerServiceImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.sip.ServletTimer;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.TimerListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTimerImpl
implements ServletTimer,
Runnable,
Externalizable {
    private static final long serialVersionUID = 8123619219185134043L;
    private ScheduledFuture<?> _future;
    private Serializable _info;
    private SipApplicationSessionImpl _appSession = null;
    private long _scheduledExecutionTime = 0L;
    private long _delay = 0L;
    private long _period = 0L;
    private long _numInvocations = 0L;
    private long _firstExecution = 0L;
    private boolean _fixedDelay = false;
    private boolean _persistent = true;
    private Boolean iscanceled = null;
    private TimerListener _listener;
    private boolean _isRepeatingTimer = true;
    private final Object SIPP_APPLICATION_LOCK = new Object();
    private String _id = null;
    protected AtomicLong version = new AtomicLong(-1L);

    public ServletTimerImpl() {
    }

    public ServletTimerImpl(Serializable info, long delay, TimerListener listener) {
        this(null, info, delay, listener);
    }

    public ServletTimerImpl(SipApplicationSessionImpl sas, Serializable info, long delay, TimerListener listener) {
        this(sas, info, delay, false, 0L, listener);
        this._isRepeatingTimer = false;
    }

    public ServletTimerImpl(Serializable info, long delay, boolean fixedDelay, long period, TimerListener listener) {
        this(null, info, delay, fixedDelay, period, listener);
    }

    public ServletTimerImpl(SipApplicationSessionImpl sas, Serializable info, long delay, boolean fixedDelay, long period, TimerListener listener) {
        this._appSession = sas;
        if (this._appSession != null) {
            this._appSession.addServletTimer(this);
        }
        this._info = info;
        this._delay = delay;
        this._scheduledExecutionTime = delay + System.currentTimeMillis();
        this._fixedDelay = fixedDelay;
        this._period = period;
        this._listener = listener;
        this._id = UUID.randomUUID().toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._id);
        out.writeObject(this.version);
        out.writeObject(this._info);
        out.writeObject(this._appSession.getSipSessionManager().getContext().getName());
        out.writeObject(this._appSession.getId());
        out.writeLong(this._scheduledExecutionTime);
        out.writeLong(this._delay);
        out.writeLong(this._period);
        out.writeLong(this._numInvocations);
        out.writeLong(this._firstExecution);
        out.writeBoolean(this._fixedDelay);
        out.writeBoolean(this._isRepeatingTimer);
        out.writeLong(System.currentTimeMillis() + this._future.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._id = (String)in.readObject();
        this.version = (AtomicLong)in.readObject();
        this._info = (Serializable)in.readObject();
        String contextName = (String)in.readObject();
        SipSessionManager sipSessionManager = SipSessionManagerBase.get(contextName);
        String sasId = (String)in.readObject();
        this._appSession = sipSessionManager.findApplicationSession(sasId);
        if (this._appSession != null) {
            this._appSession.addServletTimer(this);
        }
        this._scheduledExecutionTime = in.readLong();
        this._delay = in.readLong();
        this._period = in.readLong();
        this._numInvocations = in.readLong();
        this._firstExecution = in.readLong();
        this._fixedDelay = in.readBoolean();
        this._isRepeatingTimer = in.readBoolean();
        this._persistent = true;
        long nextExec = in.readLong() - System.currentTimeMillis();
        if (nextExec <= 0L) {
            nextExec = 1L;
        }
        TimerServiceImpl.getInstance().deserializeTimer(this, nextExec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._listener.timeout((ServletTimer)this);
        }
        finally {
            if (this._isRepeatingTimer) {
                this.estimateNextExecution();
            } else {
                this.cancel();
            }
        }
    }

    public SipApplicationSession getApplicationSession() {
        return this._appSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFuture(ScheduledFuture<?> f) {
        Object object = this.SIPP_APPLICATION_LOCK;
        synchronized (object) {
            this._future = f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estimateNextExecution() {
        Object object = this.SIPP_APPLICATION_LOCK;
        synchronized (object) {
            if (this._fixedDelay) {
                this._scheduledExecutionTime = this._period + System.currentTimeMillis();
            } else {
                if (this._firstExecution == 0L) {
                    this._firstExecution = this._scheduledExecutionTime;
                }
                this._scheduledExecutionTime = this._firstExecution + ++this._numInvocations * this._period;
            }
        }
    }

    public long getDelay() {
        return this._delay;
    }

    public long getPeriod() {
        return this._period;
    }

    public Serializable getInfo() {
        return this._info;
    }

    public String getId() {
        return this._id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long scheduledExecutionTime() {
        Object object = this.SIPP_APPLICATION_LOCK;
        synchronized (object) {
            return this._scheduledExecutionTime;
        }
    }

    public void cancel() {
        this.cancel(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean mayInterruptIfRunning) {
        SipApplicationSessionImpl appSessionToCancelThisTimersFrom = null;
        Object object = this.SIPP_APPLICATION_LOCK;
        synchronized (object) {
            if (this._future != null) {
                boolean res = this._future.cancel(mayInterruptIfRunning);
                this.iscanceled = new Boolean(res);
                appSessionToCancelThisTimersFrom = this._appSession;
                this._future = null;
            }
        }
        if (appSessionToCancelThisTimersFrom != null) {
            appSessionToCancelThisTimersFrom.cancelServletTimer(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Info = ").append(this._info).append('\n');
        sb.append("Scheduled execution time = ").append(this._scheduledExecutionTime).append('\n');
        sb.append("Time now = ").append(System.currentTimeMillis()).append('\n');
        sb.append("SipApplicationSession = ").append(this._appSession).append('\n');
        sb.append("ScheduledFuture = ").append(this._future).append('\n');
        sb.append("Delay = ").append(this._delay).append('\n');
        return sb.toString();
    }

    public boolean isPersistant() {
        return this._persistent;
    }

    public void setPersistant(boolean p) {
        this._persistent = p;
    }

    public String getID() {
        throw new RuntimeException("Not yet implemented");
    }

    boolean isRepeatingTimer() {
        return this._isRepeatingTimer;
    }

    boolean isFixedDelay() {
        return this._fixedDelay;
    }

    TimerListener getListener() {
        return this._listener;
    }

    public void incrementVersion() {
        this.version.incrementAndGet();
    }
}

