/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.PathNode;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.transaction.ServerTransaction;
import com.ericsson.ssa.sip.transaction.TransactionState;
import com.ericsson.ssa.sip.transaction.TransactionTimer;
import java.io.Serializable;
import java.util.logging.Level;
import javax.servlet.sip.ServletTimer;

public class InviteServerTransaction
extends ServerTransaction {
    private ServletTimerImpl _timerG;
    private ServletTimerImpl _timerH;
    private ServletTimerImpl _timerI;
    private Object _cancelLock = new Object();
    private Object _cancelTriggerLock = new Object();
    private SipServletResponseImpl _cancelTriggerResponse = null;
    private SipServletRequestImpl _cancel = null;

    public InviteServerTransaction(String id, SipServletRequestImpl req) {
        super(id, TransactionState.PROCEEDING, req);
        this.send100Trying(req);
    }

    private void send100Trying(SipServletRequestImpl req) {
        this._response = req.create100TryingResponse();
        this._response.setRemote(this._request.getRemote());
        this._response.popDispatcher().dispatch(this._response);
    }

    synchronized boolean handle(SipServletRequestImpl req) {
        if (req.getMethod().equals("ACK") && this._state == TransactionState.COMPLETED) {
            this.toConfirmed();
        } else if (this._response != null && (this._state == TransactionState.PROCEEDING || this._state == TransactionState.COMPLETED)) {
            this._response.restoreRetransmissionTransactionStack();
            Dispatcher d = this._response.popDispatcher();
            if (d != null) {
                d.dispatch(this._response);
            }
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(SipServletResponseImpl resp) {
        block16: {
            InviteServerTransaction inviteServerTransaction = this;
            synchronized (inviteServerTransaction) {
                if (resp.getStatus() == 100) {
                    if (this._state == TransactionState.PROCEEDING) {
                        this.handleCancelTrigger(resp);
                    }
                    return;
                }
                int status = resp.getStatus() / 100;
                switch (this._state) {
                    case PROCEEDING: {
                        this._response = resp;
                        if (status == 1) {
                            this.handleCancelTrigger(resp);
                            break;
                        }
                        if (status == 2) {
                            this.terminate();
                            break;
                        }
                        this.toCompleted();
                        break;
                    }
                    case COMPLETED: {
                        return;
                    }
                    case CONFIRMED: {
                        return;
                    }
                    case TERMINATED: {
                        if (status == 2) break;
                        return;
                    }
                    default: {
                        _log.log(Level.FINE, "IllegalState in ICT = " + (Object)((Object)this._state));
                    }
                }
            }
            Dispatcher d = resp.popDispatcher();
            try {
                if (d != null) {
                    d.dispatch(resp);
                }
            }
            catch (Exception e) {
                this.terminate();
                if (!_log.isLoggable(Level.FINE)) break block16;
                _log.log(Level.FINE, "Handled : ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(ServletTimer timer) {
        TransactionTimer tt = (TransactionTimer)((Object)timer.getInfo());
        switch (tt) {
            case TimerG: {
                InviteServerTransaction inviteServerTransaction = this;
                synchronized (inviteServerTransaction) {
                    if (this._state == TransactionState.COMPLETED) {
                        long delay = ((ServletTimerImpl)timer).getDelay();
                        delay = delay * 2L <= T2 ? delay * 2L : T2;
                        this._timerG = _timerService.createTimer(this, delay, false, (Serializable)((Object)TransactionTimer.TimerG));
                        this._response.restoreRetransmissionTransactionStack();
                        Dispatcher d = this._response.popDispatcher();
                        if (d != null) {
                            d.dispatch(this._response);
                        }
                        if (PerformanceMBeanListener.isEnabled()) {
                            this.updateLastAccessTimestamp();
                        }
                    }
                    break;
                }
            }
            case TimerH: {
                this.terminate();
                break;
            }
            case TimerI: {
                this.terminate();
                break;
            }
            default: {
                _log.log(Level.FINE, "IllegalTimer in ICT = " + (Object)((Object)tt));
            }
        }
    }

    private void toCompleted() {
        this.stopCancel();
        this._timerH = _timerService.createTimer(this, 64L * T1, false, (Serializable)((Object)TransactionTimer.TimerH));
        this._state = TransactionState.COMPLETED;
        if (!this._reliableTransport) {
            this._timerG = _timerService.createTimer(this, T1, false, (Serializable)((Object)TransactionTimer.TimerG));
        }
    }

    private void toConfirmed() {
        if (this._timerH != null) {
            this._timerH.cancel();
            this._timerH = null;
        }
        if (!this._reliableTransport) {
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
            if (this._timerG != null) {
                this._timerG.cancel();
                this._timerG = null;
            }
            this._state = TransactionState.CONFIRMED;
            this._timerI = _timerService.createTimer(this, T4, false, (Serializable)((Object)TransactionTimer.TimerI));
        } else {
            this._state = TransactionState.TERMINATED;
            super.terminate();
        }
    }

    protected synchronized void terminate() {
        super.terminate();
        this.stopCancel();
        if (this._timerG != null) {
            this._timerG.cancel();
            this._timerG = null;
        }
        if (this._timerH != null) {
            this._timerH.cancel();
            this._timerH = null;
        }
        if (this._timerI != null) {
            this._timerI.cancel();
            this._timerI = null;
        }
        this._state = TransactionState.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SipServletResponseImpl getPendingCancelTrigger() {
        Object object = this._cancelTriggerLock;
        synchronized (object) {
            return this._cancelTriggerResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingCancelTrigger(SipServletResponseImpl resp) {
        if (this._cancelTriggerResponse == null) {
            Object object = this._cancelTriggerLock;
            synchronized (object) {
                if (this._cancelTriggerResponse == null) {
                    this._cancelTriggerResponse = resp;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SipServletRequestImpl getPendingCancel() {
        Object object = this._cancelLock;
        synchronized (object) {
            return this._cancel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPendingCancel(SipServletRequestImpl cancel) {
        if (this._cancel == null) {
            Object object = this._cancelLock;
            synchronized (object) {
                if (this._cancel == null) {
                    this._cancel = cancel;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCancel() {
        Object object = this._cancelTriggerLock;
        synchronized (object) {
            this._cancelTriggerResponse = null;
        }
        object = this._cancelLock;
        synchronized (object) {
            this._cancel = null;
        }
    }

    private void handleCancel(SipServletRequestImpl cancel, SipServletResponseImpl cancelPendingTrigger) {
        PathNode next;
        if (cancel != null && cancelPendingTrigger != null && (next = cancelPendingTrigger.getCurrentVisited()) != null) {
            next.dispatch(cancel);
        }
    }

    private void handleCancelTrigger(SipServletResponseImpl pendingTrigger) {
        SipServletRequestImpl cancel = this.getPendingCancel();
        if (cancel != null) {
            this.handleCancel(cancel, pendingTrigger);
        } else {
            this.setPendingCancelTrigger(pendingTrigger);
        }
    }

    void handleCancel(ServerTransaction st) {
        SipServletResponseImpl cancelPendingTrigger = this.getPendingCancelTrigger();
        if (cancelPendingTrigger != null) {
            this.handleCancel(st._request, cancelPendingTrigger);
        } else {
            this.setPendingCancel(st._request);
        }
    }
}

