/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.container.startup.PerformanceMBeanListener;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.timer.ServletTimerImpl;
import com.ericsson.ssa.sip.transaction.ServerTransaction;
import com.ericsson.ssa.sip.transaction.TransactionState;
import com.ericsson.ssa.sip.transaction.TransactionTimer;
import java.io.Serializable;
import java.util.logging.Level;
import javax.servlet.sip.ServletTimer;

public class NonInviteServerTransaction
extends ServerTransaction {
    private ServletTimerImpl _timerJ;

    public NonInviteServerTransaction(String id, SipServletRequestImpl req) {
        super(id, TransactionState.TRYING, req);
    }

    synchronized boolean handle(SipServletRequestImpl req) {
        if (this._response != null && (this._state == TransactionState.PROCEEDING || this._state == TransactionState.COMPLETED)) {
            this._response.restoreRetransmissionTransactionStack();
            Dispatcher d = this._response.popDispatcher();
            if (d != null) {
                d.dispatch(this._response);
            }
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(SipServletResponseImpl resp) {
        block14: {
            if (resp.getStatus() == 100) {
                return;
            }
            int status = resp.getStatus() / 100;
            NonInviteServerTransaction nonInviteServerTransaction = this;
            synchronized (nonInviteServerTransaction) {
                switch (this._state) {
                    case TRYING: {
                        this._response = resp;
                        if (status == 1) {
                            this._state = TransactionState.PROCEEDING;
                            break;
                        }
                        this.toCompleted();
                        break;
                    }
                    case PROCEEDING: {
                        this._response = resp;
                        if (status < 2 || status > 6) break;
                        this.toCompleted();
                        break;
                    }
                    case COMPLETED: {
                        return;
                    }
                    case TERMINATED: {
                        return;
                    }
                    default: {
                        if (!_log.isLoggable(Level.FINE)) break;
                        _log.log(Level.FINE, "IllegalState in ICT = " + (Object)((Object)this._state));
                    }
                }
            }
            Dispatcher d = resp.popDispatcher();
            try {
                if (d != null) {
                    d.dispatch(resp);
                }
            }
            catch (Exception e) {
                this.terminate();
                if (!_log.isLoggable(Level.FINE)) break block14;
                _log.log(Level.FINE, "Handled : ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(ServletTimer timer) {
        TransactionTimer tt = (TransactionTimer)((Object)timer.getInfo());
        if (tt == TransactionTimer.TimerJ) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Timer J fired - terminating()");
            }
            NonInviteServerTransaction nonInviteServerTransaction = this;
            synchronized (nonInviteServerTransaction) {
                this._timerJ = null;
                this.terminate();
            }
        } else if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "IllegalTimer in ICT = " + (Object)((Object)tt));
        }
    }

    protected synchronized void terminate() {
        this._state = TransactionState.TERMINATED;
        super.terminate();
        if (this._timerJ != null) {
            this._timerJ.cancel();
            this._timerJ = null;
        }
    }

    private void toCompleted() {
        if (!this._reliableTransport) {
            if (PerformanceMBeanListener.isEnabled()) {
                this.updateLastAccessTimestamp();
            }
            this._state = TransactionState.COMPLETED;
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Timer J started - toCompleted()");
            }
            this._timerJ = _timerService.createTimer(this, 64L * T1, false, (Serializable)((Object)TransactionTimer.TimerJ));
            this._request = null;
        } else {
            this._state = TransactionState.TERMINATED;
            super.terminate();
        }
    }

    void handleCancel(ServerTransaction st) {
    }
}

