/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.sip.transaction;

import com.ericsson.ssa.config.Config;
import com.ericsson.ssa.config.ConfigFactory;
import com.ericsson.ssa.config.lease.Lease;
import com.ericsson.ssa.config.lease.LeaseExpiredException;
import com.ericsson.ssa.container.SipBindingResolver;
import com.ericsson.ssa.sip.Dispatcher;
import com.ericsson.ssa.sip.Header;
import com.ericsson.ssa.sip.Layer;
import com.ericsson.ssa.sip.LayerHelper;
import com.ericsson.ssa.sip.MultiLineHeader;
import com.ericsson.ssa.sip.SipServletRequestImpl;
import com.ericsson.ssa.sip.SipServletResponseImpl;
import com.ericsson.ssa.sip.ViaImpl;
import com.ericsson.ssa.sip.dns.TargetTuple;
import com.ericsson.ssa.sip.transaction.ClientTransaction;
import com.ericsson.ssa.sip.transaction.InviteClientTransaction;
import com.ericsson.ssa.sip.transaction.InviteServerTransaction;
import com.ericsson.ssa.sip.transaction.NonInviteClientTransaction;
import com.ericsson.ssa.sip.transaction.NonInviteServerTransaction;
import com.ericsson.ssa.sip.transaction.ServerTransaction;
import com.ericsson.ssa.sip.transaction.Transaction;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TransactionManager
implements Layer {
    private static final Logger _log = Logger.getLogger("SipContainer");
    private static TransactionManager _tm = null;
    private Layer _nextLayer;
    private Map<String, ClientTransaction> ctMap = new ConcurrentHashMap<String, ClientTransaction>();
    private Map<String, ServerTransaction> stMap = new ConcurrentHashMap<String, ServerTransaction>();
    private ConcurrentHashMap<String, Object> stLockMap = new ConcurrentHashMap();
    private AtomicLong m_EasSipServerTransactions = new AtomicLong();
    private AtomicLong m_EasSipClientTransactions = new AtomicLong();
    private AtomicLong m_EasTotalSipTransactionTime = new AtomicLong();
    private AtomicLong m_EasTotalSipTransactionCount = new AtomicLong();
    long _timerT1 = 500L;
    long _timerT2 = 4000L;
    long _timerT4 = 5000L;
    private String myHost = null;
    private MessageDigest md = null;
    private Config _config = ConfigFactory.getConfig();

    private TransactionManager() {
        try {
            this.md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerTransaction getServerTransaction(String id) {
        ServerTransaction st = null;
        Object mutex = this.stLockMap.get(id);
        if (mutex != null) {
            Object object = mutex;
            synchronized (object) {
                st = this.stMap.get(id);
            }
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeCreatedOrFetchedServerTransaction(SipServletRequestImpl req, String id) {
        boolean isTransactionCreated = false;
        ServerTransaction st = null;
        NonInviteServerTransaction stCancel = null;
        SipServletResponseImpl resp = null;
        Object newMutex = new Object();
        Object mutex = this.stLockMap.putIfAbsent(id, newMutex);
        if (mutex == null) {
            mutex = newMutex;
        }
        Object object = mutex;
        synchronized (object) {
            st = this.stMap.get(id);
            if (req.getMethod().equals("CANCEL")) {
                if (st != null) {
                    id = id + req.getMethod();
                    stCancel = new NonInviteServerTransaction(id, req);
                    req.pushTransactionDispatcher(stCancel);
                    req.pushApplicationDispatcher(this);
                    this.stMap.put(id, stCancel);
                } else {
                    resp = req.createTerminatingResponse(481);
                    resp.setRemote(req.getRemote());
                }
            } else if (st == null) {
                st = req.getMethod().equals("INVITE") ? new InviteServerTransaction(id, req) : new NonInviteServerTransaction(id, req);
                req.pushTransactionDispatcher(st);
                req.pushApplicationDispatcher(this);
                this.stMap.put(id, st);
                isTransactionCreated = true;
            }
        }
        if (resp != null) {
            resp.popDispatcher().dispatch(resp);
        } else if (stCancel != null) {
            st.handleCancel(stCancel);
        } else if (isTransactionCreated) {
            LayerHelper.next(req, (Layer)this, this._nextLayer);
        } else {
            st.handle(req);
        }
    }

    public void next(SipServletRequestImpl req) {
        String method = req.getMethod();
        ServerTransaction st = null;
        String id = this.getBranchId(req);
        if (id != null) {
            try {
                if (method.equals("ACK")) {
                    st = this.getServerTransaction(id);
                    if (st == null) {
                        LayerHelper.next(req, (Layer)this, this._nextLayer);
                    }
                    st.handle(req);
                }
                this.invokeCreatedOrFetchedServerTransaction(req, id);
            }
            catch (RuntimeException re) {
                this.removeServerTransaction(id);
                throw re;
            }
        } else {
            SipServletResponseImpl resp;
            Dispatcher d;
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "No Branch in Via header " + req.toString());
            }
            if ((d = (resp = (SipServletResponseImpl)req.createResponse(400, "No Branch in Via header")).popDispatcher()) != null) {
                d.dispatch(resp);
            }
        }
    }

    public void next(SipServletResponseImpl resp) {
        ClientTransaction ct;
        if (resp.isRedirect()) {
            LayerHelper.next(resp, (Layer)this, this._nextLayer);
            return;
        }
        boolean stopLayer = false;
        String id = this.getBranchId(resp);
        if (resp.getMethod().equals("CANCEL")) {
            id = id + resp.getMethod();
        }
        if ((ct = this.ctMap.get(id)) == null) {
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.SEVERE, "Can't find matching transaction - Terminating");
            }
            return;
        }
        stopLayer = ct.handle(resp);
        Header via = resp.getRawHeader("Via");
        via.setReadOnly(false);
        ListIterator<String> li = via.getValues();
        String topVia = li.next();
        if (topVia != null && resp.getMethod().equals("INVITE")) {
            MultiLineHeader viaOfCancel = new MultiLineHeader("Via", true);
            ViaImpl v = new ViaImpl(topVia);
            ((Header)viaOfCancel).setValue(v.toString(), true);
            resp.setCancelVia(viaOfCancel);
        }
        li.remove();
        via.setReadOnly(true);
        if (_log.isLoggable(Level.FINE)) {
            _log.log(Level.FINE, "Removing via = " + topVia);
        }
        if (!stopLayer) {
            try {
                LayerHelper.next(resp, (Layer)this, this._nextLayer);
            }
            catch (RuntimeException re) {
                this.removeClientTransaction(id);
                throw re;
            }
        }
    }

    public void registerNext(Layer layer) {
        this._nextLayer = layer;
    }

    public void dispatch(SipServletRequestImpl req) {
        String method = req.getMethod();
        if (!method.equals("CANCEL")) {
            Header via = req.getRawHeader("Via");
            if (via == null) {
                via = new MultiLineHeader("Via", true);
            }
            int port = -1;
            if (Boolean.getBoolean("sip.module.use_new_config")) {
                try {
                    Lease<TargetTuple[]> lease = SipBindingResolver.instance().lease("PUBLIC_BINDING_CTX");
                    System.out.println("TransactionManager: \n" + lease.getResource()[0]);
                    this.myHost = lease.getResource()[0].getIP();
                    port = lease.getResource()[0].getPort();
                }
                catch (LeaseExpiredException e) {
                    e.printStackTrace();
                }
            } else {
                port = Integer.parseInt(this._config.get("SIP_PUBLIC_PORT"));
                if (req.getRemote().getProtocol().ordinal() == 3) {
                    ++port;
                }
                if (this.myHost == null) {
                    this.myHost = this._config.get("SIP_PUBLIC_HOST");
                }
            }
            ViaImpl v = new ViaImpl(req.getProtocol(), req.getTransport().toUpperCase(), this.myHost, port);
            String id = Transaction.generateBranch();
            v.setParameter("branch", id);
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Adding via = " + v);
            }
            via.setValue(v.toString(), true);
            req.setHeader(via);
            if (!method.equals("ACK")) {
                ClientTransaction ct = method.equals("INVITE") ? new InviteClientTransaction(id, req) : new NonInviteClientTransaction(id, req);
                this.ctMap.put(id, ct);
            }
        } else {
            String id = this.getBranchId(req) + req.getMethod();
            NonInviteClientTransaction ct = new NonInviteClientTransaction(id, req);
            this.ctMap.put(id, ct);
        }
        Dispatcher d = req.popDispatcher();
        if (d != null) {
            d.dispatch(req);
        }
    }

    public void dispatch(SipServletResponseImpl resp) {
        Dispatcher d = resp.popDispatcher();
        if (d != null) {
            d.dispatch(resp);
        }
    }

    public static synchronized TransactionManager getInstance() {
        if (_tm != null) {
            return _tm;
        }
        _tm = new TransactionManager();
        return _tm;
    }

    private String getBranchId(SipServletResponseImpl resp) {
        ViaImpl via = null;
        String vstr = resp.getHeader("Via");
        if (vstr != null && (via = new ViaImpl(vstr)) != null) {
            String id = null;
            id = via.getParameter("branch");
            if (id != null) {
                return id;
            }
        }
        return null;
    }

    private String getBranchId(SipServletRequestImpl req) {
        ViaImpl via = null;
        String vstr = req.getHeader("Via");
        if (vstr != null && (via = new ViaImpl(vstr)) != null) {
            String id = null;
            id = via.getParameter("branch");
            if (id != null) {
                return id;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(req.getRequestURI().toString());
            sb.append(req.getFrom().getParameter("tag"));
            sb.append(req.getCallId());
            sb.append(req.getCSeqNumber());
            sb.append(via.toString());
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Before hash, input is : " + sb.toString());
            }
            byte[] hash = this.md.digest(sb.toString().getBytes());
            sb = new StringBuilder();
            for (int i = 0; i < hash.length; ++i) {
                String d = Integer.toHexString(new Byte(hash[i]).intValue() & 0xFF);
                if (d.length() == 1) {
                    sb.append('0');
                }
                sb.append(d);
            }
            if (_log.isLoggable(Level.FINE)) {
                _log.log(Level.FINE, "Generated id, hash is : " + sb.toString());
            }
            _log.log(Level.WARNING, "Using generated transactionID rfc2543 style : " + sb.toString() + via);
            return sb.toString();
        }
        return null;
    }

    public void remove(ClientTransaction t) {
        String id = t.getTransactionId();
        this.removeClientTransaction(id);
    }

    private void removeClientTransaction(String id) {
        if (id != null) {
            this.ctMap.remove(id);
        }
    }

    public void remove(ServerTransaction t) {
        String id = t.getTransactionId();
        this.removeServerTransaction(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeServerTransaction(String id) {
        if (id != null) {
            Object mutex = this.stLockMap.get(id);
            if (mutex == null) {
                _log.warning("Failed get read mutex");
            } else {
                Object object = mutex;
                synchronized (object) {
                    this.stMap.remove(id);
                }
            }
            this.stLockMap.remove(id);
        }
    }

    public void setTimerT1(Integer t) {
        this._timerT1 = t.intValue();
    }

    public long getTimerT1() {
        return this._timerT1;
    }

    public void setTimerT2(Integer t) {
        this._timerT2 = t.intValue();
    }

    public long getTimerT2() {
        return this._timerT2;
    }

    public void setTimerT4(Integer t) {
        this._timerT4 = t.intValue();
    }

    public long getTimerT4() {
        return this._timerT4;
    }

    public long getEasSipClientTransactions() {
        return this.m_EasSipClientTransactions.longValue();
    }

    public long getEasSipServerTransactions() {
        return this.m_EasSipServerTransactions.longValue();
    }

    public long getEasTotalSipTransactionTime() {
        return this.m_EasTotalSipTransactionTime.longValue();
    }

    public long getEasTotalSipTransactionCount() {
        return this.m_EasTotalSipTransactionCount.longValue();
    }

    void recordTransactionTime(long transactionTime) {
        this.m_EasTotalSipTransactionTime.addAndGet(transactionTime);
        this.m_EasTotalSipTransactionCount.incrementAndGet();
    }

    void incrEasSipClientTransactions() {
        this.m_EasSipClientTransactions.incrementAndGet();
    }

    void incrEasSipServerTransactions() {
        this.m_EasSipServerTransactions.incrementAndGet();
    }
}

