/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.ssa.utils;

import com.ericsson.ssa.utils.StringInputStream;
import com.ericsson.ssa.utils.StringOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataSource;

public class StringDataSource
implements DataSource {
    private String source;
    private StringBuffer wsource;
    private String contentType;
    private String encoding = "UTF8";

    public StringDataSource(String contentType) {
        this.contentType = contentType;
        this.wsource = new StringBuffer();
    }

    public StringDataSource(String source, String contentType, String encoding) {
        this.source = source;
        this.contentType = contentType;
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getString() {
        return this.source != null ? this.source : this.wsource.toString();
    }

    public InputStream getInputStream() throws IOException {
        return new StringInputStream(this.source, this.encoding);
    }

    public String getName() {
        return this.toString();
    }

    public OutputStream getOutputStream() throws IOException {
        return new StringOutputStream(this.wsource);
    }
}

