/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.util.os;

import com.ericsson.util.os.OSUtil;
import com.sun.management.OperatingSystemMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.management.ManagementFactory;

public class OSUtilSunspecific
implements OSUtil {
    private static final Logger _log = Logger.getLogger("SipContainer");
    private OperatingSystemMXBean _mxbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private boolean _noPlatformSupport = false;
    private long _lastTime = System.currentTimeMillis();
    private long _lastProcessCpuTime = this._mxbean.getProcessCpuTime();
    private int _savedBusy = 0;

    public OSUtilSunspecific() {
        this._lastTime = System.currentTimeMillis();
        if (this._lastProcessCpuTime == -1L) {
            _log.log(Level.WARNING, "No platform support for com.sun.management.OperatingSystemMXBean.getProcessCpuTime()");
            this._noPlatformSupport = true;
        }
    }

    public String getInfo() {
        return this.getClass().getName() + " : Sun Microsystems' platform extensions";
    }

    public int cpuBusy() {
        if (this._noPlatformSupport) {
            return 0;
        }
        long now = System.currentTimeMillis();
        if (now - this._lastTime > 1000L) {
            long currentProcessCpuTime = this._mxbean.getProcessCpuTime();
            double busyPercent = 100L * (currentProcessCpuTime - this._lastProcessCpuTime) / (1000000L * (now - this._lastTime));
            this._lastTime = now;
            this._lastProcessCpuTime = currentProcessCpuTime;
            this._savedBusy = new Double(busyPercent).intValue();
            return this._savedBusy;
        }
        return this._savedBusy;
    }

    public static void main(String[] args) {
        OSUtilSunspecific osutil = new OSUtilSunspecific();
        Thread t = new Thread(new Runnable(){

            public long fib(int n) {
                if (n <= 1) {
                    return n;
                }
                return this.fib(n - 1) + this.fib(n - 2);
            }

            public void run() {
                int N = 35;
                for (int i = 1; i <= N; ++i) {
                    this.fib(N);
                }
            }
        });
        t.start();
        for (int i = 0; i < 10; ++i) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            System.out.println("cpuBusy = " + osutil.cpuBusy());
        }
    }
}

