/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server.group;

/**
 * Barrier Interface. A Barrier can be obtained by some
 * part of the system and can be started. The thread might wait
 * at that point of time, until the Barrier is explicitely released.
 *
 * @author Binod.
 */
public interface Barrier {            
    
    /**
     * Start the Barrier. This might force the thread to wait, if the
     * Barrier implementation need to wait on some condition.
     */
    public void start();
    
    /**
     * Start the Barrier. This might force the thread to wait, if the
     * Barrier implementation need to wait on some condition.
     * Additionally this method accepts a TIMEOUT.
     */
    public void start(long TIMEOUT);
    
    /**
     * Release the barrier. The thread waiting on start() method will be
     * released
     */
    public void release();
    
    /**
     * Release hint to the barrier. The thread waiting on start() method 
     * will be released, provided the key provided gives enough indication that
     * the barrier is no more required.
     */
    public void release(String key);
    
}
