/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.sun.enterprise.ee.server.group.core;

import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This JoinCallBack implementation will wait until all instances join the 
 * cluster. When this is invoked, it is likely that some instances are already
 * part of the cluster. The logic handles that case also.
 * 
 * @author Binod.
 */
public class JoinCallBackImpl implements com.sun.enterprise.ee.cms.core.CallBack{
    
    private Object lock = new Object();
    private GroupManagementService gms;
    private Set servers;    
        
    // Time for which the server instance need to wait expecting others
    // in the cluster to join. Ideally this will be kicked in only if one
    // instance is permanently down.
    long timeout = 1000 * 30;
    
    private Logger logger;
    
    /**
     * Creates a JoinCallBackImpl as per the GMS JOinNotification.
     * 
     * @param servers The list of servers to match against. This is
     *  taken from domain.xml
     */
    JoinCallBackImpl(GroupManagementService gms, Set servers, Logger logger) {
        this.gms = gms;
        this.logger = logger;
        this.servers = servers;
        
        String timeoutStr = 
        System.getProperty("org.glassfish.messaging.jointimeout");
        
        if (timeoutStr != null) {
            timeout = Long.valueOf(timeoutStr).longValue();
        } 
    }

    /**
     * When each instance joins the cluster, remove the joined instance
     * from the existing list, until the existing list is empty.
     */
    public void processNotification(Signal arg0) {        
        JoinNotificationSignal joinSignal = (JoinNotificationSignal) arg0;  
        synchronized (this) {
            String token = joinSignal.getMemberToken();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Removing " + token + " from" + servers.size());
            }
            servers.remove(token);
            if (servers.isEmpty()) {
                lock.notifyAll();
            }
        }
    }

    /**
     * - If all instances have already joined, then dont wait.
     * - If there is atleast one instance that need to join, wait for it
     * - to join.
     */ 
    void waitForEveryone() {        
        synchronized (this) {
            if (servers.isEmpty()) {
                return;
            }
            
            List<String> current = gms.getGroupHandle().getCurrentCoreMembers();
            for (String token : current) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("From GMS :" + token);
                }
                servers.remove(token);
            }            
            
            if (servers.isEmpty()) {
                return;
            }
            
            if (logger.isLoggable(Level.FINE)) {            
                logger.fine("Waiting for all members to join:" + timeout);
            }
            try {
                lock.wait(timeout);
            } catch (Exception e) {}
        }                        
    }
    
}
